# -*- coding: UTF-8 -*-

# LingvoSoft-LANG-VERS
# Copyright (c) 2005 Kęstutis Biliūnas <kebil@kaunas.init.lt>
#               2005 Matynas Jocius <mjoc@akl.lt>
#
# This code is licensed under the GNU GPL v2

"""
OpenDict plugin for online Ectaco dictionary
(http://www.lingvosoft.com or http://www.ectaco.com)
"""

import sys
import re
import sets
import httplib
import urllib
import socket
import HTMLParser


class MLStripper(HTMLParser.HTMLParser):
    def __init__(self):
        self.reset()
        self.fed = []
    def handle_data(self, d):
        self.fed.append(d)
    def get_fed_data(self):
        return ''.join(self.fed)



def init(libraryPath):
    """Return dictionary instance"""

    sys.path.insert(0, libraryPath)

    return WebLingvoSoft_LANG()


class WebLingvoSoft_LANG:
    """Rustran plugin class"""
    
    def __init__(self):
        """Initialize variables"""

        from lib import errortype, meta

        self.errorModule = errortype
        self.metaModule = meta

        self.encoding = "utf-8"


    def search(self, word):
        """Search for a word. Returns HTML code."""

        result = self.metaModule.SearchResult()

        try:
            self.conn = httplib.HTTPConnection("www.lingvosoft.com")
            self.conn.request("GET", "/main.jsp?do=Lingvosoft.com-" \
                "online-form_sample&DIRECT&status=translate&lang1=23" \
                "&LNGT&source="+urllib.quote(word))

            response = self.conn.getresponse()
            data = response.read()

            tresult = "<html>"
            tresult += "<head><meta http-equiv=\"Content-Type\" " \
                "content=\"text/html; charset=utf-8\"></head>"
            tresult += "<table width=\"100%\"><tr bgcolor=\"#dde2f1\"> \
                <td><font face=\"Arial, Helvetica\"><h3><b>" \
                + word + "</b></h3></font></td></tr></table>"

            data = data[data.find("<h3>Results:</h3>"):]
            data = data.strip()

            data = data[: data.find("</td>\n</tr>\n</table>\n<hr noshade " \
                "size=\"1\" color=\"#A8A8A8\">\nThis ONLINE")]
            data = data.strip()

            data = data.replace("<h3>Results:</h3>", "")
            data = data.replace("<h3>See also:</h3>", "")
            data = data.replace("javascript:showInfo()", "")
            data = data.replace("href=\"/main.jsp?do=e-services-" \
                "dictionaries-info_pop\" target=\"_blank\"", "")

#            data = tresult + data + "</body></html>"

            lines = data.split('\n')
            altLines = [l for l in lines if '<a href="/main.jsp?do=Lingvosoft.com-online-form_sample&status=translate&' in l]

            altWords = []
            for altLine in altLines:
                s = MLStripper()
                s.feed(altLine)
                word = s.get_fed_data()
                altWords.append(word)


            altWords = list(sets.Set(altWords))
            altWords.sort()

            end = data.find('See Also:')
            data = data[:end]

            data = data + "</body></html>"

            result.setTranslation(data)
            result.setWordList(altWords)

        except socket.gaierror, e:
            result.setError(self.errorModule.CONNECTION_ERROR)
            return result
        
        except httplib.CannotSendRequest, e:
            result.setError(self.errorModule.CONNECTION_ERROR)
            return result

        except:
            import traceback
            traceback.print_exc()

            result.setError(self.errorModule.INTERNAL_ERROR)

            return result

        return result
