/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xslt.model.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

import javax.xml.namespace.QName;

import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xslt.model.AttributeSet;
import org.netbeans.modules.xslt.model.ReferenceableXslComponent;
import org.netbeans.modules.xslt.model.Stylesheet;
import org.netbeans.modules.xslt.model.XslModel;
import org.netbeans.modules.xslt.model.XslReference;


/**
 * This is custom resolver for AttributeSet reference list.
 * 
 * @author ads
 *
 */
class AttributeSetReferenceListResolver implements
        ReferenceListResolveFactory
{

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.impl.ReferenceListResolveFactory#isApplicable(java.lang.Class)
     */
    public boolean isApplicable( Class referenceType ) {
        return AttributeSet.class.isAssignableFrom( referenceType );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.impl.ReferenceListResolveFactory#resolve(org.netbeans.modules.xslt.model.impl.XslComponentImpl, java.lang.Class, java.lang.String)
     */
    public <T extends ReferenceableXslComponent> List<XslReference<T>> resolve(
            AttributeAccess access, Class<T> clazz, String value )
    {
        StringTokenizer tokenizer = new StringTokenizer(value, " ");
        List<Reference<T>> references = new LinkedList<Reference<T>>();
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken();
            Collection<Reference<T>> collection = find( clazz , next , access );
            references.addAll( collection );
        }
        return null;
    }

    @SuppressWarnings("unchecked")
    private <T extends ReferenceableXslComponent> Collection<Reference<T>> 
        find( Class<T> clazz, String next , AttributeAccess access) 
    {
        assert AttributeSet.class.isAssignableFrom( clazz );
        LinkedHashSet<XslModel> list = Utilities.getAvailibleModels( 
                access.getComponent().getModel());
        Collection<Reference<T>> collection = new LinkedList<Reference<T>>();
        QName qName = getQName( next , access );
        for (XslModel model : list) {
           if ( Model.State.VALID.equals( model.getState() )) {
               Stylesheet stylesheet = model.getStylesheet();
               if ( stylesheet == null ) {
                   continue;
               }
               List<AttributeSet> children = 
                   stylesheet.getChildren( AttributeSet.class );
               Collection<AttributeSet> result = find( children , qName );
               for (AttributeSet set : result) {
                   XslReference<AttributeSet> ref = 
                       new GlobalReferenceImpl<AttributeSet>( set , 
                           AttributeSet.class , access.getComponent() );
                   if ( result != null ) {
                       collection.add( (Reference<T>) ref );
                   } 
               }
           }
        }
        return null;
    }
    
    private QName getQName( String value, AttributeAccess access ) {
        assert value!=null;
        String[] parts = value.split(":"); //NOI18N
        String prefix = null;
        String localPart;
        if (parts.length == 2) {
            prefix = parts[0];
            localPart = parts[1];
        } else {
            localPart = parts[0];
        }
        String ns = access.getComponent().lookupNamespaceURI(prefix);
        return new QName( ns , localPart , prefix );
    }

    private Collection<AttributeSet> find( 
            List<AttributeSet> children , QName qName) 
    {
        Collection<AttributeSet> collection = new LinkedList<AttributeSet>();
        assert qName != null;
        for (AttributeSet set : children) {
               QName name = set.getName();
               if ( name == null ) {
                   continue;
               }
               String localPart = name.getLocalPart();
               String ns = name.getNamespaceURI();
               if ( qName.getLocalPart().equals( localPart)  
                   && Utilities.equals( qName.getNamespaceURI() , ns ) )
               {
                   collection.add( set );
               }
       }
       return collection;
    }

}
