/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */



package org.netbeans.modules.uml.ui.products.ad.compartments;

import java.awt.Color;
import java.awt.event.MouseEvent;

import org.netbeans.modules.uml.core.preferenceframework.PreferenceAccessor;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.dynamics.ILifeline;

public class ETClassNameCompartment extends ETNameCompartment implements IADClassNameCompartment 
{

	public ETClassNameCompartment() {
		super();
		this.init();
	}

	public ETClassNameCompartment(IDrawEngine pDrawEngine) {
		super(pDrawEngine);
		this.init();
	}

	private void init() {
		this.setFontString("Arial-bold-16");
		this.m_singleClickSelect = false;
		this.initResources();
	}

	public void initResources()
	{
		if (m_name == null)
		{		
			this.setName(PreferenceAccessor.instance().getDefaultElementName());
		}
		
		setResourceID("name", Color.BLACK);

		
		// Now call the base class so it can setup any string ids we haven't already set
		super.initResources();
	}

	/**
	 * This is the name of the drawengine used when storing and reading from the product archive.
	 *
	 * @param sID[out,retval] The unique name for this compartment.  Used when reading and writing the
	 * product archive (etlp file).
	 */
	public String getCompartmentID()
	{
		return "ADClassNameCompartment";
	}
	

	// Name compartments do not need to be highlighted. Override this to allow the parent drawengine to be dragged
	public boolean handleLeftMouseButtonPressed(MouseEvent pEvent) {
		return false;
	}
	
	/*Added by Smitha- Fix for bug # 6253669*/
	public void addModelElement(IElement pElement, int pIndex)
	{
		super.addModelElement(pElement, pIndex);
		// As a fallback make sure we return something if it's an INamedElement - use
		// the name		
			if (pElement != null && pElement instanceof INamedElement && !(pElement instanceof ILifeline)) 
			{
				String name = ((INamedElement) pElement).getNameWithAlias();					
				if (name != null && name.length() > 0)
				{
					setName(name);
				} 
			}	
	}
	/*Added by Smitha*/
}

	