/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
/*
 * ServiceRefGeneralPanel.java
 *
 * Created on November 2, 2003, 10:25 AM
 */

package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice;

import java.util.ArrayList;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyVetoException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import java.util.ResourceBundle;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;

import org.netbeans.modules.j2ee.sun.share.configbean.ServiceRef;
import org.netbeans.modules.j2ee.sun.share.configbean.StorageBeanFactory;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTablePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.HelpContext;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.DynamicPropertyPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.PropertyListMapping;
import org.openide.util.NbBundle;

/**
 *
 * @author Peter Williams
 */
public class ServiceRefGeneralPanel extends javax.swing.JPanel implements TableModelListener, PropertyChangeListener {

	private final ResourceBundle webserviceBundle = NbBundle.getBundle(
		"org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.Bundle"); // NOI18N
    
	private ServiceRefCustomizer masterPanel;
	private GenericTableModel callPropertiesModel;
	private GenericTablePanel callPropertiesPanel;

	/** Creates new form ServiceRefGeneralPanel */
	public ServiceRefGeneralPanel(ServiceRefCustomizer src) {
		masterPanel = src;

		initComponents();
		initUserComponents();
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPnlServiceName = new javax.swing.JPanel();
        jLblName = new javax.swing.JLabel();
        jTxtName = new javax.swing.JTextField();
        jLblWsdlOverride = new javax.swing.JLabel();
        jTxtWsdlOverride = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        jPnlServiceName.setLayout(new java.awt.GridBagLayout());

        jLblName.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jLblName.setLabelFor(jTxtName);
        jLblName.setText(webserviceBundle.getString("LBL_ServiceReferenceName_1")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPnlServiceName.add(jLblName, gridBagConstraints);

        jTxtName.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        jPnlServiceName.add(jTxtName, gridBagConstraints);
        jTxtName.getAccessibleContext().setAccessibleName(webserviceBundle.getString("ACSN_ServiceReferenceName")); // NOI18N
        jTxtName.getAccessibleContext().setAccessibleDescription(webserviceBundle.getString("ACSD_ServiceReferenceName")); // NOI18N

        jLblWsdlOverride.setLabelFor(jTxtWsdlOverride);
        jLblWsdlOverride.setText(webserviceBundle.getString("LBL_WsdlOverride_1")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        jPnlServiceName.add(jLblWsdlOverride, gridBagConstraints);

        jTxtWsdlOverride.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTxtWsdlOverrideKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPnlServiceName.add(jTxtWsdlOverride, gridBagConstraints);
        jTxtWsdlOverride.getAccessibleContext().setAccessibleName(webserviceBundle.getString("ACSN_WsdlOverride")); // NOI18N
        jTxtWsdlOverride.getAccessibleContext().setAccessibleDescription(webserviceBundle.getString("ACSD_WsdlOverride")); // NOI18N

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 5);
        add(jPnlServiceName, gridBagConstraints);

        getAccessibleContext().setAccessibleName(webserviceBundle.getString("ACSN_GeneralTab")); // NOI18N
        getAccessibleContext().setAccessibleDescription(webserviceBundle.getString("ACSD_GeneralTab")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

	private void jTxtWsdlOverrideKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTxtWsdlOverrideKeyReleased
		// Add your handling code here:
        ServiceRef bean = masterPanel.getBean();
		if(bean != null) {
			try {
				bean.setWsdlOverride(jTxtWsdlOverride.getText());
			} catch(java.beans.PropertyVetoException exception) {
				jTxtWsdlOverride.setText(bean.getWsdlOverride());
			}
		}
	}//GEN-LAST:event_jTxtWsdlOverrideKeyReleased


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLblName;
    private javax.swing.JLabel jLblWsdlOverride;
    private javax.swing.JPanel jPnlServiceName;
    private javax.swing.JTextField jTxtName;
    private javax.swing.JTextField jTxtWsdlOverride;
    // End of variables declaration//GEN-END:variables

	private void initUserComponents() {
		/** Add call properties table panel :
		 *  TableEntry list has two properties: Name, Value
		 */
		ArrayList tableColumns = new ArrayList(2);
		tableColumns.add(new GenericTableModel.ValueEntry("Name",				// NOI18N - property name
			webserviceBundle.getString("LBL_Name_Column"), true));	// NOI18N
		tableColumns.add(new GenericTableModel.ValueEntry("Value",				// NOI18N - property name
			webserviceBundle.getString("LBL_Value_Column"), true));	// NOI18N

        callPropertiesModel = new GenericTableModel(callPropertyFactory, tableColumns);
        callPropertiesModel.addTableModelListener(this);
		callPropertiesPanel = new GenericTablePanel(callPropertiesModel,
			webserviceBundle, "CallProperties",	// NOI18N - property name
			DynamicPropertyPanel.class, HelpContext.HELP_SERVICE_CALL_PROPERTY_POPUP,
			PropertyListMapping.getPropertyList(PropertyListMapping.SERVICE_REF_CALL_PROPERTIES));

        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
		gridBagConstraints.insets = new Insets(0, 6, 0, 5);
		add(callPropertiesPanel, gridBagConstraints);
	}

	/** Initialization of all the fields in this panel from the bean that
	 *  was passed in.
	 */
	public void initFields(ServiceRef bean) {
		jTxtName.setText(bean.getServiceRefName());
		jTxtWsdlOverride.setText(bean.getWsdlOverride());

		callPropertiesPanel.setModel(bean.getCallProperties(), bean.getAppServerVersion());
	}
	
	protected void addListeners(ServiceRef bean) {
		bean.addPropertyChangeListener(this);
	}

	protected void removeListeners(ServiceRef bean) {
		bean.removePropertyChangeListener(this);
	}

	/**
	 * Implementation of the PropertyChangeListener interface
	 */
	public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
		if(ServiceRef.SERVICE_REF_NAME.equals(propertyChangeEvent.getPropertyName())) {
			ServiceRef bean = masterPanel.getBean();
			if(bean != null) {
				jTxtName.setText(bean.getServiceRefName());
			}
		}
	}	

	/** -----------------------------------------------------------------------
	 *  Implementation of javax.swing.event.TableModelListener
	 */
	public void tableChanged(TableModelEvent e) {
		ServiceRef bean = masterPanel.getBean();
		if(bean != null) {
			try {
				bean.setCallProperties(callPropertiesModel.getData());

				// Force property change to be issued by the bean
				bean.setDirty();
			} catch(PropertyVetoException ex) {
				// FIXME undo whatever changed... how?
			}
		}
	}
    
    // New for migration to sun DD API model.  Factory instance to pass to generic table model
    // to allow it to create callProperty beans.
    private static GenericTableModel.ParentPropertyFactory callPropertyFactory =
        new GenericTableModel.ParentPropertyFactory() {
            public CommonDDBean newParentProperty(ASDDVersion asVersion) {
                return StorageBeanFactory.getStorageBeanFactory(asVersion).createCallProperty();
            }
        };
}
