/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
/*
 * EntityEjbPanel.java        Feb 20, 2005, 6:11 PM
 *
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.ejbmodule;

import java.beans.PropertyVetoException;
import javax.swing.JPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseEjb;

import org.netbeans.modules.j2ee.sun.share.configbean.StatefulEjb;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;


/**
 *
 * @author  Rajeshwar Patil
 * @version %I%, %G%
 */
public class StatefulEjbPanel extends JPanel {

    private StatefulEjbCustomizer masterPanel;


    /** Creates new form StatefulEjbPanel */
    public StatefulEjbPanel(StatefulEjbCustomizer src) {
        this.masterPanel = src;
        initComponents();
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        availabilityEnabledLabel = new javax.swing.JLabel();
        availabilityEnabledComboBox = new javax.swing.JComboBox();

        setLayout(new java.awt.GridBagLayout());

        availabilityEnabledLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("MNC_Avaiability_Enabled").charAt(0));
        availabilityEnabledLabel.setLabelFor(availabilityEnabledComboBox);
        availabilityEnabledLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Availability_Enabled"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 0);
        add(availabilityEnabledLabel, gridBagConstraints);
        availabilityEnabledLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Availability_Enabled_Acsbl_Name"));
        availabilityEnabledLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Availability_Enabled_Acsbl_Desc"));

        availabilityEnabledComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "", "true", "false" }));
        availabilityEnabledComboBox.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Availability_Enabled_Tool_Tip"));
        availabilityEnabledComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                availabilityEnabledComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 72;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 5);
        add(availabilityEnabledComboBox, gridBagConstraints);
        availabilityEnabledComboBox.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Availability_Enabled_Acsbl_Name"));
        availabilityEnabledComboBox.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Availability_Enabled_Acsbl_Desc"));

    }// </editor-fold>//GEN-END:initComponents

    private void availabilityEnabledComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_availabilityEnabledComboBoxActionPerformed
        StatefulEjb theBean = masterPanel.getStatefulBean();
        if(theBean != null) {
            String newAvailability = (String) availabilityEnabledComboBox.getSelectedItem();
            String oldAvailability = theBean.getAvailabilityEnabled();
            try {
                if(!Utils.strEquivalent(oldAvailability, newAvailability)) {
                    if(Utils.notEmpty(newAvailability)) {
                        theBean.setAvailabilityEnabled(newAvailability);
                    } else {
                        theBean.setAvailabilityEnabled(null);
                    }

//                    theBean.firePropertyChange("statefulAvailabilityEnabled", oldAvailability, newAvailability); // NOI18N
                    masterPanel.validateField(StatefulEjb.FIELD_STATEFUL_AVAILABILITY);
                }
            } catch (PropertyVetoException ex) {
                availabilityEnabledComboBox.setSelectedItem(oldAvailability);
            }
        }
    }//GEN-LAST:event_availabilityEnabledComboBoxActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox availabilityEnabledComboBox;
    private javax.swing.JLabel availabilityEnabledLabel;
    // End of variables declaration//GEN-END:variables

    public void initFields(StatefulEjb theBean) {
        if(theBean != null) {
            availabilityEnabledComboBox.setSelectedItem(theBean.getAvailabilityEnabled());
        }
    }
}
