/*
 * SelectFromListPanel.java
 *
 * Created on 21 Сентябрь 2007 г., 14:44
 */

package org.netbeans.modules.php.project.ui.actions;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

/**
 *
 * @author  avk
 */
public class SelectFromListPanel<T extends Object> extends javax.swing.JPanel {
    
    /** Creates new form SelectFromListPanel */
    private SelectFromListPanel(String message, T[] items) {
        initComponents();
        
        init(message, items);
        
    }

    private T getUsersSelection() {
        Object obj = myList.getSelectedValue();
        return (T) obj;
    }

    public static Object askUserToChoose(String title, String message, Object[] list){
        SelectFromListPanel panel = new SelectFromListPanel(message, list);
        
        DialogDescriptor dDescriptor = new DialogDescriptor(
                panel, 
                title, 
                true,
                DialogDescriptor.OK_CANCEL_OPTION, 
                DialogDescriptor.OK_OPTION, 
                null);
        if (DialogDisplayer.getDefault().notify(dDescriptor) == DialogDescriptor.OK_OPTION){
            return panel.getUsersSelection();
        }
        return null;
        
    }
    
    private void init(String message, T[] items){
        myMessage.setText(message);
        initList(myList, items);
    }
    
    private void initList(JList list, T[] items){
        DefaultListModel model = new DefaultListModel();
        for (T item : items ){
            model.addElement(item);
        }
        list.setModel(model);
        list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        myList = new javax.swing.JList();
        myMessage = new javax.swing.JLabel();

        jScrollPane1.setViewportView(myList);

        myMessage.setText(org.openide.util.NbBundle.getMessage(SelectFromListPanel.class, "SelectFromListPanel.LBL_DefaultText")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 339, Short.MAX_VALUE)
                    .add(myMessage))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(myMessage)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 60, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JList myList;
    private javax.swing.JLabel myMessage;
    // End of variables declaration//GEN-END:variables
    
}
