/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.exceptions.bugs;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.exceptions.bugs.issuezilla.IssuezillaReporter;
import org.netbeans.modules.exceptions.entity.Exceptions;

/**
 *
 * @author honza
 */
public class BugReporterFactory {
    
    private static Reporters DEFAULT = Reporters.IssuezillaReporter;
    private static Map<Reporters, BugReporter> instances = new EnumMap<Reporters, BugReporter>(Reporters.class);
    /**
     * returns instance of BugReporter for Issuezilla
     * 
     * @return 
     */
    public static BugReporter getDefaultReporter(){
        switch(DEFAULT){
        case IssuezillaReporter:
            return getIssuezillaReporter();
        case LogReporter: 
            return new LogReporter();
        default: throw new IllegalArgumentException("UNKNOWN TYPE");
        }
    }
    
    public static void setDefault(Reporters reporter){
        DEFAULT = reporter;
    }
    
    public static BugReporter getIssuezillaReporter() {
        BugReporter instance = instances.get(Reporters.IssuezillaReporter);
        if (instance == null) {
            synchronized (BugReporterFactory.class) {
                if (instances.get(Reporters.IssuezillaReporter) == null) {
                    instance = new IssuezillaReporter();
                    instances.put(Reporters.IssuezillaReporter, instance);
                } else {
                    instance = instances.get(Reporters.IssuezillaReporter);
                }
            }
        }
        return instance;
    }

    private static final class LogReporter implements BugReporter{

        public void reportException(Exceptions exceptions, Properties props) {
            LogRecord log = new LogRecord(Level.INFO, "BUG REPORTER");
            List<String> parameters = new ArrayList<String>(3);
            parameters.add(exceptions.getSummary());
            parameters.add(props.getProperty("username"));
            parameters.add(props.getProperty("password"));
            log.setParameters(parameters.toArray());
            Logger.getLogger(BugReporterFactory.class.getName()).log(log);
        }

        public void postTextComment(int issueId, Properties props, String text) {
            LogRecord log = new LogRecord(Level.INFO, "BUG REPORTER");
            List<String> parameters = new ArrayList<String>(4);
            parameters.add(Integer.toString(issueId));
            parameters.add(props.getProperty("username"));
            parameters.add(props.getProperty("password"));
            parameters.add(text);
            log.setParameters(parameters.toArray());
            Logger.getLogger(BugReporterFactory.class.getName()).log(log);
        }
    }
    
    public enum Reporters{LogReporter, IssuezillaReporter};
    
}
