/*
 * PortTypeNode.java
 * 
 * Created on Jun 12, 2007, 6:36:52 PM
 * 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.netbeans.modules.worklist.node;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.util.Utilities;

/**
 *
 * @author radval
 */
public class PortTypeNode extends WSDLComponentNode {

      /** Icon for the Ip msg button.    */
    private static Image ICON  = Utilities.loadImage
             ("org/netbeans/modules/worklist/editor/view/resources/port_type_badge.png");
   
    public PortTypeNode(PortType portType) {
        super(portType, new PortTypeChildren(portType));
    }

     @Override
    public Image getIcon(int type) {
        return ICON;
    }

    @Override
    public Image getOpenedIcon(int type) {
        return ICON;
    }
    
     protected void updateDisplayName() {
        PortType portType = (PortType) getWSDLComponent();
        String name = portType.getName();
        
        if (name == null) {
//            name = NbBundle.getMessage(DefinitionsNode.class,
//                    "LBL_DefinitionsNode_NoTargetNamespace");
            name = "No TargetNamespace";
        }
        setDisplayName(name);
    }
     
    public static final class PortTypeChildren extends GenericWSDLComponentChildren {
        
        List<Class<? extends WSDLComponent>> filters;
        public PortTypeChildren(PortType portType) {
            super(portType);
        }
        
        
        
   
        protected Collection getKeys() {
            Collection<Object> keys = new ArrayList<Object>();
            
            
            PortType portType = (PortType) getWSDLComponent();
            
            
            if (portType != null) {
                Collection<Operation> operations =  portType.getOperations();
                keys.addAll(operations);
            }
            

            return keys;
        }

      
    }
    
}
