/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * 
 * Copyright 2005 Sun Microsystems, Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

package org.netbeans.modules.dcomwizard.wizards;

import javax.swing.*;
import javax.swing.filechooser.*;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Arrays;
import java.io.File;
import java.io.FileOutputStream;

import javax.swing.event.ChangeListener;
import javax.swing.event.ChangeEvent;

import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;

import org.netbeans.modules.dcomwizard.builder.wsdl.GenerateWSDL;

/**
 * @author Chandrakanth Belde.
 */
public class DCOMWizardPanel extends javax.swing.JPanel implements WizardDescriptor.Panel {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    private static final boolean enableNext = false;

    private static final String WSDLGEN_NAME = "Select WSDL Generator path";

    private static final String BINARY_NAME = "Select Binary file path";

    private static final String SOAPTOOLKIT_LOC = "Select Soaptoolkit location";

    protected final Set listeners = new HashSet(1);

    private  ExtensionFileFilter filter = null;

    /** Creates new form DCOMWizardPanel */
    public DCOMWizardPanel(final String title) {
        if (title != null && title.trim().length() != 0) {
            this.setName(title);
        }
		this.initComponents();
    }

    /**
     * intializes the components
     */
    private void initComponents() {
        this.jLabel1 = new javax.swing.JLabel();
        this.jLabel2 = new javax.swing.JLabel();
        this.jLabel3 = new javax.swing.JLabel();

        this.jChooser1 = new javax.swing.JTextField();
        /*this.filter = new ExtensionFileFilter(); 		
        this.filter.addExtension(".WGen"); 
        this.filter.setDescription("WGen files"); 
        this.jChooser1.setFileFilter(this.filter); */

        this.jChooser2 = new javax.swing.JTextField();
        /*this.filter = new ExtensionFileFilter(); 		
        this.filter.addExtension(".dll"); 
        this.filter.setDescription("DLL files"); 
        this.jChooser2.setFileFilter(this.filter); */

        this.jChooser3 = new javax.swing.JTextField();
        /*this.filter = new ExtensionFileFilter(); 		
        this.filter.addExtension(".exe"); 
        this.filter.setDescription("EXE files"); 
        this.jChooser3.setFileFilter(this.filter); */

        this.jLabel1.setText(WSDLGEN_NAME);
        this.jLabel2.setText(BINARY_NAME);
        this.jLabel3.setText(SOAPTOOLKIT_LOC);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        /*  layout.setHorizontalGroup(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(
                layout.createSequentialGroup().add(55, 55, 55).add(this.jLabel1,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 70,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE).add(28, 28, 28).add(this.jChooser1,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 179,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE).addContainerGap(68, Short.MAX_VALUE)));

        layout.setVerticalGroup(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(
                layout.createSequentialGroup().add(133, 133, 133).add(
                        layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE).add(this.jLabel1).add(
                                this.jChooser1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)).addContainerGap(128, Short.MAX_VALUE))); */

        layout.setHorizontalGroup(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(
                layout.createSequentialGroup().add(60, 60, 60).add(
                        layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false).add(
                                org.jdesktop.layout.GroupLayout.LEADING,
                                layout.createSequentialGroup().add(this.jLabel1,
                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 150,
                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE).add(50, 50, 50).add(
                                        this.jChooser1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 300,
                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)).add(
                                layout.createSequentialGroup().add(this.jLabel2,
                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 150,
                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE).add(50, 50, 50).add(
                                        this.jChooser2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 300,
                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)).add(
                                layout.createSequentialGroup().add(this.jLabel3,
                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 150,
                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE).add(50, 50, 50).add(
                                        this.jChooser3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 300,
                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))).addContainerGap(120, Short.MAX_VALUE)));

        layout.setVerticalGroup(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(
                layout.createSequentialGroup().add(90, 90, 90).add(
                        layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE).add(this.jLabel1).add(
                                this.jChooser1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 20,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)).add(
                        layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE).add(this.jLabel2).add(
                                this.jChooser2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 20,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)).add(
                        layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE).add(this.jLabel3).add(
                                this.jChooser3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 20,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)).addContainerGap(60, Short.MAX_VALUE)));

	}

    /**
     * @return
     */
    public Component getComponent() {
        return this;
    }

    /**
     * @return
     */
    public HelpCtx getHelp() {
        // Show no Help button for this panel:
        return HelpCtx.DEFAULT_HELP;
    }

    /**
     * @param settings
     */
    public void readSettings(final Object settings) {
        WizardDescriptor wd = null;
        if (settings instanceof DCOMWizardContext) {
            final DCOMWizardContext wizardContext = (DCOMWizardContext) settings;
            wd = (WizardDescriptor) wizardContext.getProperty(DCOMWizardContext.WIZARD_DESCRIPTOR);

        } else if (settings instanceof WizardDescriptor) {
            wd = (WizardDescriptor) settings;
        }
        final Object selectedOption = wd.getValue();
        final boolean isAdvancingPanel = selectedOption == WizardDescriptor.NEXT_OPTION
                || selectedOption == WizardDescriptor.FINISH_OPTION;

        if (isAdvancingPanel) {

        }

    }

    /**
     * @param settings
     */
    public void storeSettings(final Object settings) {
        WizardDescriptor wd = null;
        if (settings instanceof DCOMWizardContext) {
            final DCOMWizardContext wizardContext = (DCOMWizardContext) settings;
            wd = (WizardDescriptor) wizardContext.getProperty(DCOMWizardContext.WIZARD_DESCRIPTOR);

        } else if (settings instanceof WizardDescriptor) {
            wd = (WizardDescriptor) settings;
        }

        if (wd != null) {

            final Object selectedOption = wd.getValue();
            if (NotifyDescriptor.CANCEL_OPTION == selectedOption || NotifyDescriptor.CLOSED_OPTION == selectedOption) {
                return;
            }
            // Need to revisit the code here
            final boolean isAdvancingPanel = selectedOption == WizardDescriptor.NEXT_OPTION
                    || selectedOption == WizardDescriptor.FINISH_OPTION;

            if (isAdvancingPanel) {
                try {
                    final String targetFolderPath = (String) wd.getProperty(DCOMWizardContext.TARGETFOLDER_PATH);
                    final String bindingName = (String) wd.getProperty(DCOMWizardContext.BINDING_NAME);

                    // Generate WSDL
                    /*final String mWsdlGenFilePath = this.jChooser1.getSelectedFile().getAbsolutePath().trim();
                    final String mBinaryFilePath = this.jChooser2.getSelectedFile().getAbsolutePath().trim();
                    final String mWSDLGenExePath = this.jChooser3.getSelectedFile().getAbsolutePath().trim();*/
                    final String mWsdlGenFilePath = this.jChooser1.getText().trim();
                    final String mBinaryFilePath = this.jChooser2.getText().trim();
                    final String mWSDLGenExePath = this.jChooser3.getText().trim();
                    final String wsdlFilePath = (String) wd.getProperty(DCOMWizardContext.WSDLFILE_PATH);
                    final GenerateWSDL tsk = new GenerateWSDL();

                    tsk.setSrcDirectoryLocation(targetFolderPath);
                    tsk.setWSDLFileName(bindingName);
                    tsk.setWsdlGenFilePath(mWsdlGenFilePath);
                    tsk.setBinaryFilePath(mBinaryFilePath);
                    tsk.setWsdlGenExePath(mWSDLGenExePath);

                    tsk.execute();
                } catch (final Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
	
    /**
     * @param l
     */
    public void addChangeListener(final ChangeListener l) {
        synchronized (this.listeners) {
            this.listeners.add(l);
        }
    }

    /**
     * @param l
     */
    public void removeChangeListener(final ChangeListener l) {
        synchronized (this.listeners) {
            this.listeners.remove(l);
        }
    }

    /**
     * 
     *
     */
    public void fireChangeEvent() {
        Iterator it;

        synchronized (this.listeners) {
            it = new HashSet(this.listeners).iterator();
        }

        final ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener) it.next()).stateChanged(ev);
        }
    }

    /**
     * @see org.openide.WizardDescriptor.Panel#isValid
     */
    public boolean isValid() {
        if (this.enableNext) {
            return true;
        }

        return super.isValid();
    }

    // Variables declaration - do not modify
    private javax.swing.JLabel jLabel1; // label for Wsdl Generator 
    private javax.swing.JLabel jLabel2; // label for binary file (.dll)
    private javax.swing.JLabel jLabel3; // label for wsdlgenerator (.exe)

    private javax.swing.JTextField jChooser1; //file chooser for WGen file
    private javax.swing.JTextField jChooser2; //file chooser for .dll file
    private javax.swing.JTextField jChooser3; //file chooser for .exe file
    // End of variables declaration

}
