/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * 
 * Copyright 2005 Sun Microsystems, Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package org.netbeans.modules.dcomwizard.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/**
 * Wizard to collect name of the binary and create new DCOM Binding wsdl.
 *
 * @author Chandrakanth Belde
 * @version $Revision: 1.1 $
 */
 
 public class DCOMBindingWizard extends DCOMWizard {
    /**
     * 
     *
     */
    public DCOMBindingWizard() {
    }

    class Descriptor extends DCOMWizardDescriptor {
        public Descriptor(final WizardDescriptor.Iterator iter) {
            super(iter, DCOMBindingWizard.this.context);
	}
    }

    class WizardIterator extends DCOMWizardIterator {

        private WizardDescriptor.Panel bindingNamePanel;

        private DCOMWizardFinishPanel binarySelectionPanel;

        private List panels;

        private DCOMBindingWizard mWizard;

        public WizardIterator(final DCOMBindingWizard wizard) {
            this.mWizard = wizard;

            this.bindingNamePanel = new DCOMWizardNameFinishPanel(DCOMBindingWizard.this, NbBundle.getMessage(
                    DCOMBindingWizard.class, "TITLE_bndwizard_name"));

        }

        public String name() {
            return "";
        }

        public void initialize(final WizardDescriptor wiz) {
            this.mWizard.setDescriptor(wiz);
            super.initialize(wiz);
        }

        /**
		 *
         * @see org.openide.WizardDescriptor.Iterator#nextPanel
         */
        public void nextPanel() {
            super.nextPanel(); // Otherwise allow advance.
        }

        /**
         *
         * @see org.openide.WizardDescriptor.Iterator#previousPanel
         */
        public void previousPanel() {
            super.previousPanel(); // Otherwise use parent implementation.
        }

        protected List createPanels(final WizardDescriptor wiz) {

            Project project = Templates.getProject(wiz);
            if (project != null) {
                Sources sources = ProjectUtils.getSources(project);
                SourceGroup[] groups = sources.getSourceGroups(Sources.TYPE_GENERIC);

                if (groups == null || groups.length < 1) {
                    groups = sources.getSourceGroups(Sources.TYPE_GENERIC);
                }

                this.bindingNamePanel = new SimpleTargetChooserPanel(project, groups, null, false);
            }


            //need to rework
            this.binarySelectionPanel = new DCOMWizardFinishPanel(NbBundle.getMessage(DCOMBindingWizard.class,
                    "TITLE_bndwizard_selectbinary"));

            this.panels = new ArrayList(2);
            if (this.bindingNamePanel != null) {
                this.panels.add(this.bindingNamePanel);
            }
            this.panels.add(this.binarySelectionPanel);
            return Collections.unmodifiableList(this.panels);
        }

        protected String[] createSteps() {
            try {
                return new String[] {
                        // TODO - need make wizard steps text match actual panel being viewed
                        "Choose File Type", // TODO - use bundle property
                        NbBundle.getMessage(DCOMBindingWizard.class, "STEP_bndwizard_name"),
                        NbBundle.getMessage(DCOMBindingWizard.class, "STEP_bndselection_name")};
            } catch (final MissingResourceException e) {
                return new String[] {};
            }
        }
    }

    /** Key name used to reference wsdl generator in wizard context. */
    public static final String WSDL_GENERATOR = "wsdl_generator";

	/** Key name used to reference binary sources in wizard context. */
    public static final String BINDING_SOURCE = "binding_source";

    /** Key name used to reference WSDL Name. */
    public static final String WSDL_NAME = "wsdl_name";

    /** Key name used to reference binding name in wizard context. */
    public static final String BINDING_NAME = "binding_name";

    /** Key name used to reference Project in wizard context. */
    public static final String PROJECT = "project";

    /** Key name used to reference Collection of runtime input args in wizard context. */
    public static final String RUNTIME_INPUTS = "runtime_inputs";

    public static final int SOURCE_PANEL_INDEX = 1;

    /* Defines panels to be displayed */
    private WizardDescriptor descriptor;

    /* Wizard iterator; handles display and movement among wizard panels */
    private DCOMWizardIterator iterator;

    private Project project;

    public DCOMBindingWizard(Project prj) {
        this.project = prj;
    }

    public static WizardDescriptor.Iterator newTemplateIterator() {
        final DCOMBindingWizard wizard = new DCOMBindingWizard();
        wizard.initialize();
        return wizard.getIterator();
    }

    /**
     * @see DCOMWizard#getDescriptor
     */
    public WizardDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new Descriptor(this.iterator);
        }
        return this.descriptor;
    }

    public void setDescriptor(final WizardDescriptor wd) {
        this.descriptor = wd;
    }

    /**
     * @see DCOMWizard#getIterator
     */
    public WizardDescriptor.Iterator getIterator() {
        return this.iterator;
    }

    // public Project getProject() {
    // return project;
    // }

    /**
     * Initializes iterator and descriptor for this wizard.
     */
    public void initialize() {
        this.iterator = new WizardIterator(this);

    }

    /**
     * Performs processing to handle cancellation of this wizard.
     */
    protected void cancel() {
    }

    /**
     * Performs processing to cleanup any resources used by this wizard.
     */
    protected void cleanup() {
    }

    protected String getDialogTitle() {
        return NbBundle.getMessage(DCOMBindingWizard.class, "TITLE_dlg_new_binding");
    }

}
