/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.sql.framework.evaluators.database.base;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.netbeans.modules.sql.framework.evaluators.database.StatementContext;
import org.netbeans.modules.sql.framework.evaluators.database.TypeEvaluator;
import org.netbeans.modules.sql.framework.model.SQLCastOperator;
import org.netbeans.modules.sql.framework.model.SQLConstants;
import org.netbeans.modules.sql.framework.model.SQLObject;
import org.netbeans.modules.sql.framework.model.SQLOperatorArg;
import org.netbeans.modules.sql.framework.model.SQLOperatorDefinition;

import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.utils.StringUtil;

/**
 * Handles evaluation of cast-as SQL operator.
 *
 * @author Ritesh Adval
 * @author Jonathan Giron
 * @version $Revision: 1.2 $
 */
public class BaseCastAsOperatorEvaluator extends BaseOperatorEvaluator {

    /**
     * Overrides parent implementation to correctly generate a cast-as operator expression
     * from the given SQLObject, using the given StatementContext
     * 
     * @param obj SQLObject (SQLCastOperator) to be evaluated
     * @param context StatementContext to use in generating expression
     * @return cast-as operator expression
     * @see org.netbeans.modules.sql.framework.evaluators.database.Evaluator#evaluate(org.netbeans.modules.sql.framework.model.SQLObject, org.netbeans.modules.sql.framework.evaluators.database.StatementContext)
     */
    public String evaluate(SQLObject obj, StatementContext context) throws BaseException {
        String result;
        SQLCastOperator operator = (SQLCastOperator) obj;

        // Get all necessary data.
        Map params = operator.getSQLObjectMap();

        // Allow overrideable operator factory so other db's can override date add
        SQLOperatorDefinition defn = this.getDB().getOperatorFactory().getSQLOperatorDefinition(operator.getOperatorType());

        Map resolvedparams = new HashMap();
        List args = defn.getArgList();

        for (int i = 0; i < args.size(); i++) {
            String key = ((SQLOperatorArg) args.get(i)).getArgName();
            SQLObject val = (SQLObject) params.get(key);

            if (val != null) {
                resolvedparams.put(key, this.getEvaluatorFactory().evaluate(val, context));
            }
        }
        
        int jdbcTypeInt = operator.getJdbcType();
        int precision = operator.getPrecision();
        int scale = operator.getScale();

        TypeEvaluator typeEvaluator = this.getDB().getTypeEvaluator();
        resolvedparams.put("type", typeEvaluator.evaluate(jdbcTypeInt, precision, scale));

        result = StringUtil.replace(defn.getScript(), resolvedparams, SQLConstants.OPERATOR_VARIABLE_PREFIX);
        return result;
    }
}
