/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.nodes.impl;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeTypeFinderVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.view.expression.impl.MapperUtil;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ui.highlight.Highlight;
import org.netbeans.modules.xml.xam.ui.highlight.HighlightManager;
import org.netbeans.modules.xml.xam.ui.highlight.Highlighted;

/**
 *
 * @author radval
 *
 */
public abstract class AbstractTreeNode extends AbstractNode
implements TreeNode, Cloneable, Highlighted {
    
    private static final Logger LOGGER = Logger.getLogger(AbstractTreeNode.class.getName());
    
    private static final Color HIGHLIGHT_SEARCH_RESULT             = new Color(230, 139, 44);
    private static final Color HIGHLIGHT_SEARCH_RESULT_PARENT      = new Color(255, 199, 60);
    private static final Color HIGHLIGHT_FIND_USAGES_RESULT_PARENT = new Color(181, 230, 130);
    private static final Color HIGHLIGHT_FIND_USAGES_RESULT        = new Color(139, 230, 44);

    private TreeNode mParent;
    protected List mChildren = new ArrayList();
    
    //QName should have namespace and local name
    private QName mXSDType;
    
    /** Used for the highlighting API. */
    private Set<Component> referenceSet;
    /** Ordered list of highlights applied to this node. */
    private List<Highlight> highlights;
    /** Color of the active highlight */
    private Color mHighlightColor;
    
    
    public AbstractTreeNode(Object dataObject) {
        super(dataObject);
        
        if (dataObject instanceof Component) {
            referenceSet = Collections.singleton((Component) dataObject);
            highlights = new LinkedList<Highlight>();
            HighlightManager.getDefault().addHighlighted(this);
        }
    }
    
    
    /** Used for the highlighting API. */
    public Set<Component> getComponents() {
        return referenceSet;
    }

    public void highlightAdded(Highlight hl) {
        mHighlightColor = null;
        highlights.add(hl);
        applyHighlights();
    }

    public void highlightRemoved(Highlight hl) {
        mHighlightColor = null;
        highlights.remove(hl);
        applyHighlights();
    }

    public Color getHighlightColor() {
        return mHighlightColor;
    }
    
    // Set the appropriate highlight color for this node.
    private void applyHighlights() {
        int count = highlights.size();
        if (count > 0) {
            // Apply the last highlight that was added to our list.
            Highlight hl = highlights.get(count - 1);
            String type = hl.getType();
            String code = null;
            if (type.equals(Highlight.SEARCH_RESULT)) {
                mHighlightColor = AbstractTreeNode.HIGHLIGHT_SEARCH_RESULT;
            } else if (type.equals(Highlight.SEARCH_RESULT_PARENT)) {
                mHighlightColor = AbstractTreeNode.HIGHLIGHT_SEARCH_RESULT_PARENT;
            }  else if (type.equals(Highlight.FIND_USAGES_RESULT_PARENT)) {
                mHighlightColor = AbstractTreeNode.HIGHLIGHT_FIND_USAGES_RESULT_PARENT;
            }else if (type.equals(Highlight.FIND_USAGES_RESULT)) {
                mHighlightColor = AbstractTreeNode.HIGHLIGHT_FIND_USAGES_RESULT;
            }
        }
    }

    public IMapperNode getInputFieldNode(Node input) {
        return this.getMapperNode();
    }
    
    public IMapperNode getOutputFieldNode(Node output) {
        return this.getMapperNode();
    }
    
    public void addChild(TreeNode child) {
        if (child != null) {
            child.setParent(this);
            this.mChildren.add(child);
        }
    }
    
    public void removeChild(TreeNode child) {
        if (child != null) {
            child.setParent(null);
            this.mChildren.remove(child);
        }
    }
    
    public void addChild(int index, TreeNode child) {
        if (child != null && index <= this.mChildren.size()) {
            child.setParent(this);
            this.mChildren.add(index, child);
        }
    }
    
    public List getChildren() {
        if (this.mChildren.size() == 0) {
            try {
                lazyLoadChildren();
            } catch (IllegalStateException e) {
                mChildren.clear();
                LOGGER.log(Level.SEVERE, e.getMessage());
            }
        }
        return this.mChildren;
    }
    
    public void renewChildren() {
        mChildren = new ArrayList();
    }
    
     public boolean isLeaf() {
        return (getChildren().size() == 0);
    }
    
    public TreeNode getParent() {
        return this.mParent;
    }
    
    public void setParent(TreeNode parent) {
        this.mParent  = parent;
    }
    
    protected void lazyLoadChildren() {
    }
    
    public TreeNode getChild(String name) {
        if (name == null) {
            return null;
        }
        
        Iterator it = getChildren().iterator();
        while (it.hasNext()) {
            TreeNode node = (TreeNode) it.next();
            if(name.equals(node.getName())) {
                return node;
            }
        }
        
        return null;
    }
    
    public QName getXSDType() {
        if (this.mXSDType == null) {
            NodeTypeFinderVisitor ntFinder = new NodeTypeFinderVisitor();
            this.accept(ntFinder);
            this.mXSDType = ntFinder.getType();
        }
        return  this.mXSDType;
    }
    
    
    public TreeNode getChild(int index) {
        if (mChildren != null && mChildren.size() > index) {
            return (TreeNode) mChildren.get(index);
        }
        return null;
    }
    
    public int hashCode() {
        return getDataObject().hashCode();
    }
    
    public boolean equals(Object ob) {
        if (ob instanceof AbstractTreeNode) {
            AbstractTreeNode other = (AbstractTreeNode) ob;
            if (other.getDataObject() == getDataObject()) {
                return true;
            }
        }
        return false;
    }
    
    public TreeNode duplicate() throws CloneNotSupportedException {
        // Create a new instance of this object, but keep
        // all instance variables the same.
        return (TreeNode) this.clone();
    }
    
    /**
     * Gets the list of connected model input nodes to this tree node.
     * @return null if no input nodes are connected
     */
    public List getConnectedInputNodes() {
        List connectedNodes = new ArrayList();
        IMapperTreeNode mapperTreeNode = (IMapperTreeNode) getMapperNode();
        if (mapperTreeNode != null) {
            List mapperNodes = mapperTreeNode.getPreviousNodes();
            for (Iterator iter=mapperNodes.iterator(); iter.hasNext();) {
                IMapperNode mapperNode = (IMapperNode) iter.next();
                if (mapperNode != null) {
                    Object modelNode = MapperUtil.getMapperNodeObject(mapperNode);
                    if (modelNode != null) {
                        connectedNodes.add(modelNode);
                    }
                }
            }
        }
        return connectedNodes;
    }
    
    /**
     * Gets the list of connected model output nodes to this tree node.
     * @return null if no output nodes are connected
     */
    public List getConnectedOutputNodes() {
        List connectedNodes = new ArrayList();
        IMapperTreeNode mapperTreeNode = (IMapperTreeNode) getMapperNode();
        if (mapperTreeNode != null) {
            List mapperNodes = mapperTreeNode.getNextNodes();
            for (Iterator iter=mapperNodes.iterator(); iter.hasNext();) {
                IMapperNode mapperNode = (IMapperNode) iter.next();
                if (mapperNode != null) {
                    Object modelNode = MapperUtil.getMapperNodeObject(mapperNode);
                    if (modelNode != null) {
                        connectedNodes.add(modelNode);
                    }
                }
            }
        }
        return connectedNodes;
    }
    
    public List getConnectedNodes() {
        List connectedNodes = new ArrayList();
        connectedNodes.addAll(getConnectedOutputNodes());
        connectedNodes.addAll(getConnectedInputNodes());
        return connectedNodes;
    }
    
    public boolean isMappable() {
        return true;
    }
}
