/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.debugger.ui.process;

import javax.swing.Action;
import org.openide.util.NbBundle;

import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.TreeModel;

import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;

/**
 * @author Vladimir Yaroslavskiy
 * @author Alexander Zgursky
 */
public class BpelProcessActionProvider implements NodeActionsProvider {
    
    /**{@inheritDoc}*/
    public BpelProcessActionProvider(ContextProvider contextProvider) {
        myDebugger =
            (BpelDebugger) contextProvider.lookupFirst(null, BpelDebugger.class);
    }
    
    // NodeActionsProvider ------------------------------------------
    
    /**{@inheritDoc}*/
    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object == TreeModel.ROOT) {
            return;
        }
        if ( !(object instanceof ProcessInstance)) {
            throw new UnknownTypeException(object);
        }
        if (canMakeCurrentProcessInstance(object)) {
            makeCurrentProcessInstance(object);
        }
    }
    
    /**{@inheritDoc}*/
    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object == TreeModel.ROOT) {
            return new Action [0];
        }
        if ( !(object instanceof ProcessInstance)) {
            throw new UnknownTypeException(object);
        }
        return new Action [] { MAKE_CURRENT_ACTION, RESUME_ACTION, TERMINATE_ACTION};
    }
    
    private final Action MAKE_CURRENT_ACTION = Models.createAction(
        NbBundle.getMessage(
          BpelProcessActionProvider.class,
          "CTL_Process_Action_Make_Current"), // NOI18N
        new Models.ActionPerformer() {
            public boolean isEnabled(Object object) {
                return canMakeCurrentProcessInstance(object);
            }
            
            public void perform(Object[] objects) {
                makeCurrentProcessInstance(objects[0]);
            }
        },
        Models.MULTISELECTION_TYPE_EXACTLY_ONE
    );
    
    private final Action RESUME_ACTION = Models.createAction(
        NbBundle.getMessage(
          BpelProcessActionProvider.class, "CTL_Process_Action_Resume"), // NOI18N
        new Models.ActionPerformer() {
            public boolean isEnabled(Object object) {
                if ( !(object instanceof ProcessInstance)) {
                    return false;
                }
                ProcessInstance process = (ProcessInstance) object;
                return process.getState() == ProcessInstance.STATE_SUSPENDED;
            }
            
            public void perform(Object[] objects) {
                Object object = objects[0];
                
                if ( !(object instanceof ProcessInstance)) {
                    return;
                }
                ProcessInstance process = (ProcessInstance) object;
                process.resume();
            }
        },
        Models.MULTISELECTION_TYPE_EXACTLY_ONE
    );
    
    private final Action TERMINATE_ACTION = Models.createAction(
        NbBundle.getMessage(
          BpelProcessActionProvider.class,
          "CTL_Process_Action_Terminate"), // NOI18N
        new Models.ActionPerformer() {
            public boolean isEnabled(Object object) {
                if ( !(object instanceof ProcessInstance)) {
                    return false;
                }
                switch (((ProcessInstance)object).getState()) {
                    case ProcessInstance.STATE_COMPLETED :
                    case ProcessInstance.STATE_FAILED :
                    case ProcessInstance.STATE_TERMINATED :
                        return false;
                    default :
                        return true;
                }
            }
            
            public void perform(Object[] objects) {
                if (objects[0] instanceof ProcessInstance) {
                    ((ProcessInstance)objects[0]).terminate();
                }
            }
        },
        Models.MULTISELECTION_TYPE_EXACTLY_ONE
    );
    
    private void makeCurrentProcessInstance(Object object) {
//Log.out();
//Log.out("CURRENT");
        if (object instanceof ProcessInstance) {
            myDebugger.setCurrentProcessInstance((ProcessInstance) object);
        }
    }
    
    private boolean canMakeCurrentProcessInstance(Object object) {
        if ( !(object instanceof ProcessInstance)) {
            return false;
        }
        return object != myDebugger.getCurrentProcessInstance();
    }
    
    private BpelDebugger myDebugger;
}
