/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.model.impl;

import java.util.List;

import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PartnerLinkContainer;
import org.netbeans.modules.bpel.model.api.support.BpelModelVisitor;
import org.netbeans.modules.bpel.model.xam.AfterImport;
import org.netbeans.modules.bpel.model.xam.AfterSources;
import org.netbeans.modules.bpel.model.xam.BpelElements;
import org.w3c.dom.Element;

/**
 * @author ads
 */
public class PartnerLinkContainerImpl extends ExtensibleElementsImpl implements
        PartnerLinkContainer, AfterImport, AfterSources
{

    PartnerLinkContainerImpl( BpelModelImpl model, Element e ) {
        super(model, e);
    }

    PartnerLinkContainerImpl( BpelBuilderImpl builder ) {
        super(builder, BpelElements.PARTNERLINKS.getName() );
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLinkContainer#getPartnerLinks()
     */
    public PartnerLink[] getPartnerLinks() {
        readLock();
        try {
            List<PartnerLink> list = getChildren(PartnerLink.class);
            return list.toArray(new PartnerLink[list.size()]);
        }
        finally {
            readUnlock();
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLinkContainer#getPartnerLink(int)
     */
    public PartnerLink getPartnerLink( int i ) {
        return getChild(PartnerLink.class, i);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLinkContainer#setPartnerLink(org.netbeans.modules.soa.model.bpel20.api.PartnerLink,
     *      int)
     */
    public void setPartnerLink( PartnerLink link, int i ) {
        setChildAtIndex(link, PartnerLink.class, i);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLinkContainer#setPartnerLinks(org.netbeans.modules.soa.model.bpel20.api.PartnerLink[])
     */
    public void setPartnerLinks( PartnerLink[] links ) {
        setArrayBefore(links, PartnerLink.class);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLinkContainer#addPartnerLink(org.netbeans.modules.soa.model.bpel20.api.PartnerLink)
     */
    public void addPartnerLink( PartnerLink link ) {
        addChild(link, PartnerLink.class);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLinkContainer#insertPartnerLink(org.netbeans.modules.soa.model.bpel20.api.PartnerLink,
     *      int)
     */
    public void insertPartnerLink( PartnerLink link, int i ) {
        insertAtIndex(link, PartnerLink.class, i);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLinkContainer#removePartnerLink(int)
     */
    public void removePartnerLink( int i ) {
        removeChild(PartnerLink.class, i);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLinkContainer#sizeOfPartnerLink()
     */
    public int sizeOfPartnerLink() {
        readLock();
        try {
            return getChildren(PartnerLink.class).size();
        }
        finally {
            readUnlock();
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.api.BpelEntity#getElementType()
     */
    public Class<? extends BpelEntity> getElementType() {
        return PartnerLinkContainer.class;
    }

    public void accept( BpelModelVisitor visitor ) {
        visitor.visit(this);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel.xdm.impl.BpelContainerImpl#create(org.w3c.dom.Element)
     */
    @Override
    protected BpelEntity create( Element element )
    {
        if ( BpelElements.PARTNER_LINK.getName().equals(element.getLocalName())) {
            return new PartnerLinkImpl(getModel(), element);
        }
        return super.create( element );
    }

}
