/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/

package com.sun.j2ee.blueprints.activitysupplier.powebservice;

import java.util.*;
import java.text.*;
import java.io.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;

public class ActivityOrder implements Serializable {

    protected String orderId;
    protected ArrayList activities;

    // Constructor
    public ActivityOrder() {}

    // getter methods
    public String getOrderId() {
  return orderId;
    }

    public ArrayList getActivities() {
  return activities;
    }

    // setter methods
    public void setOrderId(String id) {
  this.orderId = id;
    }

    public void setActivities(ArrayList acts) {
  this.activities = acts;
    }

    public static ActivityOrder fromXML(String actyPO) throws 
                                          InvalidOrderException{
      
  ActivityOrder order = null;
  String opcPoId = null;
  ArrayList acts = new ArrayList();
  try { 
      
      InputSource source = new InputSource(new StringReader(actyPO));
      DocumentBuilderFactory docBuilderFactory = 
                       DocumentBuilderFactory.newInstance();
      docBuilderFactory.setNamespaceAware(true);
      DocumentBuilder docBuilder = 
                       docBuilderFactory.newDocumentBuilder();
      
      //parse the source doc and extract details
      Document doc = docBuilder.parse(source);      
      Element elem = 
      (Element)doc.getDocumentElement().getFirstChild().getNextSibling();
      opcPoId = ((Text)(elem.getFirstChild())).getData();
      for (elem = getNextSibling(elem); elem != null; 
                            elem = getNextSibling(elem)) {
          ActivityDetails acty = new ActivityDetails();
          Element actyelem = (Element)elem.getFirstChild().getNextSibling(); 
    acty.setActivityId(((Text)(actyelem.getFirstChild())).getData());
          actyelem = getNextSibling(actyelem);
          Date date = new SimpleDateFormat("MM-dd-yy").parse(((Text)(actyelem.getFirstChild())).getData());
          Calendar cal = Calendar.getInstance();
          cal.setTime(date);
          acty.setStartDate(cal);
          actyelem =  getNextSibling(actyelem); 
    date = new SimpleDateFormat("MM-dd-yy").parse(((Text)(actyelem.getFirstChild())).getData());
          cal = Calendar.getInstance();
          cal.setTime(date);
          acty.setEndDate(cal);
          actyelem =  getNextSibling(actyelem);
            acty.setHeadCount(Integer.parseInt(((Text)(actyelem.getFirstChild())).getData()));
    acts.add(acty);
      }
  } catch(Exception exe){
      exe.printStackTrace(System.err);
      throw new InvalidOrderException("PO for Activity not valid : " +
              exe.getMessage());
  }      
  if(acts.size() != 0) {
      order = new ActivityOrder();
      order.setOrderId(opcPoId);
      order.setActivities(acts);
  }
  return order;
    }
    
    public static Element getNextSibling(Element elem) {
  for(Node sib=elem.getNextSibling(); sib!=null; 
                        sib=sib.getNextSibling()){
      if(sib.getNodeType() == Node.ELEMENT_NODE){
    return (Element) sib;
      }            
  }
  return null;     
    }
}
