/*
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 * Use is subject to license terms.
 */

import java.io.File;
import java.io.BufferedReader;
import java.io.StringReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.IOException;

import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;


public class XMLVerifier
	{
	private File xml;

	public XMLVerifier(File file)
		{
		xml = file;
		}

	public XMLVerifier(String file)
		{
		this(new File(file));
		}

	public void verify()throws IOException
		{
		try
			{
			System.out.println("Verifying file "+xml+"...");
			SAXBuilder builder = new SAXBuilder(true);
			Document doc = builder.build(xml);
			System.out.println("This file is valid...");
			}
		catch(JDOMException e)
			{
			System.out.println("\n\n*********************************************************************");
			Throwable t = e.getCause();
			if(t != null)
				{
				StringWriter stw = new StringWriter();
				PrintWriter sw = new PrintWriter(stw);
				t.printStackTrace(sw);
				BufferedReader br = new BufferedReader(new StringReader((stw.getBuffer()).toString()));

				String firstLine = br.readLine();
				if(firstLine.indexOf("java.net.UnknownHostException")!=-1)
					{
					System.out.println(t.getMessage());
					System.out.println("Unable to find external entity. Try invocation with \n java \"-DproxySet=true\" \"-DproxyHost=<IP of Proxy Host>\" \"-DproxyPort=<Proxy Port>\" XMLVerifier <absolute path to XML file>");
					System.out.println();
					System.out.println();
					t.printStackTrace();
					}
				else if(firstLine.indexOf("org.xml.sax.SAXParseException")!=-1)
					{
					System.out.println(t.getMessage());
					System.out.println("The XML given as input is Not Valid as per its DTD.");
					System.out.println();
					System.out.println();
					t.printStackTrace();
					}
				else
					{
					System.out.println(t.getMessage());
					System.out.println();
					System.out.println();
					t.printStackTrace();
					}
				}
			System.out.println("\n\n*********************************************************************");
			}
		}

	public static void main(String args[])throws IOException
		{
		if(args.length == 0)
			{
			System.out.println("Usage:");
			System.out.println("java XMLVerifier <absolute path to XML file>");
			System.exit(0);
			}
		else
			{
			XMLVerifier verifier = new XMLVerifier(args[0]);
			verifier.verify();
			}
		}
	}