/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.properties;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.modules.visualweb.gravy.properties.PropertySheetOperator;
import org.netbeans.modules.visualweb.gravy.properties.SheetButtonOperator;
import org.openide.ErrorManager;
import org.openide.nodes.Node;

public class Property {
    protected ContainerOperator contOper;
    private String name;
    private SheetButtonOperator nameButtonOperator;
    private SheetButtonOperator valueButtonOperator;
    public static final String STRING_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$StringRenderer";
    public static final String CHECKBOX_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$CheckboxRenderer";
    public static final String COMBOBOX_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$ComboboxRenderer";
    public static final String RADIOBUTTON_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$RadioButtonRenderer";
    public static final String SET_RENDERER = "org.openide.explorer.propertysheet.RendererFactory$SetRenderer";
    protected Node.Property property;
    protected PropertySheetOperator propertySheetOper;

    public Property(PropertySheetOperator propertySheetOper, String name) {
        this.propertySheetOper = propertySheetOper;
        this.property = this.waitProperty(propertySheetOper, name);
    }

    public Property(PropertySheetOperator propertySheetOper, int index) {
        this.propertySheetOper = propertySheetOper;
        this.property = this.waitProperty(propertySheetOper, index);
    }

    public Property(ContainerOperator contOper, String name) {
        this(new PropertySheetOperator(contOper), name);
    }

    public Property(ContainerOperator contOper, int index) {
        this(new PropertySheetOperator(contOper), index);
    }

    private Node.Property waitProperty(final PropertySheetOperator propSheetOper, final String name) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object param) {
                    Node.Property property = null;
                    JTableOperator table = propSheetOper.tblSheet();
                    for (int row = 0; row < table.getRowCount(); ++row) {
                        if (!(table.getValueAt(row, 1) instanceof Node.Property)) continue;
                        property = (Node.Property)table.getValueAt(row, 1);
                        if (!propSheetOper.getComparator().equals(property.getDisplayName(), name)) continue;
                        return property;
                    }
                    return null;
                }

                public String getDescription() {
                    return "Wait property " + name;
                }
            });
            return (Node.Property)waiter.waitAction(null);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted.", (Throwable)e);
        }
    }

    private Node.Property waitProperty(final PropertySheetOperator propSheetOper, final int index) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object param) {
                    JTableOperator table = propSheetOper.tblSheet();
                    if (table.getRowCount() <= index) {
                        return null;
                    }
                    Object property = table.getValueAt(index, 1);
                    if (property instanceof Node.Property) {
                        return (Node.Property)property;
                    }
                    throw new JemmyException("On row " + index + " in table there is no property");
                }

                public String getDescription() {
                    return "Wait property on row " + index + " in property sheet.";
                }
            });
            return (Node.Property)waiter.waitAction(null);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted.", (Throwable)e);
        }
    }

    public SheetButtonOperator nameButtonOperator() {
        throw new JemmyException("Don't use this! Property sheet uses JTable instead of SheetButton.");
    }

    public SheetButtonOperator valueButtonOperator() {
        throw new JemmyException("Don't use this! Property sheet uses JTable instead of SheetButton.");
    }

    public String getName() {
        return this.property.getDisplayName();
    }

    public String getValue() {
        PropertyEditor pe = this.property.getPropertyEditor();
        try {
            if (this.property.getValue() != pe.getValue()) {
                pe.setValue(this.property.getValue());
            }
        }
        catch (Exception e) {
            throw new JemmyException("Exception while synchronizing value of property and property editor - property.getValue() != pe.getValue()", (Throwable)e);
        }
        return pe.getAsText();
    }

    public void setValue(String textValue) {
        this.propertySheetOper.getOutput().printTrace("Setting value \"" + textValue + "\" of property \"" + this.getName() + "\".");
        if (!this.isEnabled()) {
            throw new JemmyException("Property \"" + this.getName() + "\" is read only.");
        }
        PropertyEditor pe = this.property.getPropertyEditor();
        try {
            if (this.property.getValue() != pe.getValue()) {
                pe.setValue(this.property.getValue());
            }
        }
        catch (Exception e) {
            throw new JemmyException("Exception while synchronizing value of property and property editor - property.getValue() != pe.getValue()", (Throwable)e);
        }
        try {
            JemmyProperties.getCurrentOutput().printTrace("Setting property \"" + this.getName() + "\" to value \"" + textValue + "\".");
            pe.setAsText(textValue);
            this.property.setValue(pe.getValue());
        }
        catch (IllegalAccessException iae) {
            ErrorManager.getDefault().notify((Throwable)iae);
        }
        catch (IllegalArgumentException iare) {
            ErrorManager.getDefault().notify((Throwable)iare);
        }
        catch (InvocationTargetException ite) {
            ErrorManager.getDefault().notify((Throwable)ite);
        }
        catch (Exception e) {
            throw new JemmyException("Exception while setting value of property.", (Throwable)e);
        }
    }

    public void setValue(int index) {
        PropertyEditor pe = this.property.getPropertyEditor();
        String[] tags = pe.getTags();
        if (tags == null) {
            throw new JemmyException("Property doesn't support changing value by index.");
        }
        this.setValue(tags[index]);
    }

    public boolean isEditable() {
        throw new JemmyException("Don't use this! Use setValue() to change property value.");
    }

    public void startEditing() {
        throw new JemmyException("Don't use this! Property sheet uses JTable instead of SheetButton.");
    }

    public void stopEditing() {
        throw new JemmyException("Don't use this! Property sheet uses JTable instead of SheetButton.");
    }

    public void openEditor() {
        if (this.supportsCustomEditor()) {
            final JTableOperator table = this.propertySheetOper.tblSheet();
            for (int row = 0; row < table.getRowCount(); ++row) {
                if (!(table.getValueAt(row, 1) instanceof Node.Property) || this.property != (Node.Property)table.getValueAt(row, 1)) continue;
                ((JTable)table.getSource()).changeSelection(row, 0, false, false);
                final Action customEditorAction = ((JComponent)table.getSource()).getActionMap().get("invokeCustomEditor");
                new Thread(new Runnable(){

                    public void run() {
                        customEditorAction.actionPerformed(new ActionEvent(table.getSource(), 0, null));
                    }
                }, "Thread to open custom editor no block").start();
                return;
            }
        }
    }

    public boolean supportsCustomEditor() {
        return this.property.getPropertyEditor().supportsCustomEditor();
    }

    public void setDefaultValue() {
        try {
            this.property.restoreDefaultValue();
        }
        catch (Exception e) {
            throw new JemmyException("Exception while restoring default value.", (Throwable)e);
        }
    }

    public boolean isEnabled() {
        return this.property.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canEditAsText() {
        if (!this.isEnabled()) {
            return false;
        }
        JTableOperator table = this.propertySheetOper.tblSheet();
        for (int row = 0; row < table.getRowCount(); ++row) {
            if (!(table.getValueAt(row, 1) instanceof Node.Property) || this.property != (Node.Property)table.getValueAt(row, 1)) continue;
            table.clickForEdit(row, 1);
            long oldTimeout = this.propertySheetOper.getTimeouts().getTimeout("ComponentOperator.WaitComponentTimeout");
            this.propertySheetOper.getTimeouts().setTimeout("ComponentOperator.WaitComponentTimeout", 1000L);
            try {
                new JTextFieldOperator((ContainerOperator)this.propertySheetOper);
                boolean bl = true;
                return bl;
            }
            catch (JemmyException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                table.pushKey(27);
                this.propertySheetOper.getTimeouts().setTimeout("ComponentOperator.WaitComponentTimeout", oldTimeout);
            }
        }
        throw new JemmyException("Property " + this.getName() + " not found in this sheet:\n" + this.propertySheetOper.getSource().toString());
    }

    public String getRendererName() {
        return this.getRenderer().getClass().getName();
    }

    private Component getRenderer() {
        JTableOperator table = this.propertySheetOper.tblSheet();
        for (int row = 0; row < table.getRowCount(); ++row) {
            if (!(table.getValueAt(row, 1) instanceof Node.Property) || this.property != (Node.Property)table.getValueAt(row, 1)) continue;
            TableCellRenderer renderer = table.getCellRenderer(row, 1);
            Component comp = renderer.getTableCellRendererComponent((JTable)table.getSource(), table.getValueAt(row, 1), false, false, row, 1);
            try {
                Class<?> clazz = Class.forName("org.openide.explorer.propertysheet.RendererPropertyDisplayer");
                Method findInnermostRendererMethod = clazz.getDeclaredMethod("findInnermostRenderer", JComponent.class);
                findInnermostRendererMethod.setAccessible(true);
                comp = (Component)findInnermostRendererMethod.invoke(null, comp);
            }
            catch (Exception e) {
                throw new JemmyException("RendererPropertyDisplayer.findInnermostRenderer() by reflection failed.", (Throwable)e);
            }
            return comp;
        }
        throw new JemmyException("Property " + this.getName() + " not found in this sheet:\n" + this.propertySheetOper.getSource().toString());
    }

    public String getShortDescription() {
        return this.property.getShortDescription();
    }
}

