/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.PackageSummaryWriter;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.LayoutParser;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;

public class PackageSummaryBuilder
extends AbstractBuilder {
    public static final String ROOT = "PackageDoc";
    private PackageDoc packageDoc;
    private PackageSummaryWriter packageWriter;

    private PackageSummaryBuilder(Configuration configuration) {
        super(configuration);
    }

    public static PackageSummaryBuilder getInstance(Configuration configuration, PackageDoc packageDoc, PackageSummaryWriter packageSummaryWriter) {
        PackageSummaryBuilder packageSummaryBuilder = new PackageSummaryBuilder(configuration);
        packageSummaryBuilder.packageDoc = packageDoc;
        packageSummaryBuilder.packageWriter = packageSummaryWriter;
        return packageSummaryBuilder;
    }

    public void invokeMethod(String string, Class[] classArray, Object[] objectArray) throws Exception {
        Method method = this.getClass().getMethod(string, classArray);
        method.invoke((Object)this, objectArray);
    }

    public void build() throws IOException {
        if (this.packageWriter == null) {
            return;
        }
        this.build(LayoutParser.getInstance(this.configuration).parseXML(ROOT));
    }

    public String getName() {
        return ROOT;
    }

    public void buildPackageDoc(List list) throws Exception {
        this.build(list);
        this.packageWriter.close();
        Util.copyDocFiles(this.configuration, Util.getPackageSourcePath(this.configuration, this.packageDoc), DirectoryManager.getDirectoryPath(this.packageDoc) + File.separator + "doc-files", true);
    }

    public void buildPackageHeader() {
        this.packageWriter.writePackageHeader(Util.getPackageName(this.packageDoc));
    }

    public void buildPackageDescription() {
        if (this.configuration.nocomment) {
            return;
        }
        this.packageWriter.writePackageDescription();
    }

    public void buildPackageTags() {
        if (this.configuration.nocomment) {
            return;
        }
        this.packageWriter.writePackageTags();
    }

    public void buildSummary(List list) {
        this.build(list);
    }

    public void buildSummaryHeader() {
        this.packageWriter.writeSummaryHeader();
    }

    public void buildSummaryFooter() {
        this.packageWriter.writeSummaryFooter();
    }

    public void buildClassSummary() {
        ClassDoc[] classDocArray;
        ClassDoc[] classDocArray2 = classDocArray = this.packageDoc.isIncluded() ? this.packageDoc.ordinaryClasses() : this.configuration.classDocCatalog.ordinaryClasses(Util.getPackageName(this.packageDoc));
        if (classDocArray.length > 0) {
            this.packageWriter.writeClassesSummary(classDocArray, this.configuration.getText("doclet.Class_Summary"));
        }
    }

    public void buildInterfaceSummary() {
        ClassDoc[] classDocArray;
        ClassDoc[] classDocArray2 = classDocArray = this.packageDoc.isIncluded() ? this.packageDoc.interfaces() : this.configuration.classDocCatalog.interfaces(Util.getPackageName(this.packageDoc));
        if (classDocArray.length > 0) {
            this.packageWriter.writeClassesSummary(classDocArray, this.configuration.getText("doclet.Interface_Summary"));
        }
    }

    public void buildAnnotationTypeSummary() {
        ClassDoc[] classDocArray;
        ClassDoc[] classDocArray2 = classDocArray = this.packageDoc.isIncluded() ? this.packageDoc.annotationTypes() : this.configuration.classDocCatalog.annotationTypes(Util.getPackageName(this.packageDoc));
        if (classDocArray.length > 0) {
            this.packageWriter.writeClassesSummary(classDocArray, this.configuration.getText("doclet.Annotation_Types_Summary"));
        }
    }

    public void buildEnumSummary() {
        ClassDoc[] classDocArray;
        ClassDoc[] classDocArray2 = classDocArray = this.packageDoc.isIncluded() ? this.packageDoc.enums() : this.configuration.classDocCatalog.enums(Util.getPackageName(this.packageDoc));
        if (classDocArray.length > 0) {
            this.packageWriter.writeClassesSummary(classDocArray, this.configuration.getText("doclet.Enum_Summary"));
        }
    }

    public void buildExceptionSummary() {
        ClassDoc[] classDocArray;
        ClassDoc[] classDocArray2 = classDocArray = this.packageDoc.isIncluded() ? this.packageDoc.exceptions() : this.configuration.classDocCatalog.exceptions(Util.getPackageName(this.packageDoc));
        if (classDocArray.length > 0) {
            this.packageWriter.writeClassesSummary(classDocArray, this.configuration.getText("doclet.Exception_Summary"));
        }
    }

    public void buildErrorSummary() {
        ClassDoc[] classDocArray;
        ClassDoc[] classDocArray2 = classDocArray = this.packageDoc.isIncluded() ? this.packageDoc.errors() : this.configuration.classDocCatalog.errors(Util.getPackageName(this.packageDoc));
        if (classDocArray.length > 0) {
            this.packageWriter.writeClassesSummary(classDocArray, this.configuration.getText("doclet.Error_Summary"));
        }
    }

    public void buildPackageFooter() {
        this.packageWriter.writePackageFooter();
    }
}

