/*
 * Decompiled with CFR 0.152.
 */
package jmunit.framework.cldc11;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import jmunit.framework.cldc11.JMUnit;
import jmunit.framework.cldc11.Result;
import jmunit.framework.cldc11.Test;

public final class Screen
extends Canvas
implements CommandListener,
Runnable {
    private static final String passed = "Pass:";
    private static final String failed = "Fail:";
    private static final String error = "Error:";
    private static final String total = "Total:";
    private static final String time = "Time:";
    private final Font font = Font.getFont((int)0, (int)1, (int)16);
    private final int width = this.getWidth();
    private final int height = this.getHeight();
    private final int verticalAlignment = this.width / 8;
    private final int verticalResultAlignment = this.width * 6 / 10;
    private final int barPosition = this.height / 3;
    private final int barWidth = this.width * 3 / 4;
    private final int barHeight = this.height / 20;
    private final int passedHeight = this.height * 45 / 100;
    private final int failedHeight = this.height * 55 / 100;
    private final int errorHeight = this.height * 65 / 100;
    private final int totalHeight = this.height * 75 / 100;
    private final int elapsedHeight = this.height * 85 / 100;
    private final int jmunitX = (this.width - this.font.stringWidth(JMUnit.getVersion())) / 2;
    private final int jmunitY = this.height / 8;
    private final int anchor;
    private String name;
    private Test test;
    private int nameX;
    private int nameY;

    public Screen(String name, Test test) {
        this.anchor = 20;
        this.name = name;
        this.test = test;
        this.nameX = (this.width - this.font.stringWidth(name)) / 2;
        this.nameY = this.height / 5;
        this.setCommandListener(this);
        this.addCommand(new Command("Exit", 7, 0));
        this.addCommand(new Command("Test", 4, 1));
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.width, this.height);
        if (Result.isOK()) {
            graphics.setColor(0, 255, 0);
        } else {
            graphics.setColor(255, 0, 0);
        }
        if (Result.getTotalOfTests() != 0) {
            graphics.fillRect(this.verticalAlignment, this.barPosition, this.barWidth * Result.getRunnedTests() / Result.getTotalOfTests(), this.barHeight);
        }
        graphics.setColor(0, 0, 0);
        graphics.drawRect(this.verticalAlignment, this.barPosition, this.barWidth, this.barHeight);
        graphics.setFont(this.font);
        graphics.drawString(JMUnit.getVersion(), this.jmunitX, this.jmunitY, 20);
        graphics.drawString(this.name, this.nameX, this.nameY, 20);
        graphics.drawString(passed, this.verticalAlignment, this.passedHeight, 20);
        graphics.drawString(failed, this.verticalAlignment, this.failedHeight, 20);
        graphics.drawString(error, this.verticalAlignment, this.errorHeight, 20);
        graphics.drawString(total, this.verticalAlignment, this.totalHeight, 20);
        graphics.drawString(time, this.verticalAlignment, this.elapsedHeight, 20);
        graphics.drawString(String.valueOf(Result.getPassedTests()), this.verticalResultAlignment, this.passedHeight, 20);
        graphics.drawString(String.valueOf(Result.getFailedTests()), this.verticalResultAlignment, this.failedHeight, 20);
        graphics.drawString(String.valueOf(Result.getErrorTests()), this.verticalResultAlignment, this.errorHeight, 20);
        graphics.drawString(String.valueOf(Result.getTotalOfTests()), this.verticalResultAlignment, this.totalHeight, 20);
        graphics.drawString(String.valueOf(Result.getTime()) + "ms", this.verticalResultAlignment, this.elapsedHeight, 20);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getLabel().equals("Exit")) {
            this.test.destroyApp(true);
            this.test.notifyDestroyed();
        } else {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void run() {
        Result.initialize();
        this.test.test();
    }
}

