/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import com.puppycrawl.tools.checkstyle.checks.blocks.RightCurlyOption;

public class RightCurlyCheck
extends AbstractOptionCheck {
    private boolean mShouldStartLine = true;

    public RightCurlyCheck() {
        super(RightCurlyOption.SAME);
    }

    public void setShouldStartLine(boolean aFlag) {
        this.mShouldStartLine = aFlag;
    }

    public int[] getDefaultTokens() {
        return new int[]{95, 96, 97, 83, 92};
    }

    public void visitToken(DetailAST aAST) {
        DetailAST rcurly;
        DetailAST nextToken;
        DetailAST lcurly;
        boolean shouldCheckLastRcurly = false;
        switch (aAST.getType()) {
            case 95: {
                lcurly = (DetailAST)aAST.getFirstChild();
                nextToken = (DetailAST)lcurly.getNextSibling();
                rcurly = lcurly.getLastChild();
                break;
            }
            case 96: {
                nextToken = (DetailAST)aAST.getNextSibling();
                lcurly = aAST.getLastChild();
                rcurly = lcurly.getLastChild();
                if (nextToken != null) break;
                shouldCheckLastRcurly = true;
                nextToken = this.getNextToken(aAST);
                break;
            }
            case 83: {
                nextToken = aAST.findFirstToken(92);
                if (nextToken != null) {
                    lcurly = nextToken.getPreviousSibling();
                    rcurly = lcurly.getLastChild();
                    break;
                }
                shouldCheckLastRcurly = true;
                nextToken = this.getNextToken(aAST);
                lcurly = aAST.getLastChild();
                rcurly = lcurly.getLastChild();
                break;
            }
            case 92: {
                shouldCheckLastRcurly = true;
                nextToken = this.getNextToken(aAST);
                lcurly = (DetailAST)aAST.getFirstChild();
                rcurly = lcurly.getLastChild();
                break;
            }
            case 97: {
                shouldCheckLastRcurly = true;
                nextToken = this.getNextToken(aAST);
                lcurly = (DetailAST)aAST.getFirstChild();
                rcurly = lcurly.getLastChild();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected token type (" + TokenTypes.getTokenName(aAST.getType()) + ")");
            }
        }
        if (rcurly == null || rcurly.getType() != 73) {
            return;
        }
        if (shouldCheckLastRcurly) {
            if (rcurly.getLineNo() == nextToken.getLineNo()) {
                this.log(rcurly, "line.alone", (Object)"}");
            }
        } else if (this.getAbstractOption() == RightCurlyOption.SAME && rcurly.getLineNo() != nextToken.getLineNo()) {
            this.log(rcurly, "line.same", (Object)"}");
        } else if (this.getAbstractOption() == RightCurlyOption.ALONE && rcurly.getLineNo() == nextToken.getLineNo()) {
            this.log(rcurly, "line.alone", (Object)"}");
        }
        if (!this.mShouldStartLine) {
            return;
        }
        boolean startsLine = Utils.whitespaceBefore(rcurly.getColumnNo(), this.getLines()[rcurly.getLineNo() - 1]);
        if (!startsLine && lcurly.getLineNo() != rcurly.getLineNo()) {
            this.log(rcurly, "line.new", (Object)"}");
        }
    }

    private DetailAST getNextToken(DetailAST aAST) {
        DetailAST next = null;
        for (DetailAST parent = aAST; parent != null && next == null; parent = parent.getParent()) {
            next = (DetailAST)parent.getNextSibling();
        }
        return CheckUtils.getFirstNode(next);
    }
}

