/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import prefuse.util.StringLib;

public class JValueSlider
extends JComponent {
    private Number m_min;
    private Number m_max;
    private Number m_value;
    private boolean m_ignore = false;
    private JLabel m_label;
    private JSlider m_slider;
    private JTextField m_field;
    private List m_listeners;
    private int m_smin = 0;
    private int m_srange = 100;

    public JValueSlider(String title, double min, double max, double value) {
        this(title, new Double(min), new Double(max), new Double(value));
    }

    public JValueSlider(String title, float min, float max, float value) {
        this(title, new Float(min), new Float(max), new Float(value));
    }

    public JValueSlider(String title, int min, int max, int value) {
        this(title, new Integer(min), new Integer(max), new Integer(value));
        this.m_smin = min;
        this.m_srange = max - min;
        this.m_slider.setMinimum(min);
        this.m_slider.setMaximum(max);
        this.setValue(new Integer(value));
    }

    public JValueSlider(String title, long min, long max, long value) {
        this(title, new Long(min), new Long(max), new Long(value));
    }

    public JValueSlider(String title, Number min, Number max, Number value) {
        this.m_min = min;
        this.m_max = max;
        this.m_value = value;
        this.m_slider = new JSlider();
        this.m_label = new JLabel(title);
        this.m_field = new JTextField();
        this.m_listeners = new ArrayList();
        this.m_field.setBorder(null);
        this.setSliderValue();
        this.setFieldValue();
        this.initUI();
    }

    protected void initUI() {
        this.m_slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (JValueSlider.this.m_ignore) {
                    return;
                }
                JValueSlider.this.m_ignore = true;
                JValueSlider.this.m_value = JValueSlider.this.getSliderValue();
                JValueSlider.this.setFieldValue();
                JValueSlider.this.fireChangeEvent();
                JValueSlider.this.m_ignore = false;
            }
        });
        this.m_field.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (JValueSlider.this.m_ignore) {
                    return;
                }
                JValueSlider.this.m_ignore = true;
                Number v = JValueSlider.this.getFieldValue();
                if (v != JValueSlider.this.m_value) {
                    JValueSlider.this.m_value = v;
                    JValueSlider.this.setSliderValue();
                }
                JValueSlider.this.fireChangeEvent();
                JValueSlider.this.m_ignore = false;
            }
        });
        this.m_field.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                String s = JValueSlider.this.m_field.getText();
                if (JValueSlider.isTextObscured(JValueSlider.this.m_field, s)) {
                    JValueSlider.this.m_field.setToolTipText(s);
                }
            }

            public void mouseExited(MouseEvent e) {
                JValueSlider.this.m_field.setToolTipText(null);
            }
        });
        this.m_label.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                String s = JValueSlider.this.m_label.getText();
                if (JValueSlider.isTextObscured(JValueSlider.this.m_label, s)) {
                    JValueSlider.this.m_label.setToolTipText(s);
                }
            }

            public void mouseExited(MouseEvent e) {
                JValueSlider.this.m_label.setToolTipText(null);
            }
        });
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.m_label);
        this.add(this.m_slider);
        this.add(this.m_field);
    }

    private static boolean isTextObscured(JComponent c, String s) {
        Graphics g = c.getGraphics();
        FontMetrics fm = g.getFontMetrics(c.getFont());
        int sw = fm.stringWidth(s);
        return sw > c.getWidth();
    }

    public Number getValue() {
        return this.m_value;
    }

    public void setValue(Number value) {
        this.m_value = value;
        this.setSliderValue();
        this.setFieldValue();
    }

    private Number getSliderValue() {
        if (this.m_value instanceof Integer) {
            int val = this.m_slider.getValue();
            int min = this.m_min.intValue();
            int max = this.m_max.intValue();
            return new Integer(min + (val - this.m_smin) * (max - min) / this.m_srange);
        }
        if (this.m_value instanceof Long) {
            int val = this.m_slider.getValue();
            long min = this.m_min.longValue();
            long max = this.m_max.longValue();
            return new Long(min + (long)(val - this.m_smin) * (max - min) / (long)this.m_srange);
        }
        double f = (double)(this.m_slider.getValue() - this.m_smin) / (double)this.m_srange;
        double min = this.m_min.doubleValue();
        double max = this.m_max.doubleValue();
        double val = min + f * (max - min);
        return this.m_value instanceof Double ? (Number)new Double(val) : (Number)new Float((float)val);
    }

    private void setSliderValue() {
        int val;
        if (this.m_value instanceof Double || this.m_value instanceof Float) {
            double value = this.m_value.doubleValue();
            double min = this.m_min.doubleValue();
            double max = this.m_max.doubleValue();
            val = this.m_smin + (int)Math.round((double)this.m_srange * ((value - min) / (max - min)));
        } else {
            long value = this.m_value.longValue();
            long min = this.m_min.longValue();
            long max = this.m_max.longValue();
            val = this.m_smin + (int)((long)this.m_srange * (value - min) / (max - min));
        }
        this.m_slider.setValue(val);
    }

    private Number getFieldValue() {
        long v;
        if (this.m_value instanceof Double || this.m_value instanceof Float) {
            double v2;
            try {
                v2 = Double.parseDouble(this.m_field.getText());
            }
            catch (Exception e) {
                return this.m_value;
            }
            if (v2 < this.m_min.doubleValue() || v2 > this.m_max.doubleValue()) {
                return this.m_value;
            }
            return this.m_value instanceof Double ? (Number)new Double(v2) : (Number)new Float((float)v2);
        }
        try {
            v = Long.parseLong(this.m_field.getText());
        }
        catch (Exception e) {
            return this.m_value;
        }
        if (v < this.m_min.longValue() || v > this.m_max.longValue()) {
            return this.m_value;
        }
        return this.m_value instanceof Long ? (Number)new Long(v) : (Number)new Integer((int)v);
    }

    private void setFieldValue() {
        String text = this.m_value instanceof Double || this.m_value instanceof Float ? StringLib.formatNumber(this.m_value.doubleValue(), 3) : String.valueOf(this.m_value.longValue());
        this.m_field.setText(text);
    }

    public void addChangeListener(ChangeListener cl) {
        if (!this.m_listeners.contains(cl)) {
            this.m_listeners.add(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        this.m_listeners.remove(cl);
    }

    protected void fireChangeEvent() {
        Iterator iter = this.m_listeners.iterator();
        ChangeEvent evt = new ChangeEvent(this);
        while (iter.hasNext()) {
            ChangeListener cl = (ChangeListener)iter.next();
            cl.stateChanged(evt);
        }
    }

    public void setBackground(Color c) {
        this.m_field.setBackground(c);
        this.m_label.setBackground(c);
        this.m_slider.setBackground(c);
        super.setBackground(c);
    }

    public void setForeground(Color c) {
        this.m_field.setForeground(c);
        this.m_label.setForeground(c);
        this.m_slider.setForeground(c);
        super.setForeground(c);
    }

    public void setFont(Font f) {
        this.m_field.setFont(f);
        this.m_label.setFont(f);
        this.m_slider.setFont(f);
        super.setFont(f);
    }

    public void setPreferredSize(Dimension d) {
        int fw = Math.min(40, d.width / 5);
        int lw = Math.min(100, (d.width - fw) / 2);
        int sw = d.width - fw - lw;
        super.setPreferredSize(d);
        Dimension dd = new Dimension(lw, d.height);
        this.m_label.setPreferredSize(dd);
        dd = new Dimension(sw, d.height);
        this.m_slider.setPreferredSize(dd);
        dd = new Dimension(fw, d.height);
        this.m_field.setPreferredSize(dd);
    }
}

