/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.ClassFile;
import proguard.classfile.FieldInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.VariableEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.optimize.VariableUsageMarker;

public class ParameterShrinker
implements MemberInfoVisitor,
AttrInfoVisitor {
    private static final boolean DEBUG = false;
    private MemberInfoVisitor extraParameterMemberInfoVisitor;
    private MemberInfoVisitor extraStaticMemberInfoVisitor;
    private VariableEditor variableEditor;
    private ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor();
    private MethodInfo methodInfo;

    public ParameterShrinker(int n, int n2) {
        this(n, n2, null, null);
    }

    public ParameterShrinker(int n, int n2, MemberInfoVisitor memberInfoVisitor, MemberInfoVisitor memberInfoVisitor2) {
        this.variableEditor = new VariableEditor(n, n2);
        this.extraParameterMemberInfoVisitor = memberInfoVisitor;
        this.extraStaticMemberInfoVisitor = memberInfoVisitor2;
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        int n;
        String string;
        String string2 = programMethodInfo.getDescriptor(programClassFile);
        if (!string2.equals(string = ParameterShrinker.shrinkDescriptor(programClassFile, programMethodInfo))) {
            String string3;
            this.methodInfo = programMethodInfo;
            programMethodInfo.attributesAccept(programClassFile, this);
            String string4 = programMethodInfo.getName(programClassFile);
            String string5 = string3 = string4.equals("<init>") ? "<init>" : string4 + '$' + Long.toHexString(Math.abs(string2.hashCode()));
            if (!string3.equals(string4)) {
                programMethodInfo.u2nameIndex = this.constantPoolEditor.addUtf8CpInfo(programClassFile, string3);
            }
            ParameterShrinker.shrinkReferencedClassFiles(programClassFile, programMethodInfo);
            programMethodInfo.u2descriptorIndex = this.constantPoolEditor.addUtf8CpInfo(programClassFile, string);
            if (this.extraParameterMemberInfoVisitor != null) {
                this.extraParameterMemberInfoVisitor.visitProgramMethodInfo(programClassFile, programMethodInfo);
            }
        }
        this.variableEditor.reset(64);
        for (n = 0; n < 64; ++n) {
            if (VariableUsageMarker.isVariableUsed(programMethodInfo, n)) continue;
            this.variableEditor.deleteVariable(n);
        }
        programMethodInfo.attributesAccept(programClassFile, this.variableEditor);
        n = programMethodInfo.getAccessFlags();
        if ((n & 8) == 0 && !VariableUsageMarker.isVariableUsed(programMethodInfo, 0)) {
            programMethodInfo.u2accessFlags = n & 0xFFFFFFEF | 8;
            if (this.extraStaticMemberInfoVisitor != null) {
                this.extraStaticMemberInfoVisitor.visitProgramMethodInfo(programClassFile, programMethodInfo);
            }
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
        this.shrinkParameterAnnotations(classFile, runtimeVisibleParameterAnnotationsAttrInfo);
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
        this.shrinkParameterAnnotations(classFile, runtimeInvisibleParameterAnnotationsAttrInfo);
    }

    private void shrinkParameterAnnotations(ClassFile classFile, RuntimeParameterAnnotationsAttrInfo runtimeParameterAnnotationsAttrInfo) {
        Annotation[][] annotationArray = runtimeParameterAnnotationsAttrInfo.parameterAnnotations;
        int n = (this.methodInfo.getAccessFlags() & 8) != 0 ? 0 : 1;
        int n2 = 0;
        int n3 = 0;
        String string = this.methodInfo.getDescriptor(classFile);
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
        while (internalTypeEnumeration.hasMoreTypes()) {
            String string2 = internalTypeEnumeration.nextType();
            if (VariableUsageMarker.isVariableUsed(this.methodInfo, n)) {
                annotationArray[n3++] = annotationArray[n2];
            }
            ++n2;
            n += ClassUtil.isInternalCategory2Type(string2) ? 2 : 1;
        }
        runtimeParameterAnnotationsAttrInfo.u2numberOfParameters = n3;
        while (n3 < n2) {
            annotationArray[n3++] = null;
        }
    }

    public static String shrinkDescriptor(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        int n = (programMethodInfo.getAccessFlags() & 8) != 0 ? 0 : 1;
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(programMethodInfo.getDescriptor(programClassFile));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        while (internalTypeEnumeration.hasMoreTypes()) {
            String string = internalTypeEnumeration.nextType();
            if (VariableUsageMarker.isVariableUsed(programMethodInfo, n)) {
                stringBuffer.append(string);
            }
            n += ClassUtil.isInternalCategory2Type(string) ? 2 : 1;
        }
        stringBuffer.append(')');
        stringBuffer.append(internalTypeEnumeration.returnType());
        return stringBuffer.toString();
    }

    private static void shrinkReferencedClassFiles(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        ClassFile[] classFileArray = programMethodInfo.referencedClassFiles;
        if (classFileArray != null) {
            String string;
            int n = (programMethodInfo.getAccessFlags() & 8) != 0 ? 0 : 1;
            int n2 = 0;
            int n3 = 0;
            String string2 = programMethodInfo.getDescriptor(programClassFile);
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string2);
            while (internalTypeEnumeration.hasMoreTypes()) {
                string = internalTypeEnumeration.nextType();
                if (ClassUtil.isInternalArrayType(string)) {
                    string = ClassUtil.internalTypeFromArrayType(string);
                }
                if (ClassUtil.isInternalClassType(string)) {
                    if (VariableUsageMarker.isVariableUsed(programMethodInfo, n)) {
                        classFileArray[n3++] = classFileArray[n2];
                    }
                    ++n2;
                }
                n += ClassUtil.isInternalCategory2Type(string) ? 2 : 1;
            }
            string = internalTypeEnumeration.returnType();
            if (ClassUtil.isInternalArrayType(string)) {
                string = ClassUtil.internalTypeFromArrayType(string);
            }
            if (ClassUtil.isInternalClassType(string)) {
                classFileArray[n3++] = classFileArray[n2];
                ++n2;
            }
            while (n3 < n2) {
                classFileArray[n3++] = null;
            }
        }
    }
}

