/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import java.io.PrintWriter;
import java.util.Vector;
import org.netbeans.apitest.ErrorFormatter;
import org.netbeans.apitest.ErrorMessage;

class SortedErrorFormatter
extends ErrorFormatter {
    String[] headers = new String[]{"Missing Classes", "Missing Class Definitions", "Missing Superclasses or Superinterfaces", "Missing Fields", "Missing Constructors", "Missing Methods", "Added Classes", "Added Class Definitions", "Added Superclasses or Superinterfaces", "Added Fields", "Added Constructors", "Added Methods", "LinkageError"};
    Vector failedMessages;
    int tabSize = 20;

    public SortedErrorFormatter(PrintWriter out, String[] headers) {
        super(out);
        this.headers = headers;
        this.failedMessages = new Vector();
    }

    public SortedErrorFormatter(PrintWriter out) {
        super(out);
        this.failedMessages = new Vector();
    }

    public void addError(String errorTyp, String className, String def, String tail) {
        this.failedMessages.addElement(this.createError(errorTyp, className, def, tail));
        ++this.size;
    }

    public void addError(ErrorMessage msg) {
        this.failedMessages.addElement(msg);
        ++this.size;
    }

    public int printErrors() {
        int currentErrorType = 0;
        boolean hasHeader = false;
        while (!this.failedMessages.isEmpty()) {
            int pos = 0;
            Vector<ErrorMessage> currentTypeErrors = new Vector<ErrorMessage>();
            for (int i = 0; i < this.failedMessages.size() && i >= 0; ++i) {
                ErrorMessage temp = (ErrorMessage)this.failedMessages.elementAt(i);
                if (temp.errorType != currentErrorType) continue;
                currentTypeErrors.addElement(temp);
                this.failedMessages.removeElementAt(i--);
            }
            if (currentTypeErrors.isEmpty()) {
                ++currentErrorType;
                continue;
            }
            if (this.headers != null && currentErrorType < this.headers.length) {
                hasHeader = true;
                this.out.println(this.headers[currentErrorType] + "\n" + SortedErrorFormatter.space('-', this.headers[currentErrorType].length()) + "\n");
            } else {
                hasHeader = false;
            }
            while (!currentTypeErrors.isEmpty()) {
                ErrorMessage min = (ErrorMessage)currentTypeErrors.elementAt(0);
                pos = 0;
                for (int i = 0; i < currentTypeErrors.size(); ++i) {
                    ErrorMessage temp = (ErrorMessage)currentTypeErrors.elementAt(i);
                    if (min.compareTo(temp) <= 0) continue;
                    min = temp;
                    pos = i;
                }
                currentTypeErrors.removeElementAt(pos);
                if (hasHeader) {
                    if (min.definition.equals("")) {
                        this.out.println(min.className);
                        continue;
                    }
                    int currentTab = (min.className.length() + 1) / this.tabSize;
                    if ((min.className.length() + 1) % this.tabSize != 0) {
                        ++currentTab;
                    }
                    this.out.println(min.className + ":" + SortedErrorFormatter.space(' ', (currentTab *= this.tabSize) - min.className.length() - 1) + SortedErrorFormatter.toString(min.definition));
                    continue;
                }
                this.out.println(min);
            }
            this.out.println("");
            ++currentErrorType;
        }
        return this.size;
    }

    protected static String space(char c, int len) {
        char[] buff = new char[len];
        for (int i = 0; i < len; ++i) {
            buff[i] = c;
        }
        return new String(buff);
    }
}

