/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.support;

import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import com.sap.mw.jco.support.RfcTest;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class JRfcTest
extends RfcTest {
    private static String RFC_SYSTEM_INFO = "RFC SYSTEM INFO";
    private static String CONNECTION_TEST = "CONNECTION TEST";
    private static String PERFORMANCE_TEST = "PERFORMANCE TEST";
    private static String RFC_WITH_SAPGUI = "RFC with SAPGUI";
    private static String STRUCTURE_TEST = "INHOMOGENEOUS STRUCTURE/TABLE";
    private static String TRANSACTIONAL_RFC = "TRANSACTIONAL RFC";
    private static String CONNECTION_PARAM = "CONNECTION PARAMETERS:";
    private static String RFC_SPECIFIC_PARAM = "RFC-SPECIFIC PARAMETERS:";
    private static String SAP_LOGON_PARAM = "SAP LOGON DATA:";
    private static String PERFORMANCE_PARAM = "PERFORMANCE TEST DATA:";
    private static String SAPGUI_PARAM = "RFC WITH SAPGUI TEST DATA:";
    private static String NUMBER_ANSWER = "number_answer";
    private static String SERVER_TYPE_ANSWER = "server_type_answer";
    private static String YN_ANSWER = "yn_answer";
    private static String FT_ANSWER = "ft_answer";
    private static String space1 = "                 ";
    private static String space2 = "               ";
    private static String rhomb1 = ">>>>>>>>>>>>>>>>";
    private static String rhomb2 = "<<<<<<<<<<<<<<<<";
    private static String properties_filename = "jrfctest.props";
    private static Properties propLabels = new Properties();
    private static Properties propValues = new Properties();
    private static Properties propReposValues = new Properties();
    private static int numberOfCalls = 1;
    private static int numberOfCall = 0;
    private static JCO.Client client = null;
    private static String REPOS_CLIENTS = "REPOS_CLIENTS";
    private static IFunctionTemplate ftemplate = null;
    private static JCO.Function function = null;
    private static IRepository myRepos = null;

    public static void main(String[] args) {
        String answer = null;
        int choose = -1;
        do {
            JRfcTest.usage();
            do {
                if ((answer = RfcTest.ask(space2 + "Your Choice.......", null)) == null) continue;
                try {
                    choose = Integer.parseInt(answer);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            } while ((choose <= 0 || choose >= 20) && choose != 99);
            switch (choose) {
                case 1: {
                    JRfcTest.header(RFC_SYSTEM_INFO, "Get system info of a RFC Server");
                    JRfcTest.defineParameters(new String[]{CONNECTION_PARAM, RFC_SPECIFIC_PARAM, SAP_LOGON_PARAM});
                    JRfcTest.runRfcSystemInfoTest();
                    break;
                }
                case 2: {
                    JRfcTest.header(CONNECTION_TEST, "Send message and wait for ECHO/INFO");
                    JRfcTest.defineParameters(new String[]{CONNECTION_PARAM, RFC_SPECIFIC_PARAM, SAP_LOGON_PARAM});
                    JRfcTest.runConnectionTest();
                    break;
                }
                case 3: {
                    JRfcTest.header(PERFORMANCE_TEST, "Send/Receive internal tables");
                    JRfcTest.defineParameters(new String[]{CONNECTION_PARAM, RFC_SPECIFIC_PARAM, SAP_LOGON_PARAM, PERFORMANCE_PARAM});
                    JRfcTest.runPerformanceTest();
                    break;
                }
                case 4: {
                    JRfcTest.header(STRUCTURE_TEST, "Send/Receive inhomogeneous structure/table");
                    JRfcTest.defineParameters(new String[]{CONNECTION_PARAM, RFC_SPECIFIC_PARAM, SAP_LOGON_PARAM});
                    JRfcTest.runStructureTest();
                    break;
                }
                case 15: {
                    JRfcTest.header(TRANSACTIONAL_RFC, "Test for transactional RFC call");
                    JRfcTest.defineParameters(new String[]{CONNECTION_PARAM, RFC_SPECIFIC_PARAM, SAP_LOGON_PARAM});
                    JRfcTest.runTranRfcTest();
                    break;
                }
                case 99: {
                    break;
                }
            }
            if (choose != 99) {
                RfcTest.out.println("\n\n");
                choose = -1;
                do {
                    if ((answer = RfcTest.ask(space2 + "Continue (y/n)..................", null)) == null) {
                        answer = "temp";
                        continue;
                    }
                    if (!answer.equalsIgnoreCase("n")) continue;
                    choose = 99;
                    break;
                } while (!answer.equalsIgnoreCase("y"));
            }
            JRfcTest.storeProperties();
        } while (choose != 99);
    }

    private static void initProperties() {
        propValues.setProperty("jco.client.type", "3");
        propValues.setProperty("jco.client.load_balancing", "Y");
        propValues.setProperty("jco.client.iashost", "binmain");
        propValues.setProperty("jco.client.isysnr", "53");
        propValues.setProperty("jco.client.ir3name", "BIN");
        propValues.setProperty("jco.client.imhost", "binmain");
        propValues.setProperty("jco.client.igroup", "PUBLIC");
        propValues.setProperty("jco.client.isnc_mode", "N");
        propValues.setProperty("jco.client.snc_mode", "0");
        propValues.setProperty("jco.client.idest", "K50");
        propValues.setProperty("jco.client.igwhost", "IHSAP4");
        propValues.setProperty("jco.client.igwserv", "sapgw00");
        propValues.setProperty("jco.client.registprog", "Y");
        propValues.setProperty("jco.client.tpid", "jrfcserv");
        propValues.setProperty("jco.client.itpname", "/bas/BIN/gen/dbg/nintel/srfcserv");
        propValues.setProperty("jco.client.itphost", "binmain");
        propValues.setProperty("jco.client.iprofile_name", "profil_gen.txt");
        propValues.setProperty("jco.client.isnc_lib", "C:\\Program Files\\SECUDE\\SECUDE for R3\\secude.dll");
        propValues.setProperty("jco.client.isnc_partnername", "s:sample@hs0335");
        propValues.setProperty("jco.client.iabap_debug", "N");
        propValues.setProperty("jco.client.iuse_sapgui", "N");
        propValues.setProperty("jco.client.sapgui_invisible", "N");
        propValues.setProperty("jco.client.itrace", "N");
        propValues.setProperty("jco.client.jco_trace_level", "0");
        propValues.setProperty("jco.client.iclient", "000");
        propValues.setProperty("jco.client.iuser", "SAPCPIC");
        propValues.setProperty("jco.client.ipasswd", "XXXXXX");
        propValues.setProperty("jco.client.ilang", "E");
        propValues.setProperty("jco.gui.test_type", "F");
        propValues.setProperty("jco.gui.fm_name", "STFC_SAPGUI");
        propValues.setProperty("jco.gui.transaction_name", "SE38");
        propValues.setProperty("jco.perform.elength0332", "0");
        propValues.setProperty("jco.perform.elength1000", "0");
        propValues.setProperty("jco.perform.ilength0332", "0");
        propValues.setProperty("jco.perform.ilength1000", "0");
        propValues.setProperty("jco.perform.checktable", "N");
        propValues.setProperty("jco.perform.display_tab", "N");
        propValues.setProperty("jco.run.number_of_calls", "1");
        propValues.setProperty("jco.run.close_connect", "N");
        JRfcTest.loadProperties();
    }

    private static void loadProperties() {
        Properties prop = RfcTest.loadProperties(properties_filename);
        Enumeration<?> names = prop.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            propValues.setProperty(name, prop.getProperty(name));
        }
    }

    private static void storeProperties() {
        ((Hashtable)propValues).remove("jco.client.r3name");
        ((Hashtable)propValues).remove("jco.client.mhost");
        ((Hashtable)propValues).remove("jco.client.group");
        ((Hashtable)propValues).remove("jco.client.ashost");
        ((Hashtable)propValues).remove("jco.client.sysnr");
        ((Hashtable)propValues).remove("jco.client.tpname");
        ((Hashtable)propValues).remove("jco.client.tphost");
        ((Hashtable)propValues).remove("jco.client.gwhost");
        ((Hashtable)propValues).remove("jco.client.gwserv");
        ((Hashtable)propValues).remove("jco.client.dest");
        ((Hashtable)propValues).remove("jco.client.profile_name");
        ((Hashtable)propValues).remove("jco.client.snc_mode");
        ((Hashtable)propValues).remove("jco.client.snc_lib");
        ((Hashtable)propValues).remove("jco.client.snc_partnername");
        ((Hashtable)propValues).remove("jco.client.abap_debug");
        ((Hashtable)propValues).remove("jco.client.use_sapgui");
        ((Hashtable)propValues).remove("jco.client.trace");
        ((Hashtable)propValues).remove("jco.client.client");
        ((Hashtable)propValues).remove("jco.client.user");
        ((Hashtable)propValues).remove("jco.client.passwd");
        ((Hashtable)propValues).remove("jco.client.lang");
        ((Hashtable)propReposValues).clear();
        RfcTest.storeProperties(propValues, properties_filename, "client properties of JRfcTest");
    }

    private static void defineParameters(String[] categories) {
        String answer;
        int i = 0;
        while (i < categories.length) {
            RfcTest.out.println("\n" + space2 + categories[i]);
            if (categories[i].equals(CONNECTION_PARAM)) {
                JRfcTest.displayConnectionParam(0);
            } else if (categories[i].equals(RFC_SPECIFIC_PARAM)) {
                JRfcTest.displayRfcSpecificParam(0);
            } else if (categories[i].equals(SAP_LOGON_PARAM)) {
                JRfcTest.displaySapLogonParam(0);
            } else if (categories[i].equals(PERFORMANCE_PARAM)) {
                JRfcTest.displayPerformanceParam(0);
            } else if (categories[i].equals(SAPGUI_PARAM)) {
                JRfcTest.displaySapGuiParam(0);
            }
            ++i;
        }
        JRfcTest.displayNumberOfCalls(0);
        do {
            if ((answer = RfcTest.ask(space2 + "Do You Want To Test With These Parameters (Y/N)..", null)) != null) continue;
            answer = "temp";
        } while (!answer.equalsIgnoreCase("Y") && !answer.equalsIgnoreCase("N"));
        if (answer.equalsIgnoreCase("N")) {
            do {
                int i2 = 0;
                while (i2 < categories.length) {
                    RfcTest.out.println("\n" + space2 + categories[i2]);
                    if (categories[i2].equals(CONNECTION_PARAM)) {
                        JRfcTest.displayConnectionParam(1);
                    } else if (categories[i2].equals(RFC_SPECIFIC_PARAM)) {
                        JRfcTest.displayRfcSpecificParam(1);
                    } else if (categories[i2].equals(SAP_LOGON_PARAM)) {
                        JRfcTest.displaySapLogonParam(1);
                    } else if (categories[i2].equals(PERFORMANCE_PARAM)) {
                        JRfcTest.displayPerformanceParam(1);
                    } else if (categories[i2].equals(SAPGUI_PARAM)) {
                        JRfcTest.displaySapGuiParam(1);
                    }
                    ++i2;
                }
                JRfcTest.displayNumberOfCalls(1);
                do {
                    if ((answer = RfcTest.ask(space2 + "Do You Want To Test With These Parameters (Y/N)..", null)) != null) continue;
                    answer = "temp";
                } while (!answer.equalsIgnoreCase("Y") && !answer.equalsIgnoreCase("N"));
            } while (!answer.equalsIgnoreCase("Y"));
        }
    }

    private static void usage() {
        RfcTest.out.println("\n\n\n");
        RfcTest.out.println(space2 + "**********************************************");
        RfcTest.out.println(space2 + "*                                            *");
        RfcTest.out.println(space2 + "*            SAP JCo Client Test             *");
        RfcTest.out.println(space2 + "*                                            *");
        RfcTest.out.println(space2 + "*                                            *");
        RfcTest.out.println(space2 + "**********************************************");
        RfcTest.out.println();
        RfcTest.out.println(space1 + "Possible SAP JCo-Tests");
        RfcTest.out.println();
        RfcTest.out.println(space1 + " 1. RFC_SYSTEM_INFO");
        RfcTest.out.println(space1 + " 2. CONNECTION");
        RfcTest.out.println(space1 + " 3. PERFORMANCE");
        RfcTest.out.println(space1 + " 4. INHOMOGENEOUS STRUCTURE/TABLE");
        RfcTest.out.println(space1 + "15. TRANSACTIONAL RFC ");
        RfcTest.out.println(space1 + "99. Exit");
        RfcTest.out.println();
    }

    private static void header(String function, String description) {
        RfcTest.out.println("\n\n\n");
        RfcTest.out.println(space2 + "**********************************************");
        RfcTest.out.println();
        RfcTest.out.println(space2 + "       SAP JCo TEST - " + function);
        RfcTest.out.println(space2 + "       " + description);
        RfcTest.out.println();
        RfcTest.out.println(space2 + "**********************************************");
    }

    private static void displayConnectionParam(int mode) {
        JRfcTest.display("jco.client.type", mode, SERVER_TYPE_ANSWER);
        if (propValues.getProperty("jco.client.type").equals("3")) {
            JRfcTest.display("jco.client.load_balancing", mode, YN_ANSWER);
            if (propValues.getProperty("jco.client.load_balancing").equalsIgnoreCase("N")) {
                JRfcTest.display("jco.client.iashost", mode);
                JRfcTest.display("jco.client.isysnr", mode);
            } else {
                JRfcTest.display("jco.client.ir3name", mode);
                JRfcTest.display("jco.client.imhost", mode);
                JRfcTest.display("jco.client.igroup", mode);
            }
            JRfcTest.display("jco.client.isnc_mode", mode, YN_ANSWER);
            if (propValues.getProperty("jco.client.isnc_mode").equalsIgnoreCase("Y")) {
                JRfcTest.display("jco.client.isnc_lib", mode);
                JRfcTest.display("jco.client.isnc_partnername", mode);
            }
        } else if (propValues.getProperty("jco.client.type").equals("2")) {
            JRfcTest.display("jco.client.idest", mode);
            JRfcTest.display("jco.client.igwhost", mode);
            JRfcTest.display("jco.client.igwserv", mode);
        } else if (propValues.getProperty("jco.client.type").equalsIgnoreCase("E")) {
            JRfcTest.display("jco.client.registprog", mode, YN_ANSWER);
            JRfcTest.display("jco.client.igwhost", mode);
            JRfcTest.display("jco.client.igwserv", mode);
            if (propValues.getProperty("jco.client.registprog").equalsIgnoreCase("Y")) {
                JRfcTest.display("jco.client.tpid", mode);
            } else {
                JRfcTest.display("jco.client.itphost", mode);
                JRfcTest.display("jco.client.itpname", mode);
            }
            JRfcTest.display("jco.client.isnc_mode", mode, YN_ANSWER);
            if (propValues.getProperty("jco.client.isnc_mode").equalsIgnoreCase("Y")) {
                JRfcTest.display("jco.client.isnc_lib", mode);
                JRfcTest.display("jco.client.isnc_partnername", mode);
            }
        } else if (propValues.getProperty("jco.client.type").equalsIgnoreCase("F")) {
            JRfcTest.display("jco.client.iprofile_name", mode);
        } else {
            RfcTest.out.println("Server or Connection Type '" + propValues.getProperty("jco.client.type") + "' is not supported.");
            RfcTest.out.println("Adapt method displayConnectionParam!");
            System.exit(1);
        }
    }

    private static void displayRfcSpecificParam(int mode) {
        if (propValues.getProperty("jco.client.type").equalsIgnoreCase("3")) {
            JRfcTest.display("jco.client.iabap_debug", mode, YN_ANSWER);
            if (propValues.getProperty("jco.client.iabap_debug").equalsIgnoreCase("y")) {
                propValues.setProperty("jco.client.iuse_sapgui", "Y");
                propValues.setProperty("jco.client.sapgui_invisible", "N");
                JRfcTest.display("jco.client.iuse_sapgui", 0, YN_ANSWER);
                JRfcTest.display("jco.client.sapgui_invisible", 0, YN_ANSWER);
            } else {
                JRfcTest.display("jco.client.iuse_sapgui", mode, YN_ANSWER);
                if (propValues.getProperty("jco.client.iuse_sapgui").equalsIgnoreCase("y")) {
                    JRfcTest.display("jco.client.sapgui_invisible", mode, YN_ANSWER);
                }
            }
        }
        JRfcTest.display("jco.client.itrace", mode, YN_ANSWER);
        JRfcTest.display("jco.client.jco_trace_level", mode, NUMBER_ANSWER);
    }

    private static void displaySapLogonParam(int mode) {
        JRfcTest.display("jco.client.iclient", mode, NUMBER_ANSWER);
        JRfcTest.display("jco.client.iuser", mode);
        JRfcTest.display("jco.client.ipasswd", mode);
        JRfcTest.display("jco.client.ilang", mode);
        if (propValues.getProperty("jco.client.type").equalsIgnoreCase("E")) {
            JRfcTest.display("jco.client.iashost", mode);
            JRfcTest.display("jco.client.isysnr", mode);
        }
    }

    private static void displaySapGuiParam(int mode) {
        JRfcTest.display("jco.gui.test_type", mode, FT_ANSWER);
        JRfcTest.display("jco.gui.fm_name", mode);
        JRfcTest.display("jco.gui.transaction_name", mode);
    }

    private static void displayPerformanceParam(int mode) {
        JRfcTest.display("jco.perform.elength0332", mode, NUMBER_ANSWER);
        JRfcTest.display("jco.perform.elength1000", mode, NUMBER_ANSWER);
        JRfcTest.display("jco.perform.ilength0332", mode, NUMBER_ANSWER);
        JRfcTest.display("jco.perform.ilength1000", mode, NUMBER_ANSWER);
        JRfcTest.display("jco.perform.checktable", mode, YN_ANSWER);
        JRfcTest.display("jco.perform.display_tab", mode, YN_ANSWER);
    }

    private static void displayNumberOfCalls(int mode) {
        RfcTest.out.println();
        JRfcTest.display("jco.run.number_of_calls", mode, NUMBER_ANSWER);
        if (Integer.parseInt(propValues.getProperty("jco.run.number_of_calls")) > 1) {
            JRfcTest.display("jco.run.close_connect", mode, YN_ANSWER);
        }
        RfcTest.out.println();
    }

    private static void display(String prop, int mode) {
        String currentPropValue = null;
        String MASKED_PASSWD = "XXXXXX";
        String passwd = null;
        if (prop.equals("jco.client.ipasswd")) {
            currentPropValue = MASKED_PASSWD;
            passwd = propValues.getProperty(prop);
        } else {
            currentPropValue = propValues.getProperty(prop);
        }
        if (mode == 0) {
            RfcTest.out.println(propLabels.getProperty(prop) + " " + currentPropValue);
        } else {
            String propValueNew = prop.equals("jco.client.ipasswd") ? RfcTest.askSecure(propLabels.getProperty(prop), currentPropValue) : RfcTest.ask(propLabels.getProperty(prop), currentPropValue);
            propValues.setProperty(prop, propValueNew);
        }
    }

    private static void display(String prop, int mode, String rangeOfValues) {
        if (rangeOfValues == null || mode == 0) {
            JRfcTest.display(prop, mode);
            return;
        }
        String answer = null;
        String currentPropValue = null;
        String MASKED_PASSWD = "XXXXXX";
        currentPropValue = prop.equals("jco.client.ipasswd") ? MASKED_PASSWD : propValues.getProperty(prop);
        if (rangeOfValues.equals(YN_ANSWER)) {
            do {
                answer = RfcTest.ask(propLabels.getProperty(prop), currentPropValue);
            } while (!(answer = answer.toUpperCase()).equals("Y") && !answer.equals("N"));
        } else if (rangeOfValues.equals(FT_ANSWER)) {
            do {
                answer = RfcTest.ask(propLabels.getProperty(prop), currentPropValue);
            } while (!(answer = answer.toUpperCase()).equals("F") && !answer.equals("T"));
        } else if (rangeOfValues.equals(SERVER_TYPE_ANSWER)) {
            while (!((answer = RfcTest.ask(propLabels.getProperty(prop), currentPropValue)).equals("3") || answer.equals("2") || answer.equalsIgnoreCase("F") || answer.equalsIgnoreCase("E"))) {
            }
        } else if (rangeOfValues.equals(NUMBER_ANSWER)) {
            boolean isNumber = true;
            do {
                isNumber = true;
                answer = RfcTest.ask(propLabels.getProperty(prop), currentPropValue);
                try {
                    Integer.parseInt(answer);
                }
                catch (NumberFormatException ex) {
                    isNumber = false;
                }
            } while (!isNumber);
        }
        propValues.setProperty(prop, answer);
    }

    private static void runRfcSystemInfoTest() {
        RfcTest.out.println("\n\n" + rhomb1 + " SAP JCo TEST - " + RFC_SYSTEM_INFO + " " + rhomb1 + "\n\n");
        numberOfCall = 0;
        while (numberOfCall < numberOfCalls) {
            JRfcTest.initCall("RFC_SYSTEM_INFO");
            try {
                client.execute(function);
            }
            catch (Throwable thr) {
                RfcTest.out.println("RFC_SYSTEM_INFO call failed, error message: \n");
                RfcTest.displayException(thr);
                System.exit(1);
                return;
            }
            JCO.Structure sysInfo = function.getExportParameterList().getStructure("RFCSI_EXPORT");
            String systemInfo = "\n" + space2 + "SAP System Information:\n" + space2 + "-----------------------------------------------------\n";
            systemInfo = systemInfo + space2 + "Destination       \t" + sysInfo.getField("RFCDEST").getValue() + "\n\n";
            systemInfo = systemInfo + space2 + "Host              \t" + sysInfo.getField("RFCHOST").getValue() + "\n";
            systemInfo = systemInfo + space2 + "System ID         \t" + sysInfo.getField("RFCSYSID").getValue() + "\n";
            systemInfo = systemInfo + space2 + "Database          \t" + sysInfo.getField("RFCDATABS").getValue() + "\n";
            systemInfo = systemInfo + space2 + "DB Host           \t" + sysInfo.getField("RFCDBHOST").getValue() + "\n";
            systemInfo = systemInfo + space2 + "DB System         \t" + sysInfo.getField("RFCDBSYS").getValue() + "\n\n";
            systemInfo = systemInfo + space2 + "SAP Release       \t" + sysInfo.getField("RFCSAPRL").getValue() + "\n";
            systemInfo = systemInfo + space2 + "SAP Kernel Release\t";
            if (!propValues.getProperty("jco.client.type").equals("2")) {
                systemInfo = systemInfo + sysInfo.getField("RFCKERNRL").getValue();
            }
            systemInfo = systemInfo + "\n\n";
            systemInfo = systemInfo + space2 + "RFC Protocol      \t" + sysInfo.getField("RFCPROTO").getValue() + "\n";
            systemInfo = systemInfo + space2 + "Characters        \t" + sysInfo.getField("RFCCHARTYP").getValue() + "\n";
            systemInfo = systemInfo + space2 + "Integers          \t" + sysInfo.getField("RFCINTTYP").getValue() + "\n";
            systemInfo = systemInfo + space2 + "Floating P.       \t" + sysInfo.getField("RFCFLOTYP").getValue() + "\n";
            systemInfo = systemInfo + space2 + "SAP Machine Id    \t" + sysInfo.getField("RFCMACH").getValue() + "\n\n";
            systemInfo = systemInfo + space2 + "Timezone          \t" + sysInfo.getField("RFCTZONE").getValue() + "\n";
            RfcTest.out.println(systemInfo);
            JRfcTest.finalizeCall();
            if (numberOfCalls > numberOfCall + 1) {
                RfcTest.ask("\n\n\nHit return key for next RFC call", null);
                RfcTest.out.println("\n\n");
            }
            ++numberOfCall;
        }
        RfcTest.out.println("\n\n" + rhomb2 + " SAP JCo TEST - " + RFC_SYSTEM_INFO + " " + rhomb2 + "\n\n");
    }

    private static void runConnectionTest() {
        RfcTest.out.println("\n\n" + rhomb1 + " SAP JCo TEST - " + CONNECTION_TEST + " " + rhomb1 + "\n\n");
        numberOfCall = 0;
        while (numberOfCall < numberOfCalls) {
            JRfcTest.initCall("STFC_CONNECTION");
            JCO.ParameterList imp = function.getImportParameterList();
            imp.setValue("abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ 1234567890", "REQUTEXT");
            try {
                client.execute(function);
            }
            catch (Throwable thr) {
                RfcTest.out.println("STFC_CONNECTION call failed, error message: \n");
                RfcTest.displayException(thr);
                System.exit(1);
                return;
            }
            JCO.ParameterList exp = function.getExportParameterList();
            RfcTest.out.println("Import Parameter REQUTEXT: " + imp.getValue("REQUTEXT"));
            RfcTest.out.println("\nExport Parameter ECHOTEXT: " + exp.getValue("ECHOTEXT"));
            RfcTest.out.println("Export Parameter RESPTEXT: " + exp.getValue("RESPTEXT"));
            JRfcTest.finalizeCall();
            if (numberOfCalls > numberOfCall + 1) {
                RfcTest.ask("\n\n\nHit return key for next RFC call", null);
                RfcTest.out.println("\n\n");
            }
            ++numberOfCall;
        }
        RfcTest.out.println("\n\n" + rhomb2 + " SAP JCo TEST - " + CONNECTION_TEST + " " + rhomb2 + "\n\n");
    }

    private static void runPerformanceTest() {
        RfcTest.out.println("\n\n" + rhomb1 + " SAP JCo TEST - " + PERFORMANCE_TEST + " " + rhomb1 + "\n\n");
        numberOfCall = 0;
        while (numberOfCall < numberOfCalls) {
            JRfcTest.initCall("STFC_PERFORMANCE");
            JCO.ParameterList imp = function.getImportParameterList();
            imp.setValue(propValues.getProperty("jco.perform.elength0332"), "LGET0332");
            imp.setValue(propValues.getProperty("jco.perform.elength1000"), "LGET1000");
            imp.setValue(propValues.getProperty("jco.perform.ilength0332"), "LGIT0332");
            imp.setValue(propValues.getProperty("jco.perform.ilength1000"), "LGIT1000");
            imp.setValue(propValues.getProperty("jco.perform.checktable"), "CHECKTAB");
            JCO.ParameterList tab = function.getTableParameterList();
            JRfcTest.fillTable(tab.getTable("ITAB0332"), imp.getInt("LGIT0332"));
            JRfcTest.fillTable(tab.getTable("ITAB1000"), imp.getInt("LGIT1000"));
            try {
                client.execute(function);
            }
            catch (Throwable thr) {
                RfcTest.out.println("STFC_PERFORMANCE call failed, error message: \n");
                RfcTest.displayException(thr);
                System.exit(1);
                return;
            }
            JCO.ParameterList exp = function.getExportParameterList();
            RfcTest.out.println("Import Parameter CHECKTAB: " + imp.getValue("CHECKTAB"));
            RfcTest.out.println("Import Parameter LGIT0332: " + imp.getValue("LGIT0332"));
            RfcTest.out.println("Import Parameter LGIT1000: " + imp.getValue("LGIT1000"));
            RfcTest.out.println("Import Parameter LGET0332: " + imp.getValue("LGET0332"));
            RfcTest.out.println("Import Parameter LGET1000: " + imp.getValue("LGET1000"));
            RfcTest.out.println("\nExport Parameter EXITCODE: " + exp.getValue("EXITCODE"));
            RfcTest.out.println("Export Parameter TEXT0332: '" + exp.getValue("TEXT0332") + "'");
            RfcTest.out.println("Export Parameter TEXT1000: '" + exp.getValue("TEXT1000") + "'");
            RfcTest.out.println();
            RfcTest.out.println(JRfcTest.checkTable("Export", tab.getTable("ETAB0332"), "0332", imp.getInt("LGET0332"), imp.getString("CHECKTAB")));
            RfcTest.out.println(JRfcTest.checkTable("Export", tab.getTable("ETAB1000"), "1000", imp.getInt("LGET1000"), imp.getString("CHECKTAB")));
            RfcTest.out.println(JRfcTest.checkTable("Import", tab.getTable("ITAB0332"), "0332", imp.getInt("LGIT0332"), imp.getString("CHECKTAB")));
            RfcTest.out.println(JRfcTest.checkTable("Import", tab.getTable("ITAB1000"), "1000", imp.getInt("LGIT1000"), imp.getString("CHECKTAB")));
            if (propValues.getProperty("jco.perform.display_tab").equalsIgnoreCase("Y")) {
                String answer = RfcTest.ask("\n\nHit return key to display internal tables on screen", null);
                int i = 0;
                while (i < tab.getFieldCount()) {
                    RfcTest.out.println("\n\nTable: " + tab.getName(i));
                    JRfcTest.displayParameters(tab, i, false);
                    ++i;
                }
            }
            JRfcTest.finalizeCall();
            if (numberOfCalls > numberOfCall + 1) {
                RfcTest.ask("\n\n\nHit return key for next RFC call", null);
                RfcTest.out.println("\n\n");
            }
            ++numberOfCall;
        }
        RfcTest.out.println("\n\n" + rhomb2 + " SAP JCo TEST - " + PERFORMANCE_TEST + " " + rhomb2 + "\n\n");
    }

    private static void runSapguiTest() {
        RfcTest.out.println("\n\n" + rhomb1 + " SAP JCo TEST - " + RFC_WITH_SAPGUI + " " + rhomb1 + "\n\n");
        numberOfCall = 0;
        while (numberOfCall < numberOfCalls) {
            RfcTest.out.println("Not implemented, yet.");
            if (numberOfCalls > numberOfCall + 1) {
                RfcTest.ask("\n\n\nHit return key for next RFC call", null);
                RfcTest.out.println("\n\n");
            }
            ++numberOfCall;
        }
        RfcTest.out.println("\n\n" + rhomb2 + " SAP JCo TEST - " + RFC_WITH_SAPGUI + " " + rhomb2 + "\n\n");
    }

    private static void runStructureTest() {
        RfcTest.out.println("\n\n" + rhomb1 + " SAP JCo TEST - " + STRUCTURE_TEST + " " + rhomb1 + "\n\n");
        numberOfCall = 0;
        while (numberOfCall < numberOfCalls) {
            JRfcTest.initCall("STFC_STRUCTURE");
            JCO.Structure istruct = function.getImportParameterList().getStructure("IMPORTSTRUCT");
            istruct.setValue(1000000.0, "RFCFLOAT");
            istruct.setValue("A", "RFCCHAR1");
            istruct.setValue(1000, "RFCINT2");
            istruct.setValue(10, "RFCINT1");
            istruct.setValue("EXT.", "RFCCHAR4");
            istruct.setValue(100000, "RFCINT4");
            istruct.setValue(new byte[]{49, 50, 51}, "RFCHEX3");
            istruct.setValue("BC", "RFCCHAR2");
            istruct.setValue("124500", "RFCTIME");
            istruct.setValue("19960924", "RFCDATE");
            istruct.setValue("01234567890123456789012345678901234567890123456789", "RFCDATA1");
            istruct.setValue("01234567890123456789012345678901234567890123456789", "RFCDATA2");
            JCO.Table tab = function.getTableParameterList().getTable("RFCTABLE");
            tab.copyFrom(istruct);
            try {
                client.execute(function);
            }
            catch (Throwable thr) {
                RfcTest.out.println("STFC_STRUCTURE call failed, error message: \n");
                RfcTest.displayException(thr);
                System.exit(1);
                return;
            }
            RfcTest.out.println("Import Parameter IMPORTSTRUCT:\n");
            JRfcTest.displayParameters(function.getImportParameterList(), 0, true);
            RfcTest.out.println("\nExport Parameter ECHOSTRUCT:\n");
            JRfcTest.displayParameters(function.getExportParameterList(), 0, true);
            RfcTest.out.println("\nInternal Table RFCTABLE:");
            JRfcTest.displayParameters(function.getTableParameterList(), 0, true);
            JRfcTest.finalizeCall();
            if (numberOfCalls > numberOfCall + 1) {
                RfcTest.ask("\n\n\nHit return key for next RFC call", null);
                RfcTest.out.println("\n\n");
            }
            ++numberOfCall;
        }
        RfcTest.out.println("\n\n" + rhomb2 + " SAP JCo TEST - " + STRUCTURE_TEST + " " + rhomb2 + "\n\n");
    }

    private static void runTranRfcTest() {
        RfcTest.TidManager tidManager = new RfcTest.TidManager("trfctest.tid");
        RfcTest.out.println("\n\n" + rhomb1 + " SAP JCo TEST - " + TRANSACTIONAL_RFC + " " + rhomb1 + "\n\n");
        numberOfCall = 0;
        while (numberOfCall < numberOfCalls) {
            String tid;
            JRfcTest.initCall("STFC_WRITE_TO_TCPIC");
            JCO.Table tcpicdat = function.getTableParameterList().getTable("TCPICDAT");
            int i = 0;
            while (i < 10) {
                tcpicdat.appendRow();
                tcpicdat.setValue("Line No " + i + " ASYN-Test - " + numberOfCall + " :  12345678901234567890123456789012", "LINE");
                ++i;
            }
            try {
                tid = client.createTID();
                tidManager.update_TID(tid, "CREATED");
            }
            catch (Throwable thr) {
                RfcTest.out.println("createTID call failed, error message: \n");
                RfcTest.displayException(thr);
                System.exit(1);
                return;
            }
            try {
                client.execute(function, tid);
            }
            catch (Throwable thr) {
                RfcTest.out.println("STFC_WRITE_TO_TCPIC call failed, error message: \n");
                RfcTest.displayException(thr);
                System.exit(1);
                return;
            }
            if (!client.isAlive()) {
                try {
                    client = JCO.createClient(propValues);
                    client.connect();
                }
                catch (Throwable thr) {
                    RfcTest.out.println("Cannot create client, error message: \n");
                    RfcTest.displayException(thr);
                    System.exit(1);
                    return;
                }
            }
            try {
                client.confirmTID(tid);
                tidManager.update_TID(tid, "CONFIRMED");
            }
            catch (Throwable thr) {
                RfcTest.out.println("confirmTID call failed, error message: \n");
                RfcTest.displayException(thr);
                System.exit(1);
                return;
            }
            JRfcTest.finalizeCall();
            if (numberOfCalls > numberOfCall + 1) {
                RfcTest.ask("\n\n\nHit return key for next RFC call", null);
                RfcTest.out.println("\n\n");
            }
            ++numberOfCall;
        }
        RfcTest.out.println("\n\n" + rhomb2 + " SAP JCo TEST - " + TRANSACTIONAL_RFC + " " + rhomb2 + "\n\n");
    }

    private static void correctProperties() {
        numberOfCalls = Integer.parseInt(propValues.getProperty("jco.run.number_of_calls"));
        if (propValues.getProperty("jco.client.type").equals("3")) {
            if (propValues.getProperty("jco.client.load_balancing").equalsIgnoreCase("N")) {
                propValues.setProperty("jco.client.ashost", propValues.getProperty("jco.client.iashost"));
                propValues.setProperty("jco.client.sysnr", propValues.getProperty("jco.client.isysnr"));
                ((Hashtable)propValues).remove("jco.client.r3name");
                ((Hashtable)propValues).remove("jco.client.mhost");
                ((Hashtable)propValues).remove("jco.client.group");
            } else {
                propValues.setProperty("jco.client.r3name", propValues.getProperty("jco.client.ir3name"));
                propValues.setProperty("jco.client.mhost", propValues.getProperty("jco.client.imhost"));
                propValues.setProperty("jco.client.group", propValues.getProperty("jco.client.igroup"));
                ((Hashtable)propValues).remove("jco.client.ashost");
                ((Hashtable)propValues).remove("jco.client.sysnr");
            }
        }
        if (propValues.getProperty("jco.client.type").equals("2")) {
            propValues.setProperty("jco.client.dest", propValues.getProperty("jco.client.idest"));
            propValues.setProperty("jco.client.gwhost", propValues.getProperty("jco.client.igwhost"));
            propValues.setProperty("jco.client.gwserv", propValues.getProperty("jco.client.igwserv"));
            ((Hashtable)propValues).remove("jco.client.tpname");
        } else {
            ((Hashtable)propValues).remove("jco.client.dest");
        }
        if (propValues.getProperty("jco.client.type").equals("E")) {
            if (propValues.getProperty("jco.client.registprog").equalsIgnoreCase("y")) {
                propValues.setProperty("jco.client.tpname", propValues.getProperty("jco.client.tpid"));
            } else {
                propValues.setProperty("jco.client.tpname", propValues.getProperty("jco.client.itpname"));
                propValues.setProperty("jco.client.tphost", propValues.getProperty("jco.client.itphost"));
            }
            propValues.setProperty("jco.client.gwhost", propValues.getProperty("jco.client.igwhost"));
            propValues.setProperty("jco.client.gwserv", propValues.getProperty("jco.client.igwserv"));
        }
        if (propValues.getProperty("jco.client.type").equals("F")) {
            propValues.setProperty("jco.client.profile_name", propValues.getProperty("jco.client.iprofile_name"));
        }
        if (propValues.getProperty("jco.client.isnc_mode").equalsIgnoreCase("Y")) {
            propValues.setProperty("jco.client.snc_mode", "1");
            propValues.setProperty("jco.client.snc_lib", propValues.getProperty("jco.client.isnc_lib"));
            propValues.setProperty("jco.client.snc_partnername", propValues.getProperty("jco.client.isnc_partnername"));
        } else {
            ((Hashtable)propValues).remove("jco.client.snc_mode");
            ((Hashtable)propValues).remove("jco.client.snc_lib");
            ((Hashtable)propValues).remove("jco.client.snc_partnername");
        }
        if (propValues.getProperty("jco.client.iabap_debug").equalsIgnoreCase("Y")) {
            propValues.setProperty("jco.client.abap_debug", "1");
        } else {
            propValues.setProperty("jco.client.abap_debug", "0");
        }
        if (propValues.getProperty("jco.client.iuse_sapgui").equalsIgnoreCase("N")) {
            propValues.setProperty("jco.client.use_sapgui", "0");
        } else if (propValues.getProperty("jco.client.sapgui_invisible").equalsIgnoreCase("N")) {
            propValues.setProperty("jco.client.use_sapgui", "1");
        } else {
            propValues.setProperty("jco.client.use_sapgui", "2");
        }
        if (propValues.getProperty("jco.client.itrace").equalsIgnoreCase("Y")) {
            propValues.setProperty("jco.client.trace", "1");
        } else {
            propValues.setProperty("jco.client.trace", "0");
        }
        int traceLevel = Integer.parseInt(propValues.getProperty("jco.client.jco_trace_level"));
        JCO.setTraceLevel(traceLevel);
        if (traceLevel > 0) {
            JCO.setTracePath(".");
        }
        if (propValues.getProperty("jco.client.type").equals("E")) {
            propReposValues.setProperty("jco.client.client", propValues.getProperty("jco.client.iclient"));
            propReposValues.setProperty("jco.client.user", propValues.getProperty("jco.client.iuser"));
            propReposValues.setProperty("jco.client.passwd", propValues.getProperty("jco.client.ipasswd"));
            propReposValues.setProperty("jco.client.lang", propValues.getProperty("jco.client.ilang"));
            propReposValues.setProperty("jco.client.ashost", propValues.getProperty("jco.client.iashost"));
            propReposValues.setProperty("jco.client.sysnr", propValues.getProperty("jco.client.isysnr"));
        } else {
            propValues.setProperty("jco.client.client", propValues.getProperty("jco.client.iclient"));
            propValues.setProperty("jco.client.user", propValues.getProperty("jco.client.iuser"));
            propValues.setProperty("jco.client.passwd", propValues.getProperty("jco.client.ipasswd"));
            propValues.setProperty("jco.client.lang", propValues.getProperty("jco.client.ilang"));
        }
    }

    private static void initCall(String functionName) {
        if (numberOfCall == 0) {
            JRfcTest.correctProperties();
        }
        if (propValues.getProperty("jco.run.close_connect").equalsIgnoreCase("y") || numberOfCall == 0) {
            try {
                client = JCO.createClient(propValues);
                client.connect();
            }
            catch (Throwable thr) {
                RfcTest.out.println("Cannot create client, error message: \n");
                RfcTest.displayException(thr);
                System.exit(1);
                return;
            }
            if (propValues.getProperty("jco.client.type").equals("E")) {
                JCO.addClientPool(REPOS_CLIENTS, 10, propReposValues);
            } else {
                JCO.addClientPool(REPOS_CLIENTS, 10, propValues);
            }
            myRepos = JCO.createRepository("MYRepository", REPOS_CLIENTS);
        }
        try {
            IFunctionTemplate ftemplate = myRepos.getFunctionTemplate(functionName);
            if (ftemplate == null) {
                throw new RuntimeException("No meta data are available for " + functionName);
            }
            function = new JCO.Function(ftemplate);
        }
        catch (Throwable thr) {
            RfcTest.out.println("Cannot get function object of " + functionName + ", error message: \n");
            RfcTest.displayException(thr);
            if (client != null) {
                client.disconnect();
            }
            System.exit(1);
            return;
        }
    }

    protected static void displayParameters(JCO.Record input, int index, boolean displayText) {
        switch (input.getType(index)) {
            case 17: {
                JCO.Structure struct = input.getStructure(index);
                int j = 0;
                while (j < struct.getFieldCount()) {
                    JRfcTest.displayParameters(struct, j, displayText);
                    ++j;
                }
                break;
            }
            case 99: {
                JCO.Table table = input.getTable(index);
                if (table.isEmpty()) break;
                table.firstRow();
                int i = 0;
                while (i < table.getNumRows()) {
                    if (displayText) {
                        RfcTest.out.println("\nLine No.: " + (i + 1));
                    }
                    int j = 0;
                    while (j < table.getNumColumns()) {
                        JRfcTest.displayParameters(table, j, displayText);
                        ++j;
                    }
                    ++i;
                    table.nextRow();
                }
                break;
            }
            case -1: {
                RfcTest.out.println("Parameter " + input.getName(index) + " has invalid type " + input.getType(index));
                break;
            }
            default: {
                if (displayText) {
                    RfcTest.out.println(input.getName(index) + ": " + input.getString(index));
                    break;
                }
                RfcTest.out.println(input.getString(index));
            }
        }
    }

    private static void finalizeCall() {
        if (propValues.getProperty("jco.run.close_connect").equalsIgnoreCase("y") || numberOfCall + 1 == numberOfCalls) {
            try {
                client.disconnect();
                JCO.removeClientPool(REPOS_CLIENTS);
            }
            catch (Throwable thr) {
                RfcTest.out.println("Cannot disconnect clients, error message: \n");
                RfcTest.displayException(thr);
                System.exit(1);
            }
        }
    }

    private static String checkTable(String iType, JCO.Table tab, String type, int len, String checkTab) {
        int numberOfRows = tab.getNumRows();
        String returnMess = iType + " table (length " + type + "):";
        if (numberOfRows != len) {
            returnMess = returnMess + "  ERROR:  #Lines = " + numberOfRows + "  Expected: " + len;
        } else if (!checkTab.toUpperCase().equals("Y")) {
            returnMess = returnMess + "  #Lines = " + numberOfRows + ": OK,  Contents: NO CHECK";
        } else {
            if (!tab.isEmpty()) {
                String field = "";
                int pos = 0;
                int value = 0;
                int i = 0;
                while (i < numberOfRows) {
                    tab.setRow(i);
                    int j = 0;
                    while (j < tab.getNumColumns()) {
                        field = tab.getString(j);
                        pos = j == 0 ? 40 : 0;
                        int k = pos;
                        while (k < field.length()) {
                            value = k % 10;
                            if (!field.substring(k, k + 1).equals(String.valueOf(value))) {
                                returnMess = returnMess + " ERROR at line " + (i + 1) + " position " + k + ":  " + field.substring(k, k + 1) + "/" + value;
                                return returnMess;
                            }
                            ++k;
                        }
                        if (field.length() < tab.getField(j).getLength()) {
                            int expectValue;
                            int currPos;
                            if (j == 0 && field.length() < 40) {
                                currPos = 40;
                                expectValue = 0;
                            } else {
                                currPos = field.length();
                                expectValue = field.length() % 10;
                            }
                            returnMess = returnMess + " ERROR at line " + (i + 1) + " position " + currPos + ":   /" + expectValue;
                            return returnMess;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            returnMess = returnMess + "  #Lines = " + numberOfRows + ": OK,  Contents: OK";
        }
        return returnMess;
    }

    private static void fillTable(JCO.Table tab, int len) {
        if (len < 1) {
            return;
        }
        tab.deleteAllRows();
        tab.appendRows(len);
        int i = 0;
        while (i < len) {
            tab.setRow(i);
            String field = "Line Length: " + tab.getTabLength() + " Line No.: " + (i + 1);
            int j = field.length();
            while (j < 40) {
                field = field + " ";
                ++j;
            }
            int pos = 0;
            int j2 = 0;
            while (j2 < tab.getNumColumns()) {
                if (j2 == 0) {
                    pos = 40;
                } else {
                    pos = 0;
                    field = "";
                }
                int k = pos;
                while (k < tab.getField(j2).getLength()) {
                    field = field + String.valueOf(k % 10);
                    ++k;
                }
                tab.setValue(field, j2);
                ++j2;
            }
            ++i;
        }
    }

    static {
        JRfcTest.initProperties();
        propLabels.setProperty("jco.client.type", space1 + "Server is R/2, R/3 or External (2/3/F/E):");
        propLabels.setProperty("jco.client.load_balancing", space1 + "Use load balancing (Y/N)Y...............:");
        propLabels.setProperty("jco.client.iashost", space1 + "Host name of an application server......:");
        propLabels.setProperty("jco.client.isysnr", space1 + "System number...........................:");
        propLabels.setProperty("jco.client.ir3name", space1 + "R/3 system name.........................:");
        propLabels.setProperty("jco.client.imhost", space1 + "Message server..........................:");
        propLabels.setProperty("jco.client.igroup", space1 + "Selected group..........................:");
        propLabels.setProperty("jco.client.isnc_mode", space1 + "Working with SNC (Y/N)N.................:");
        propLabels.setProperty("jco.client.idest", space1 + "DEST in 'sideinfo' for the SAP gateway..:");
        propLabels.setProperty("jco.client.igwhost", space1 + "Host name of the SAP gateway............:");
        propLabels.setProperty("jco.client.igwserv", space1 + "Service of the specified gateway........:");
        propLabels.setProperty("jco.client.registprog", space1 + "Using registering feature (Y/N)Y........:");
        propLabels.setProperty("jco.client.tpid", space1 + "Program ID of registered partner program:");
        propLabels.setProperty("jco.client.itpname", space1 + "Fully qualified name of partner program.:");
        propLabels.setProperty("jco.client.itphost", space1 + "Host name of the partner program........:");
        propLabels.setProperty("jco.client.iprofile_name", space1 + "Profile file name (profil_gen.txt)......:");
        propLabels.setProperty("jco.client.isnc_lib", space1 + "SNC Library Name........................:");
        propLabels.setProperty("jco.client.isnc_partnername", space1 + "SNC name of partner program.............:");
        propLabels.setProperty("jco.client.iclient", space1 + "Client..................................:");
        propLabels.setProperty("jco.client.iuser", space1 + "UserID..................................:");
        propLabels.setProperty("jco.client.ipasswd", space1 + "Password................................:");
        propLabels.setProperty("jco.client.ilang", space1 + "Language (E)............................:");
        propLabels.setProperty("jco.client.iabap_debug", space1 + "Working with ABAP debugger (Y/N)N.......:");
        propLabels.setProperty("jco.client.iuse_sapgui", space1 + "Use SAPGUI (Y/N)N.......................:");
        propLabels.setProperty("jco.client.sapgui_invisible", space1 + "Automatically invisible SAPGUI (Y/N)N...:");
        propLabels.setProperty("jco.client.itrace", space1 + "RFC trace (Y/N)N........................:");
        propLabels.setProperty("jco.client.jco_trace_level", space1 + "JCo trace level (0-10)..................:");
        propLabels.setProperty("jco.gui.test_type", space1 + "Start transaction or function (T/F)F....:");
        propLabels.setProperty("jco.gui.fm_name", space1 + "Name of function module in R/3..........:");
        propLabels.setProperty("jco.gui.transaction_name", space1 + "Name of transaction (SE38)..............:");
        propLabels.setProperty("jco.perform.elength0332", space1 + "#Lines in export table (length 0332)....:");
        propLabels.setProperty("jco.perform.elength1000", space1 + "#Lines in export table (length 1000)....:");
        propLabels.setProperty("jco.perform.ilength0332", space1 + "#Lines in import table (length 0332)....:");
        propLabels.setProperty("jco.perform.ilength1000", space1 + "#Lines in import table (length 1000)....:");
        propLabels.setProperty("jco.perform.checktable", space1 + "Check contents of tables (Y/N)N.........:");
        propLabels.setProperty("jco.perform.display_tab", space1 + "Output tables on screen (Y/N)N..........:");
        propLabels.setProperty("jco.run.number_of_calls", space2 + "#Calls of this JCo Test...................:");
        propLabels.setProperty("jco.run.close_connect", space2 + "Close connection after each call (Y/N)N...:");
    }
}

