/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.coco.runtime;

import com.sun.encoder.coco.runtime.CobolDataConverter;
import com.sun.encoder.coco.runtime.RuleNode;
import com.sun.encoder.coco.runtime.messages.ErrorManager;
import com.sun.encoder.coco.runtime.messages.Message;
import com.sun.encoder.coco.runtime.messages.MessageCatalog;
import com.sun.encoder.tools.xml.EmptyAttributes;
import com.sun.encoder.tools.xml.SchemaLocationAttributes;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class UnmarshalAdaptor
implements XMLReader {
    private static final ErrorManager cErrorMgr = ErrorManager.getManager("OpenESB.encoder.COBOLCopybook." + UnmarshalAdaptor.class.getName());
    private static final Attributes mEmptyAttributes = new EmptyAttributes();
    private final URL mSchemaLocation;
    private final RuleNode mTopRule;
    private final byte[][] mRedefined;
    private final Integer[] mOccursDependOn;
    private EntityResolver mEntityResolver;
    private DTDHandler mDTDHandler;
    private ContentHandler mContentHandler;
    private ErrorHandler mErrorHandler;
    private InputStream mInStream;
    private String mPublicId;
    private String mSystemId;
    private long mBytesRead;

    public UnmarshalAdaptor(URL schemaLocation, RuleNode topRule) {
        if (topRule == null) {
            throw new NullPointerException("no top rule.");
        }
        this.mSchemaLocation = schemaLocation;
        this.mTopRule = topRule;
        this.mRedefined = new byte[topRule.getContext().getRedefinedNodes().length][];
        this.mOccursDependOn = new Integer[topRule.getContext().getOccursDependOnNodes().length];
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            return true;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            return false;
        }
        throw new SAXNotRecognizedException();
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            if (!value) {
                throw new SAXNotSupportedException("Feature '" + name + "' with value " + value + " is not supported.");
            }
            return;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            if (value) {
                throw new SAXNotSupportedException("Feature '" + name + "' with value " + value + " is not supported.");
            }
            return;
        }
        throw new SAXNotRecognizedException();
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.mEntityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this.mEntityResolver;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.mDTDHandler = handler;
    }

    public DTDHandler getDTDHandler() {
        return this.mDTDHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this.mContentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.mContentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.mErrorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.mErrorHandler;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        if (this.mContentHandler == null) {
            throw new NullPointerException("Missing content handler.");
        }
        this.mInStream = input.getByteStream();
        if (this.mInStream == null) {
            throw new NullPointerException("No input.");
        }
        if (!this.mInStream.markSupported()) {
            this.mInStream = new BufferedInputStream(this.mInStream);
        }
        this.mContentHandler.startDocument();
        this.mContentHandler.startPrefixMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.parse(this.mTopRule, this.mInStream);
        this.mContentHandler.endPrefixMapping("xsi");
        this.mContentHandler.endDocument();
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    private void parse(RuleNode rule, InputStream inStream) throws IOException, SAXException {
        int occurs;
        if (rule.getOccursDependOn() == null) {
            occurs = rule.getMaxOccurs();
        } else {
            if (this.mOccursDependOn[rule.getOccursDependOn().getOccursDependOnIndex()] == null) {
                this.throwException("Occurs Depending On field has not been evaluated: " + rule.getOccursDependOn().getQName(), null);
            }
            occurs = this.mOccursDependOn[rule.getOccursDependOn().getOccursDependOnIndex()];
        }
        if (rule.getRedefineIndex() >= 0) {
            this.mInStream.mark(rule.getCharacteristics().getSize() + 1);
            byte[] bytes = new byte[rule.getCharacteristics().getSize()];
            this.mInStream.read(bytes);
            this.mInStream.reset();
            this.mRedefined[rule.getRedefineIndex()] = bytes;
        }
        InputStream currentStream = inStream;
        if (rule.getRedefinedNode() != null) {
            if (this.mRedefined[rule.getRedefinedNode().getRedefineIndex()] == null) {
                this.throwException("Redefined field has not been evaluated: " + rule.getRedefinedNode().getQName(), null);
            }
            currentStream = new BufferedInputStream(new ByteArrayInputStream(this.mRedefined[rule.getRedefinedNode().getRedefineIndex()]));
        }
        while (occurs > 0) {
            if (rule.isTop()) {
                this.mContentHandler.startElement(rule.getQName().getNamespaceURI(), rule.getQName().getLocalPart(), rule.getQName().getLocalPart(), (Attributes)new SchemaLocationAttributes(rule.getQName().getNamespaceURI(), this.mSchemaLocation));
            } else {
                this.mContentHandler.startElement(rule.getQName().getNamespaceURI(), rule.getQName().getLocalPart(), rule.getQName().getLocalPart(), mEmptyAttributes);
            }
            RuleNode[] children = rule.getChildren();
            if (children == null || children.length == 0) {
                String data;
                block0 : switch (rule.getCharacteristics().getUsage()) {
                    case 8: {
                        data = String.valueOf(CobolDataConverter.decodeToFloat(currentStream));
                        break;
                    }
                    case 9: {
                        data = String.valueOf(CobolDataConverter.decodeToDouble(currentStream));
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 11: {
                        data = CobolDataConverter.decodeToBigDecimal(currentStream, rule.getPicture(), rule.getCharacteristics(), rule.getCharEncoding()).toString();
                        break;
                    }
                    case 1: 
                    case 10: {
                        switch (rule.getCharacteristics().getPicCategory()) {
                            case 4: 
                            case 7: {
                                data = CobolDataConverter.decodeToBigDecimal(currentStream, rule.getPicture(), rule.getCharacteristics(), rule.getCharEncoding()).toString();
                                break block0;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 5: 
                            case 6: {
                                data = CobolDataConverter.decodeToString(currentStream, rule.getPicture(), rule.getCharacteristics(), rule.getCharEncoding());
                                break block0;
                            }
                        }
                        Message msg = MessageCatalog.getMessage("CCCB4113");
                        String err = msg.formatText(new Object[]{rule.getQName(), rule.getCharacteristics().getUsage()});
                        cErrorMgr.log(ErrorManager.Severity.ERROR, null, err);
                        throw new SAXException(err);
                    }
                    default: {
                        Message msg = MessageCatalog.getMessage("CCCB4112");
                        String err = msg.formatText(new Object[]{rule.getQName(), rule.getCharacteristics().getUsage()});
                        cErrorMgr.log(ErrorManager.Severity.ERROR, null, err);
                        throw new SAXException(err);
                    }
                }
                char[] chars = new char[data.length()];
                data.getChars(0, data.length(), chars, 0);
                this.mContentHandler.characters(chars, 0, chars.length);
                int dependOnIndex = rule.getOccursDependOnIndex();
                if (dependOnIndex >= 0) {
                    this.mOccursDependOn[dependOnIndex] = new Integer(data);
                }
            } else {
                for (int i = 0; i < children.length; ++i) {
                    this.parse(children[i], currentStream);
                }
            }
            this.mContentHandler.endElement(rule.getQName().getNamespaceURI(), rule.getQName().getLocalPart(), rule.getQName().getLocalPart());
            --occurs;
        }
    }

    private void throwException(String msg, Exception cause) throws SAXException {
        throw new SAXParseException(msg, new LocatorImpl(), cause);
    }

    private class LocatorImpl
    implements Locator {
        private LocatorImpl() {
        }

        public String getPublicId() {
            return UnmarshalAdaptor.this.mPublicId;
        }

        public String getSystemId() {
            return UnmarshalAdaptor.this.mSystemId;
        }

        public int getLineNumber() {
            return 1;
        }

        public int getColumnNumber() {
            return (int)UnmarshalAdaptor.this.mBytesRead;
        }
    }
}

