/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Time;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class DateTime
extends Date {
    private static final long serialVersionUID = -6407231357919440387L;
    private static final String DEFAULT_PATTERN = "yyyyMMdd'T'HHmmss";
    private static final String UTC_PATTERN = "yyyyMMdd'T'HHmmss'Z'";
    private static final String RELAXED_PATTERN = "yyyyMMdd";
    private static final DateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private static final DateFormat DEFAULT_FORMAT;
    private static final DateFormat LENIENT_DEFAULT_FORMAT;
    private static final DateFormat RELAXED_FORMAT;
    private Time time;
    private TimeZone timezone;

    public DateTime() {
        super(0);
        this.time = new Time(System.currentTimeMillis(), this.getFormat().getTimeZone());
    }

    public DateTime(boolean utc) {
        this();
        this.setUtc(utc);
    }

    public DateTime(long time) {
        super(time, 0);
        this.time = new Time(time, this.getFormat().getTimeZone());
    }

    public DateTime(java.util.Date date) {
        super(date.getTime(), 0);
        this.time = new Time(date.getTime(), this.getFormat().getTimeZone());
        if (date instanceof DateTime) {
            DateTime dateTime = (DateTime)date;
            if (dateTime.isUtc()) {
                this.setUtc(true);
            } else {
                this.setTimeZone(dateTime.getTimeZone());
            }
        }
    }

    public DateTime(String value) throws ParseException {
        this(value, null);
    }

    public DateTime(String value, TimeZone timezone) throws ParseException {
        this();
        try {
            this.setTime(value, UTC_FORMAT, null);
            this.setUtc(true);
        }
        catch (ParseException pe) {
            block7: {
                try {
                    if (timezone != null) {
                        this.setTime(value, DEFAULT_FORMAT, timezone);
                    } else {
                        this.setTime(value, LENIENT_DEFAULT_FORMAT, this.getFormat().getTimeZone());
                    }
                }
                catch (ParseException pe2) {
                    if (CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed")) {
                        this.setTime(value, RELAXED_FORMAT, timezone);
                        break block7;
                    }
                    throw pe;
                }
            }
            this.setTimeZone(timezone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTime(String value, DateFormat format, java.util.TimeZone tz) throws ParseException {
        DateFormat dateFormat = format;
        synchronized (dateFormat) {
            if (tz != null) {
                format.setTimeZone(tz);
            }
            this.setTime(format.parse(value).getTime());
        }
    }

    public final void setTime(long time) {
        super.setTime(time);
        this.time.setTime(time);
    }

    public final boolean isUtc() {
        return this.time.isUtc();
    }

    public final void setUtc(boolean utc) {
        this.setTimeZone(null);
        if (utc) {
            this.getFormat().setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
            this.time = new Time(this.time, this.getFormat().getTimeZone());
        }
    }

    public final void setTimeZone(TimeZone timezone) {
        this.timezone = timezone;
        if (timezone != null) {
            this.getFormat().setTimeZone(timezone);
        } else {
            this.getFormat().setTimeZone(TimeZone.getDefault());
        }
        this.time = new Time(this.time, this.getFormat().getTimeZone());
    }

    public final TimeZone getTimeZone() {
        return this.timezone;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer(super.toString());
        b.append('T');
        b.append(this.time.toString());
        return b.toString();
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof DateTime) {
            return ObjectUtils.equals((Object)this.time, (Object)((DateTime)arg0).time);
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.time).append((Object)this.timezone).hashCode();
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        UTC_FORMAT.setLenient(false);
        DEFAULT_FORMAT = new SimpleDateFormat(DEFAULT_PATTERN);
        DEFAULT_FORMAT.setLenient(false);
        LENIENT_DEFAULT_FORMAT = new SimpleDateFormat(DEFAULT_PATTERN);
        RELAXED_FORMAT = new SimpleDateFormat(RELAXED_PATTERN);
    }
}

