/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.collections.primitives.IntCollection;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.ExternalTable;
import org.axiondb.Index;
import org.axiondb.Row;
import org.axiondb.RowCollection;
import org.axiondb.RowIterator;
import org.axiondb.TableFactory;
import org.axiondb.engine.rowiterators.BaseRowIterator;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.engine.tables.BaseTable;
import org.axiondb.engine.tables.BaseTableOrganizationContext;
import org.axiondb.engine.tables.RSSTableLoader;
import org.axiondb.engine.tables.SpreadsheetTable;
import org.axiondb.io.AxionFileSystem;
import org.axiondb.io.FileUtil;
import org.axiondb.types.CharacterType;
import org.axiondb.types.StringType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RSSTable
extends BaseTable
implements ExternalTable {
    protected File _dbdir = null;
    protected boolean _readOnly = false;
    private int _rowCount = -1;
    private int _currentRow = -1;
    private File _dir;
    protected String _urls;
    private Element[] tags = null;
    private String[] urls = null;
    private static final String ITEM = "item";
    private static final String VERSION = "version";
    private Properties prop = new Properties();
    public static final String PROP_URL = "URL";
    protected static final String META_FILE_EXT = ".META";
    protected static final String TYPE_FILE_EXT = ".TYPE";
    private RSSTableOrganizationContext context;
    protected static AxionFileSystem FS = new AxionFileSystem();
    protected static final int CURRENT_META_VERSION = 3;
    private static final Set PROPERTY_KEYS = new HashSet(3);
    private DocumentBuilderFactory factory;
    private DocumentBuilder builder;

    public RSSTable(String name, Database db) throws AxionException {
        super(name);
        this.setType("RSS TABLE");
        this._dbdir = db.getDBDirectory();
        this._readOnly = db.isReadOnly();
        this.createOrLoadTableFiles(name, db, new RSSTableLoader());
    }

    public void applyDeletes(IntCollection rowids) throws AxionException {
        throw new AxionException("Operation not supported");
    }

    public void applyInserts(RowCollection rows) throws AxionException {
        throw new AxionException("Operation not supported");
    }

    public void applyUpdates(RowCollection rows) throws AxionException {
        throw new AxionException("Operation not supported");
    }

    public void freeRowId(int id) {
    }

    public int getNextRowId() {
        return this._currentRow + 1;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public void populateIndex(Index index) throws AxionException {
    }

    public Row getRow(int id) throws AxionException {
        Row row;
        try {
            int colCount = this.getColumnCount();
            row = new SimpleRow(id, colCount);
            for (int i = 0; i < colCount; ++i) {
                String columnValue = this.getColumnValue(id, this.getColumn(i).getName());
                row = this.trySettingColumn(id, row, i, columnValue);
            }
        }
        catch (Exception ex) {
            throw new AxionException(ex);
        }
        this._currentRow = id;
        return row;
    }

    protected RowIterator getRowIterator() throws AxionException {
        return new BaseRowIterator(){
            Row _current = null;
            int _currentId = 0;
            int _currentIndex = 0;
            int _nextId = 1;
            int _nextIndex = 1;

            public Row current() {
                if (!this.hasCurrent()) {
                    throw new NoSuchElementException("No current row.");
                }
                return this._current;
            }

            public final int currentIndex() {
                return this._currentIndex;
            }

            public final boolean hasCurrent() {
                return null != this._current;
            }

            public final boolean hasNext() {
                return this.nextIndex() <= RSSTable.this.getRowCount();
            }

            public final boolean hasPrevious() {
                return this.nextIndex() > 1;
            }

            public Row last() throws AxionException {
                if (this.isEmpty()) {
                    throw new IllegalStateException("No rows in table.");
                }
                this._nextIndex = RSSTable.this.getRowCount();
                this._nextId = this._nextIndex++;
                this.previous();
                ++this._nextId;
                return this.current();
            }

            public Row next() throws AxionException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No next row");
                }
                do {
                    ++this._nextId;
                    this._currentId = this._currentId;
                    this._current = RSSTable.this.getRowByOffset(this._currentId);
                } while (null == this._current);
                this._currentIndex = this._nextIndex++;
                return this._current;
            }

            public final int nextIndex() {
                return this._nextIndex;
            }

            public Row previous() throws AxionException {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException("No previous row");
                }
                do {
                    this._currentId = --this._nextId;
                    this._current = RSSTable.this.getRowByOffset(this._currentId);
                } while (null == this._current);
                --this._nextIndex;
                this._currentIndex = this._nextIndex;
                return this._current;
            }

            public final int previousIndex() {
                return this._nextIndex - 1;
            }

            public void remove() throws AxionException {
                if (0 == this._currentIndex) {
                    throw new IllegalStateException("No current row.");
                }
                RSSTable.this.deleteRow(this._current);
                --this._nextIndex;
                this._currentIndex = 0;
            }

            public void reset() {
                this._current = null;
                this._nextIndex = 1;
                this._currentId = 0;
                this._currentIndex = 0;
                this._nextId = 1;
            }

            public final void set(Row row) throws AxionException {
                if (0 == this._currentIndex) {
                    throw new IllegalStateException("No current row.");
                }
                RSSTable.this.updateRow(this._current, row);
            }

            public final int size() throws AxionException {
                return RSSTable.this.getRowCount();
            }

            public String toString() {
                return "RSSTable(" + RSSTable.this.getName() + ")";
            }

            private Row setCurrentRow() throws AxionException {
                Row row = RSSTable.this.getRowByOffset(this._currentId);
                if (row != null) {
                    this._current = row;
                    return this._current;
                }
                throw new IllegalStateException("No valid row at position " + this._currentIndex);
            }
        };
    }

    public void truncate() throws AxionException {
    }

    public boolean loadExternalTable(Properties prop) throws AxionException {
        try {
            if (this.context == null) {
                this.context = new RSSTableOrganizationContext();
            }
            this.context.readOrSetDefaultProperties(prop);
            this.context.updateProperties();
            this.initializeTable();
            this.writeMetaFile();
            return true;
        }
        catch (Exception e) {
            try {
                this.drop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new AxionException("Failed to create table using supplied properties. ", e);
        }
    }

    public void drop() throws AxionException {
        super.drop();
        if (!FileUtil.delete(this.getRootDir())) {
            throw new AxionException("Unable to delete \"" + this.getRootDir() + "\" during drop table " + this.getName());
        }
    }

    public Properties getTableProperties() {
        this.prop.clear();
        this.prop.put("LOADTYPE", "RSS");
        this.prop.put(PROP_URL, this._urls);
        return this.prop;
    }

    public void remount() throws AxionException {
        try {
            this.initializeTable();
        }
        catch (Exception ex) {
            throw new AxionException(ex);
        }
    }

    protected boolean isNullString(String str) {
        return str == null || str.trim().length() == 0;
    }

    private String getDefaultDataFileExtension() {
        return "xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrLoadTableFiles(String name, Database db, TableFactory factory) throws AxionException {
        Class<SpreadsheetTable> clazz = SpreadsheetTable.class;
        synchronized (SpreadsheetTable.class) {
            this._dir = new File(db.getDBDirectory(), name.toUpperCase());
            if (!this._dir.exists() && !this._dir.mkdirs()) {
                throw new AxionException("Unable to create directory \"" + this._dir + "\" for Table \"" + name + "\".");
            }
            File typefile = this.getTableFile(TYPE_FILE_EXT);
            if (!typefile.exists()) {
                this.writeNameToFile(typefile, factory);
            }
            this.loadOrMigrateMetaFile(db);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    protected void loadOrMigrateMetaFile(Database db) throws AxionException {
        this.migrate(db);
    }

    public void migrate(Database db) throws AxionException {
        File metaFile = this.getTableFile(META_FILE_EXT);
        if (!metaFile.exists()) {
            return;
        }
        int version = 3;
        ObjectInputStream in = null;
        try {
            in = FS.openObjectInputSteam(metaFile);
            version = in.readInt();
            if (version < 0 || version > 3) {
                throw new AxionException("Unrecognized version " + version);
            }
            if (version == 0) {
                this.parseV0MetaFile(in);
            } else {
                this.parseV1MetaFile(in, db);
            }
            this.parseTableProperties(in);
        }
        catch (ClassNotFoundException e) {
            throw new AxionException("Unable to parse meta file " + metaFile + " for table " + this.getName(), e);
        }
        catch (IOException e) {
            throw new AxionException("Unable to parse meta file " + metaFile + " for table " + this.getName(), e);
        }
        finally {
            FS.closeInputStream(in);
        }
        if (version < 3) {
            int I = this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                Column col = this.getColumn(i);
                col.getConfiguration().put("name", col.getName().toUpperCase());
            }
        }
        if (version != 3) {
            this.writeMetaFile();
        }
    }

    private void parseV0MetaFile(ObjectInputStream in) throws IOException, AxionException {
        int I = in.readInt();
        for (int i = 0; i < I; ++i) {
            String name = in.readUTF();
            String dtypename = in.readUTF();
            DataType type = null;
            try {
                Class<?> clazz = Class.forName(dtypename);
                type = (DataType)clazz.newInstance();
            }
            catch (Exception e) {
                throw new AxionException("Can't load table " + this.getName() + ", data type " + dtypename + " not found.", e);
            }
            this.addColumn(new Column(name, type), false);
        }
    }

    protected void parseTableProperties(ObjectInputStream in) throws AxionException {
        try {
            this._urls = in.readUTF();
            this.context = new RSSTableOrganizationContext();
            this.context.updateProperties();
            this.context.readOrSetDefaultProperties(this.context.getTableProperties());
            this.initializeTable();
        }
        catch (IOException ioex) {
            throw new AxionException("Unable to parse meta file for table " + this.getName(), ioex);
        }
    }

    public void addColumn(Column col, boolean metaUpdateNeeded) throws AxionException {
        super.addColumn(col);
        if (metaUpdateNeeded) {
            this.writeMetaFile();
        }
    }

    private void parseV1MetaFile(ObjectInputStream in, Database db) throws AxionException, IOException, ClassNotFoundException {
        this.readColumns(in);
        this.readConstraints(in, db);
    }

    private void writeMetaFile() throws AxionException {
        ObjectOutputStream out = null;
        File metaFile = this.getTableFile(META_FILE_EXT);
        try {
            out = FS.createObjectOutputSteam(metaFile);
            out.writeInt(3);
            this.writeColumns(out);
            out.flush();
            this.writeConstraints(out);
            out.flush();
            this.writeTableProperties(out);
            out.flush();
        }
        catch (IOException e) {
            throw new AxionException("Unable to write meta file " + metaFile + " for table " + this.getName(), e);
        }
        finally {
            FS.closeOutputStream(out);
        }
    }

    protected void writeTableProperties(ObjectOutputStream out) throws AxionException {
        try {
            if (this._urls != null) {
                out.writeUTF(this._urls);
                out.flush();
            }
        }
        catch (IOException ioex) {
            throw new AxionException("Unable to write meta file for table " + this.getName(), ioex);
        }
        finally {
            FS.closeOutputStream(out);
        }
    }

    protected void writeNameToFile(File file, Object obj) throws AxionException {
        ObjectOutputStream out = null;
        try {
            out = FS.createObjectOutputSteam(file);
            out.writeUTF(obj.getClass().getName());
            out.flush();
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
        finally {
            FS.closeOutputStream(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Row getRowByOffset(int idToAssign) throws AxionException {
        Row row;
        RSSTable rSSTable = this;
        synchronized (rSSTable) {
            try {
                int colCount = this.getColumnCount();
                row = new SimpleRow(idToAssign, colCount);
                for (int i = 0; i < colCount; ++i) {
                    String columnValue = this.getColumnValue(idToAssign, this.getColumn(i).getName());
                    row = this.trySettingColumn(idToAssign, row, i, columnValue);
                }
            }
            catch (Exception e) {
                if (e instanceof AxionException) {
                    throw (AxionException)e;
                }
                throw new AxionException(e);
            }
        }
        return row;
    }

    private Row trySettingColumn(int idToAssign, Row row, int i, String colValue) throws AxionException {
        DataType columnDataType = this.getColumn(i).getDataType();
        if ((colValue = this.evaluateForNull(colValue, columnDataType)) == null) {
            row.set(i, null);
        } else {
            Object val = columnDataType.convert(colValue);
            row.set(i, val);
        }
        return row;
    }

    private String evaluateForNull(String colValue, DataType datatype) {
        if (null == colValue) {
            return null;
        }
        if (datatype instanceof CharacterType) {
            int colWidth = datatype.getPrecision();
            return colWidth <= 0 || colValue.length() == colWidth && colValue.trim().length() == 0 ? null : colValue;
        }
        if (!(datatype instanceof StringType) && colValue.trim().length() == 0) {
            return null;
        }
        return colValue;
    }

    protected void initializeTable() throws AxionException {
        try {
            this.parseUsingDOM();
            int size = 0;
            for (Element element : this.tags) {
                size += element.getElementsByTagName(ITEM).getLength();
            }
            this._rowCount = size;
            this._currentRow = 0;
        }
        catch (Exception ex) {
            throw new AxionException(ex);
        }
    }

    protected File getTableFile(String extension) {
        return new File(this.getRootDir(), this.getName().toUpperCase() + extension);
    }

    protected File getRootDir() {
        return this._dir;
    }

    private void parseUsingDOM() throws Exception {
        this.factory = DocumentBuilderFactory.newInstance();
        this.builder = this.factory.newDocumentBuilder();
        this.tags = new Element[this.urls.length];
        int i = 0;
        for (String url : this.urls) {
            HttpURLConnection conn = null;
            if (url.indexOf("?") != -1) {
                String[] props;
                String actualUrl = url.substring(0, url.indexOf("?"));
                conn = (HttpURLConnection)new URL(actualUrl).openConnection();
                String tempString = url.substring(url.indexOf("?") + 1);
                for (String prop : props = tempString.split("&")) {
                    String[] val = prop.split("=");
                    if (val.length == 2) {
                        conn.setRequestProperty(val[0], val[1]);
                        continue;
                    }
                    if (val.length != 1) continue;
                    conn.setRequestProperty(val[0], null);
                }
                conn.connect();
            } else {
                conn = (HttpURLConnection)new URL(url).openConnection();
            }
            Element elem = this.builder.parse(conn.getInputStream()).getDocumentElement();
            if (!elem.getNodeName().equalsIgnoreCase("rss")) {
                throw new Exception("Document type not supported.");
            }
            this.tags[i++] = elem;
        }
    }

    private String getColumnValue(int id, String columnName) throws Exception {
        StringBuffer value = new StringBuffer("");
        int count = 0;
        int prevCount = 0;
        Element match = null;
        for (Element tag : this.tags) {
            NodeList children = tag.getElementsByTagName(ITEM);
            prevCount = count;
            if (id > (count += children.getLength())) continue;
            match = (Element)children.item(id - prevCount - 1);
            break;
        }
        if (match == null) {
            throw new Exception("Row not found");
        }
        NodeList columns = match.getElementsByTagName(columnName.toLowerCase());
        block1: for (int i = 0; i < columns.getLength(); ++i) {
            if (value.toString().trim().length() != 0) {
                value.append(",");
            }
            Element col = (Element)columns.item(i);
            NodeList childList = col.getChildNodes();
            for (int j = 0; j < childList.getLength(); ++j) {
                Node nd = childList.item(j);
                if (nd.getNodeType() != 3) continue;
                value.append(nd.getNodeValue());
                continue block1;
            }
        }
        return value.toString();
    }

    static /* synthetic */ String[] access$202(RSSTable x0, String[] x1) {
        x0.urls = x1;
        return x1;
    }

    static {
        PROPERTY_KEYS.add(PROP_URL);
        PROPERTY_KEYS.add("LOADTYPE");
    }

    private class RSSTableOrganizationContext
    extends BaseTableOrganizationContext {
        private RSSTableOrganizationContext() {
        }

        public Set getPropertyKeys() {
            HashSet keys = new HashSet(PROPERTY_KEYS.size());
            keys.addAll(PROPERTY_KEYS);
            return keys;
        }

        public void readOrSetDefaultProperties(Properties props) throws AxionException {
            this.assertValidPropertyKeys(props);
            RSSTable.this._urls = props.getProperty(RSSTable.PROP_URL);
            RSSTable.access$202(RSSTable.this, RSSTable.this._urls.split(","));
        }

        public void updateProperties() {
            super.updateProperties();
            this._props.setProperty("LOADTYPE", "RSS");
            this._props.setProperty(RSSTable.PROP_URL, RSSTable.this._urls);
        }

        public Set getRequiredPropertyKeys() {
            HashSet keys = new HashSet(PROPERTY_KEYS.size());
            keys.addAll(PROPERTY_KEYS);
            return keys;
        }
    }
}

