/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.io.File;
import java.io.IOException;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.Row;
import org.axiondb.engine.DiskTableFactory;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.engine.tables.BaseDiskTable;
import org.axiondb.engine.tables.GlomLobsHelper;
import org.axiondb.io.BufferedDataInputStream;
import org.axiondb.io.BufferedDataOutputStream;
import org.axiondb.io.FileUtil;

public final class DiskTable
extends BaseDiskTable {
    private File _lobDir = null;
    private static final String LOBS_DIR_NAME = "LOBS";

    public DiskTable(String name, Database db) throws AxionException {
        super(name, db, new DiskTableFactory());
        this.createOrLoadDataFile();
        this._lobDir = new File(this.getRootDir(), LOBS_DIR_NAME);
        this.notifyColumnsOfNewLobDir(this._lobDir);
    }

    public GlomLobsHelper getGlomLobsHelper() {
        return new GlomLobsHelper(this);
    }

    public void glomLobs() throws Exception {
        this.getGlomLobsHelper().glomLobs();
    }

    protected File getDataFile() {
        if (null == this._dataFile) {
            this._dataFile = new File(this.getRootDir(), this.getName() + "." + this.getDefaultDataFileExtension());
        }
        return this._dataFile;
    }

    protected File getLobDir() {
        return this._lobDir;
    }

    protected Row getRowByOffset(int idToAssign, long ptr) throws AxionException {
        BufferedDataInputStream file = this.getInputStream();
        return this.getRowByOffset(idToAssign, ptr, file);
    }

    protected void initFiles(File basedir, boolean datafilesonly) throws AxionException {
        super.initFiles(basedir, datafilesonly);
        this._lobDir = new File(this.getRootDir(), LOBS_DIR_NAME);
        this.notifyColumnsOfNewLobDir(this._lobDir);
    }

    protected void reloadFilesAfterTruncate() throws AxionException {
        this._freeIds = new ArrayIntList();
        this.writeFridFile();
        try {
            if (!this.isReadOnly()) {
                this.getDataFile().createNewFile();
            }
        }
        catch (IOException e) {
            throw new AxionException("Unable to create data file \"" + this.getDataFile() + "\".", e);
        }
        this.initFiles(this.getDataFile(), true);
        this.initializeRowCount();
        this.resetLobColumns();
    }

    protected synchronized void renameTableFiles(String oldName, String name) {
        super.renameTableFiles(oldName, name);
        FileUtil.renameFile(this.getRootDir(), oldName, name, "." + this.getDefaultDataFileExtension());
    }

    protected void writeRow(BufferedDataOutputStream out, Row row) throws AxionException {
        try {
            int I = this.getColumnCount();
            for (int i = 0; i < I; ++i) {
                this.getColumn(i).getDataType().write(row.get(i), out);
            }
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Row getRowByOffset(int idToAssign, long ptr, BufferedDataInputStream data) throws AxionException {
        try {
            SimpleRow row = new SimpleRow(idToAssign, this.getColumnCount());
            BufferedDataInputStream bufferedDataInputStream = data;
            synchronized (bufferedDataInputStream) {
                data.seek(ptr);
                int I = this.getColumnCount();
                for (int i = 0; i < I; ++i) {
                    row.set(i, this.getColumn(i).getDataType().read(data));
                }
            }
            return row;
        }
        catch (IOException e) {
            throw new AxionException("IOException in getRowByOffset while reading row for table " + this.getName() + " at position " + ptr + " in data file " + this.getDataFile(), e);
        }
    }
}

