/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.axiondb.AxionException;
import org.axiondb.Row;
import org.axiondb.RowIterator;
import org.axiondb.engine.rowiterators.BaseRowIterator;

public class ChainedRowIterator
extends BaseRowIterator
implements RowIterator {
    private int _currentIndex = -1;
    private int _currentIterator = 0;
    private Row _currentRow;
    private boolean _currentRowSet = false;
    private ArrayList _iterators = new ArrayList(4);
    private int _nextIndex = 0;

    public void add(Row row) throws AxionException {
        this.getCurrentRowIterator().add(row);
    }

    public void addRowIterator(RowIterator iter) {
        this._iterators.add(iter);
    }

    public Row current() {
        if (this._currentRowSet) {
            return this._currentRow;
        }
        throw new NoSuchElementException("No current row.");
    }

    public int currentIndex() {
        return this._currentIndex;
    }

    public boolean hasCurrent() {
        return this._currentRowSet;
    }

    public boolean hasNext() {
        int I = this._iterators.size();
        for (int i = this._currentIterator; i < I; ++i) {
            RowIterator iter = (RowIterator)this._iterators.get(i);
            if (!iter.hasNext()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPrevious() {
        for (int i = this._currentIterator; i >= 0; --i) {
            RowIterator iter = (RowIterator)this._iterators.get(i);
            if (!iter.hasPrevious()) continue;
            return true;
        }
        return false;
    }

    public Row last() throws AxionException {
        this._currentIndex = -1;
        this._nextIndex = 0;
        int I = this._iterators.size();
        for (int i = 0; i < I; ++i) {
            RowIterator iter = (RowIterator)this._iterators.get(i);
            if (iter.isEmpty()) continue;
            this._currentRow = iter.last();
            this._nextIndex += iter.nextIndex();
            this._currentRowSet = true;
        }
        this._currentIndex = this._nextIndex - 1;
        return this._currentRow;
    }

    public Row next() throws AxionException {
        while (this._currentIterator < this._iterators.size()) {
            RowIterator iter = this.getCurrentRowIterator();
            if (iter.hasNext()) {
                this._currentRow = iter.next();
                this._currentRowSet = true;
                this._currentIndex = this._nextIndex++;
                return this._currentRow;
            }
            ++this._currentIterator;
        }
        throw new NoSuchElementException("No next row.");
    }

    public int next(int count) throws AxionException {
        int lastId = -1;
        for (int i = 0; i < count; ++i) {
            int iterSize = this._iterators.size();
            while (this._currentIterator < iterSize) {
                RowIterator iter = this.getCurrentRowIterator();
                if (iter.hasNext()) {
                    lastId = iter.next(1);
                    ++this._nextIndex;
                    this._currentIndex = this._currentIndex;
                    break;
                }
                ++this._currentIterator;
            }
            if (this._currentIterator != iterSize) continue;
            --this._currentIterator;
            throw new NoSuchElementException("No next row.");
        }
        this._currentRow = null;
        this._currentRowSet = false;
        return lastId;
    }

    public int nextIndex() {
        return this._nextIndex;
    }

    public Row previous() throws AxionException {
        while (this._currentIterator >= 0) {
            RowIterator iter = this.getCurrentRowIterator();
            if (iter.hasPrevious()) {
                this._currentRow = iter.previous();
                this._currentRowSet = true;
                --this._nextIndex;
                this._currentIndex = this._nextIndex;
                return this._currentRow;
            }
            --this._currentIterator;
        }
        throw new NoSuchElementException("No previous row.");
    }

    public int previous(int count) throws AxionException {
        int lastId = -1;
        for (int i = 0; i < count; ++i) {
            while (this._currentIterator >= 0) {
                RowIterator iter = this.getCurrentRowIterator();
                if (iter.hasPrevious()) {
                    lastId = iter.previous(1);
                    this._currentIndex = --this._nextIndex;
                    break;
                }
                --this._currentIterator;
            }
            if (this._currentIterator != -1) continue;
            ++this._currentIterator;
            throw new NoSuchElementException("No previous row.");
        }
        this._currentRow = null;
        this._currentRowSet = false;
        return lastId;
    }

    public int previousIndex() {
        return this._nextIndex - 1;
    }

    public void remove() throws AxionException {
        if (!this.hasCurrent()) {
            throw new IllegalStateException("No current row.");
        }
        this.getCurrentRowIterator().remove();
        --this._nextIndex;
        this._currentRow = null;
        this._currentRowSet = false;
        this._currentIndex = -1;
    }

    public void reset() throws AxionException {
        int I = this._iterators.size();
        for (int i = 0; i < I; ++i) {
            ((RowIterator)this._iterators.get(i)).reset();
        }
        this._currentIndex = -1;
        this._nextIndex = 0;
        this._currentRowSet = false;
        this._currentRow = null;
        this._currentIterator = 0;
    }

    public void set(Row row) throws AxionException {
        if (!this.hasCurrent()) {
            throw new IllegalStateException("No current row.");
        }
        this.getCurrentRowIterator().set(row);
        this._currentRow = row;
    }

    public int size() throws AxionException {
        int size = 0;
        int I = this._iterators.size();
        for (int i = 0; i < I; ++i) {
            size += ((RowIterator)this._iterators.get(i)).size();
        }
        return size;
    }

    public String toString() {
        return "Chained(" + this._iterators + ")";
    }

    private RowIterator getCurrentRowIterator() {
        return (RowIterator)this._iterators.get(this._currentIterator);
    }
}

