/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.constraints;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.SelectableBasedConstraint;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.constraints.BaseConstraint;
import org.axiondb.engine.visitors.ResolveSelectableVisitor;
import org.axiondb.event.RowEvent;

public abstract class BaseSelectableBasedConstraint
extends BaseConstraint
implements SelectableBasedConstraint {
    private List _selectables = new ArrayList(2);
    private boolean _resolved = false;
    private static final long serialVersionUID = 3237990466073483444L;

    public BaseSelectableBasedConstraint(String name, String type) {
        super(name, type);
    }

    public abstract boolean evaluate(RowEvent var1) throws AxionException;

    public abstract boolean evaluate(RowEvent var1, RowDecorator var2) throws AxionException;

    public abstract boolean evaluate(RowIterator var1, RowIterator var2, Table var3) throws AxionException;

    public void addSelectable(Selectable sel) {
        if (this._resolved) {
            throw new IllegalStateException("Can't add selectables after resolve");
        }
        this._selectables.add(sel);
    }

    public final int getSelectableCount() {
        return this._selectables.size();
    }

    public final Selectable getSelectable(int i) {
        return (Selectable)this._selectables.get(i);
    }

    public final List getSelectableList() {
        return this._selectables;
    }

    public final Iterator getSelectables() {
        return this.getSelectableList().iterator();
    }

    public void resolve(Database db, TableIdentifier table) throws AxionException {
        if (!this._resolved) {
            TableIdentifier[] tables = this.toArray(table);
            ResolveSelectableVisitor resolveSel = new ResolveSelectableVisitor(db);
            int I = this._selectables.size();
            for (int i = 0; i < I; ++i) {
                this._selectables.set(i, resolveSel.visit((Selectable)this._selectables.get(i), null, tables));
            }
            this._resolved = true;
        }
    }
}

