/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.internal.snmp;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpAccessControlModel;
import com.sun.management.internal.snmp.SnmpModelImpl;
import com.sun.management.internal.snmp.SnmpSubSystem;
import com.sun.management.snmp.InetAddressAcl;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.UserAcl;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SnmpJdmkAcm
extends SnmpModelImpl
implements SnmpAccessControlModel {
    private InetAddressAcl ipacl = null;
    private boolean activatev3 = true;
    private boolean v1v2setrequest = false;
    private UserAcl useracl = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpJdmkAcm");
    String dbgTag = "SnmpJdmkAcm";

    public SnmpJdmkAcm(SnmpSubSystem snmpSubSystem, InetAddressAcl inetAddressAcl, UserAcl userAcl, boolean bl) {
        super(snmpSubSystem, "User based");
        this.ipacl = inetAddressAcl;
        this.useracl = userAcl;
        snmpSubSystem.addModel(0, this);
        snmpSubSystem.addModel(1, this);
        this.activatev3 = bl;
        if (bl) {
            snmpSubSystem.addModel(3, this);
        }
    }

    private boolean isV3Activated() {
        return this.activatev3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPduAccess(int n, String string, int n2, int n3, int n4, byte[] byArray, SnmpPdu snmpPdu) throws SnmpStatusException {
        if (logger.finerOn()) {
            logger.finer("checkPduAccess", "sender is " + string + " with " + new String(byArray));
        }
        if (byArray == null) {
            throw new SnmpStatusException(16);
        }
        switch (n) {
            case 0: 
            case 1: {
                if (this.isV3Activated()) {
                    if (n3 == 163) {
                        SnmpJdmkAcm snmpJdmkAcm = this;
                        synchronized (snmpJdmkAcm) {
                            if (!this.isSnmpV1V2SetRequestAuthorized()) {
                                if (logger.finerOn()) {
                                    logger.finer("checkPduAccess", "sender is " + string + " with " + new String(byArray) + " \n SNMP V1 and V2 set requests disable. Access not granted.");
                                }
                                throw new SnmpStatusException(16);
                            }
                        }
                    }
                    this.checkIPAcl(byArray, string, n3);
                    break;
                }
                this.checkIPAcl(byArray, string, n3);
                break;
            }
            case 3: {
                this.checkUserAcl(byArray, string, n3, n2);
                break;
            }
            default: {
                if (logger.finestOn()) {
                    logger.finest("checkPduAccess", "Unsupported protocol version.");
                }
                throw new SnmpStatusException(4);
            }
        }
    }

    public void checkAccess(int n, String string, int n2, int n3, int n4, byte[] byArray, SnmpOid snmpOid) throws SnmpStatusException {
    }

    private void checkIPAcl(byte[] byArray, String string, int n) throws SnmpStatusException {
        String string2 = new String(byArray);
        if (logger.finerOn()) {
            logger.finer("checkIPAcl", "sender is " + string + " with " + string2);
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            if (logger.finerOn()) {
                logger.finer("checkIPAcl", "sender is " + inetAddress + " with " + string2);
                logger.finer("checkIPAcl", "Bad IP address");
            }
            throw new SnmpStatusException(4);
        }
        if (this.ipacl != null) {
            if (n == 163) {
                if (!this.ipacl.checkWritePermission(inetAddress, string2)) {
                    if (logger.finerOn()) {
                        logger.finer("checkIPAcl", "sender is " + inetAddress + " with " + string2);
                        logger.finer("checkIPAcl", "sender has no write permission");
                    }
                    throw new SnmpStatusException(4);
                }
                if (logger.finerOn()) {
                    logger.finer("checkIPAcl", "sender is " + inetAddress + " with " + string2);
                    logger.finer("checkIPAcl", "sender has write permission");
                }
            } else {
                if (!this.ipacl.checkReadPermission(inetAddress, string2)) {
                    if (logger.finerOn()) {
                        logger.finer("checkIPAcl", "sender is " + inetAddress + " with " + string2);
                        logger.finer("checkIPAcl", "sender has no read permission");
                    }
                    throw new SnmpStatusException(2);
                }
                if (logger.finerOn()) {
                    logger.finer("checkIPAcl", "sender is " + inetAddress + " with " + string2);
                    logger.finer("checkIPAcl", "sender has read permission");
                }
            }
        }
    }

    private void checkUserAcl(byte[] byArray, String string, int n, int n2) throws SnmpStatusException {
        String string2 = null;
        if (byArray.length != 0) {
            string2 = new String(byArray);
        } else {
            if (logger.finerOn()) {
                logger.finer("checkUserAcl", "Received a null context");
            }
            string2 = "null";
        }
        if (logger.finerOn()) {
            logger.finer("checkUserAcl", "sender is " + string + " with [" + string2 + "], security level : " + n2);
        }
        if (this.useracl != null) {
            if (n == 163) {
                if (!this.useracl.checkWritePermission(string, string2, n2)) {
                    if (logger.finerOn()) {
                        logger.finer("checkUserAcl", "sender is " + string + " with " + string2);
                        logger.finer("checkUserAcl", "sender has no write permission");
                    }
                    throw new SnmpStatusException(16);
                }
                if (logger.finerOn()) {
                    logger.finer("checkUserAcl", "sender is " + string + " with " + string2);
                    logger.finer("checkUserAcl", "sender has write permission");
                }
            } else {
                if (!this.useracl.checkReadPermission(string, string2, n2)) {
                    if (logger.finerOn()) {
                        logger.finer("checkUserAcl", "sender is " + string + " with " + string2);
                        logger.finer("checkUserAcl", "sender has no read permission");
                    }
                    throw new SnmpStatusException(16);
                }
                if (logger.finerOn()) {
                    logger.finer("checkUserAcl", "sender is " + string + " with " + string2);
                    logger.finer("checkUserAcl", "sender has read permission");
                }
            }
        }
    }

    public synchronized boolean enableSnmpV1V2SetRequest() {
        this.v1v2setrequest = true;
        return true;
    }

    public synchronized boolean disableSnmpV1V2SetRequest() {
        this.v1v2setrequest = false;
        return true;
    }

    public synchronized boolean isSnmpV1V2SetRequestAuthorized() {
        return this.v1v2setrequest;
    }
}

