/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.CommunicationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class TimedURLConnection {
    private static final int MAKE_URLCONNECTION_OPS = 1;
    private static final int GET_OUTPUTSTREAM_OPS = 2;
    private static final int GET_INPUTSTREAM_OPS = 3;
    private static final int GET_RESPONSECODE_OPS = 4;
    private static final int GET_ERRORSTREAM_OPS = 5;
    private static final String urlConnTimeoutString = new String("operation timed out for URLConnection");
    private long timeOut;
    private URLConnection urlConn = null;
    private final String dbgTag = "TimedURLConnection";

    public TimedURLConnection(URL uRL, long l) throws IOException, SecurityException {
        if (this.isTraceOn()) {
            this.trace("TimedURLConnection", "new TimedURLConnection with timeout: " + l);
        }
        this.timeOut = l;
        this.urlConn = this.make(uRL);
    }

    public URLConnection getURLConnection() {
        return this.urlConn;
    }

    private Object runTimeoutOperation(TimeoutOperation timeoutOperation, long l) throws IOException {
        long l2 = 0L;
        long l3 = 0L;
        boolean bl = false;
        Object object = null;
        if (l <= 0L) {
            if (this.isDebugOn()) {
                this.debug("runTimeoutOperation", "bad timeout");
            }
            throw new CommunicationException("bad balue for timeout");
        }
        l2 = System.currentTimeMillis() + l;
        timeoutOperation.start();
        l3 = System.currentTimeMillis();
        while (l3 < l2) {
            if (timeoutOperation.isAlive()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                    if (timeoutOperation.gotResult()) {
                        break;
                    }
                }
                catch (Exception exception) {
                    if (this.isDebugOn()) {
                        this.debug("runTimeoutOperation", "got Exception while sleeping");
                    }
                    throw new CommunicationException("run runTimeoutOperation, sleep failed");
                }
                l3 = System.currentTimeMillis();
                continue;
            }
            bl = true;
            break;
        }
        if (timeoutOperation.gotResult()) {
            object = timeoutOperation.getReturnObject();
        } else if (!bl) {
            if (this.isDebugOn()) {
                this.debug("runTimeoutOperation", "openConnection timed out");
            }
            timeoutOperation.setTimeoutOccurred(true);
            timeoutOperation.interrupt();
            throw new CommunicationException(urlConnTimeoutString);
        }
        return object;
    }

    public OutputStream getOutputStream() throws IOException {
        OutputStream outputStream = null;
        if (this.isDebugOn()) {
            this.debug("getOutputStream", "Entering");
        }
        if (this.urlConn == null) {
            if (this.isDebugOn()) {
                this.debug("getOutputThread", "urlConn null !");
            }
            throw new CommunicationException("Failed to get inputStream, no connection");
        }
        TimeoutOperation timeoutOperation = new TimeoutOperation(2, this.urlConn);
        outputStream = (OutputStream)this.runTimeoutOperation(timeoutOperation, this.timeOut);
        if (this.isDebugOn()) {
            this.debug("getOutputStream", "returning" + outputStream);
        }
        return outputStream;
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream = null;
        if (this.isDebugOn()) {
            this.debug("getInputStream", "Entering");
        }
        if (this.urlConn == null) {
            if (this.isDebugOn()) {
                this.debug("getInputThread", "urlConn null !");
            }
            throw new CommunicationException("Failed to get inputStream, no connection");
        }
        TimeoutOperation timeoutOperation = new TimeoutOperation(3, this.urlConn);
        inputStream = (InputStream)this.runTimeoutOperation(timeoutOperation, this.timeOut);
        if (this.isDebugOn()) {
            this.debug("getInputStream", "returning: " + inputStream);
        }
        return inputStream;
    }

    public int getResponseCode() throws IOException {
        Integer n = null;
        if (this.isDebugOn()) {
            this.debug("getResponseCode", "Entering");
        }
        if (this.urlConn == null) {
            if (this.isDebugOn()) {
                this.debug("getResponseCodeThread", "urlConn null !");
            }
            throw new CommunicationException("Failed to get RespondCode, no connection");
        }
        TimeoutOperation timeoutOperation = new TimeoutOperation(4, this.urlConn);
        n = (Integer)this.runTimeoutOperation(timeoutOperation, this.timeOut);
        if (this.isDebugOn()) {
            this.debug("getResponseCodeThread", "returning: " + n);
        }
        return n;
    }

    public InputStream getErrorStream() throws IOException {
        InputStream inputStream = null;
        if (this.isDebugOn()) {
            this.debug("getErrorStream", "Entering");
        }
        if (this.urlConn == null) {
            if (this.isDebugOn()) {
                this.debug("getErrorThread", "urlConn null !");
            }
            throw new CommunicationException("Failed to get errorStream, no connection");
        }
        TimeoutOperation timeoutOperation = new TimeoutOperation(5, this.urlConn);
        inputStream = (InputStream)this.runTimeoutOperation(timeoutOperation, this.timeOut);
        if (this.isDebugOn()) {
            this.debug("getErrorStream", "returning: " + inputStream);
        }
        return inputStream;
    }

    private URLConnection make(URL uRL) throws IOException {
        URLConnection uRLConnection = null;
        if (this.isDebugOn()) {
            this.debug("make", "Entering");
        }
        TimeoutOperation timeoutOperation = new TimeoutOperation(1, uRL);
        uRLConnection = (URLConnection)this.runTimeoutOperation(timeoutOperation, this.timeOut);
        if (this.isDebugOn()) {
            this.debug("make", "returning: " + uRLConnection);
        }
        return uRLConnection;
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 8);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 8, string, string2, string3);
    }

    private void trace(String string, String string2) {
        this.trace("TimedURLConnection", string, string2);
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 8);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 8, string, string2, string3);
    }

    private void debug(String string, String string2) {
        this.debug("TimedURLConnection", string, string2);
    }

    private class TimeoutOperation
    extends Thread {
        private int currentOperartion;
        private Object returnObject = null;
        private boolean gotResult = false;
        private URL url = null;
        private URLConnection tmpUrlConn = null;
        private boolean resultGiven = false;
        private boolean timeoutOccurred = false;

        public TimeoutOperation(int n, URL uRL) {
            this.currentOperartion = n;
            this.url = uRL;
        }

        public TimeoutOperation(int n, URLConnection uRLConnection) {
            this.currentOperartion = n;
            this.tmpUrlConn = uRLConnection;
        }

        public void run() {
            switch (this.currentOperartion) {
                case 1: {
                    this.gotResult = false;
                    if (this.url == null) break;
                    try {
                        this.returnObject = this.url.openConnection();
                        this.gotResult = true;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        this.checkTimeout(interruptedIOException, "creating URLConnection", "MAKE_URLCONNECTION_OPS");
                    }
                    catch (Exception exception) {
                        if (!TimedURLConnection.this.isDebugOn()) break;
                        TimedURLConnection.this.debug("TimeoutOperation", "run", "MAKE_URLCONNECTION_OPS, got Exception");
                        exception.printStackTrace();
                    }
                    break;
                }
                case 3: {
                    this.gotResult = false;
                    if (TimedURLConnection.this.urlConn == null) break;
                    try {
                        this.returnObject = TimedURLConnection.this.urlConn.getInputStream();
                        this.gotResult = true;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        this.checkTimeout(interruptedIOException, "getting InputStream of an URLConnection", "GET_INPUTSTREAM_OPS");
                    }
                    catch (Exception exception) {
                        if (!TimedURLConnection.this.isDebugOn()) break;
                        TimedURLConnection.this.debug("TimeoutOperation", "run", "GET_INPUTSTREAM_OPS, got Exception");
                        exception.printStackTrace();
                    }
                    break;
                }
                case 2: {
                    this.gotResult = false;
                    if (TimedURLConnection.this.urlConn == null) break;
                    try {
                        this.returnObject = TimedURLConnection.this.urlConn.getOutputStream();
                        this.gotResult = true;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        this.checkTimeout(interruptedIOException, "getting OutputStream of an URLConnection", "GET_OUTPUTSTREAM_OPS");
                    }
                    catch (Exception exception) {
                        if (!TimedURLConnection.this.isDebugOn()) break;
                        TimedURLConnection.this.debug("TimeoutOperation", "run", "GET_OUTPUTSTREAM_OPS, got Exception");
                        exception.printStackTrace();
                    }
                    break;
                }
                case 4: {
                    this.gotResult = false;
                    if (TimedURLConnection.this.urlConn == null) break;
                    try {
                        int n = 0;
                        n = ((HttpURLConnection)TimedURLConnection.this.urlConn).getResponseCode();
                        this.returnObject = new Integer(n);
                        this.gotResult = true;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        this.checkTimeout(interruptedIOException, "getting RespondCode of an Http", "GET_RESPONSECODE_OPS");
                    }
                    catch (IOException iOException) {
                        this.returnObject = new Integer(-1);
                        this.gotResult = true;
                        if (!TimedURLConnection.this.isDebugOn()) break;
                        TimedURLConnection.this.debug("TimeoutOperation", "run", "GET_RESPONSECODE_OPS, got IOException, setting dummy response code");
                        iOException.printStackTrace();
                    }
                    catch (Exception exception) {
                        if (!TimedURLConnection.this.isDebugOn()) break;
                        TimedURLConnection.this.debug("TimeoutOperation", "run", "GET_RESPONSECODE_OPS, got Exception");
                        exception.printStackTrace();
                    }
                    break;
                }
                case 5: {
                    this.gotResult = false;
                    if (TimedURLConnection.this.urlConn == null) break;
                    try {
                        this.returnObject = ((HttpURLConnection)TimedURLConnection.this.urlConn).getErrorStream();
                        this.gotResult = true;
                    }
                    catch (Exception exception) {
                        if (!TimedURLConnection.this.isDebugOn()) break;
                        TimedURLConnection.this.debug("TimeoutOperation", "run", "GET_ERRORSTREAM_OPS, got Exception");
                        exception.printStackTrace();
                    }
                    break;
                }
            }
            while (!this.resultGiven) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    if (TimedURLConnection.this.isDebugOn()) {
                        TimedURLConnection.this.debug("TimeoutOperation", "run", "got Exception while sleeping");
                    }
                    throw new CommunicationException("run TimeoutOperation, sleep failed");
                }
            }
        }

        public boolean gotResult() {
            return this.gotResult;
        }

        public Object getReturnObject() {
            this.resultGiven = true;
            return this.returnObject;
        }

        public boolean hasTimeoutOccurred() {
            return this.timeoutOccurred;
        }

        public void setTimeoutOccurred(boolean bl) {
            this.timeoutOccurred = bl;
        }

        private void checkTimeout(Exception exception, String string, String string2) {
            if (this.hasTimeoutOccurred()) {
                TimedURLConnection.this.trace("TimeoutOperation", "run", "Timeout while " + string);
                this.setTimeoutOccurred(false);
            }
            if (TimedURLConnection.this.isDebugOn()) {
                TimedURLConnection.this.debug("TimeoutOperation", "run", string2 + ", got Exception");
                exception.printStackTrace();
            }
        }
    }
}

