#ifdef I18N

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xlocale.h>
#include <X11/Xutil.h>
#include <config.h>
#include FORMS_H_LOCATION
#include "debug.h"
#include <string.h>
#include "LString.h"
#include "lyxcodeconv.h"

LyXCodeConv codeconverter;     //global

size_t LyXCodeConv::lyxmbstowcs(wchar_t *wcs, const char *cs, size_t n)
{
#ifndef NOGLIBC
    size_t len = mbstowcs(wcs,cs, n);
    if (len < 0)
    {
        lyxerr << "LyXCodeConv::lyxmbstowcs Cannot convert mbs to wcs "
	       << cs << endl;
        wcs[0]='\0';
        return 0;
    }

    return len;

#else
    XTextProperty textprop;
    wchar_t **wlist;
    int count;
    char *ptr;
    
    ptr = new char [n+1];
    strcpy(ptr,cs);
        
    if (XmbTextListToTextProperty(fl_display, &ptr, 1, XTextStyle, &textprop)
	!= Success) {
        lyxerr << "LyXCodeConv:Cannot convert TextList to TextProperty "
	       << ptr << endl;
	return (0);
    }
    if (XwcTextPropertyToTextList(fl_display, &textprop, &wlist, &count)
	!= Success) {
        lyxerr << "LyXCodeConv:Cannot convert TextProperty to TextList"
               << ptr << endl;
	return (0);
    }
    delete [] ptr;
    int i;
    for ( i= 0 ; wlist[0][i] != 0;i++)
        wcs[i]=list[0][i] ;
    return i;
    
#endif
}

size_t  LyXCodeConv::lyxmbstowcs(wchar_t *wcs, string const *cs)
{
    size_t len = mbstowcs(wcs,cs->c_str(), cs->length());
    if (len < 0)
    {
        lyxerr << "LyXCodeConv::lyxmbstowcs Cannot convert mbs to wcs "
               << cs->c_str() << endl;
        wcs[0]='\0';
        return 0;
    }

    return len;
//    return lyxmbstowcs(wcs,cs->c_str(),cs->length());
        
}

int LyXCodeConv::lyxwclen(wchar_t const * wcs)
{
    int len=0;
    if (wcs == 0) return 0;
    while(*wcs++ != (wchar_t)0) len++;
    return len;
}
size_t  LyXCodeConv::lyxwcstombs(char *cs, const wchar_t *wcs, size_t n)
{
#ifndef NOGLIBC
    size_t len = wcstombs(cs,wcs,n);
    if (0 > len){
        lyxerr << "LyXCodeConv::lyxwcstombs Cannot convert mbs to wcs"
	       << cs << endl;
        cs[0] = '\0';
        return 0;
    }
    return len;

#else   // wrong
    XTextProperty textprop;
    char **list;
    int count;

    int len = lyxwclen(wcs);
    
    wchar_t *ptr = new wchar_t [len+1];
    for (int i=0; i < len;i++)
        ptr[i]=wcs[i];
    
    ptr[len] = '\0';
    if (XwcTextListToTextProperty(fl_display,&ptr,1, XTextStyle, &textprop)
          != Success) {
        lyxerr << "LyXCodeConv:Cannot convert TextList to TextProperty" << endl;
        return (0);
    }
    if (XmbTextPropertyToTextList(fl_display, &textprop, &list, &count)//wrong?
          != Success) {
        lyxerr << "LyXCodeConv:Cannot convert TextProperty to TextList" << endl;
        return (0);
    }
    int len = strlen(list[0]);
    for (int i=0;i<len;i++)
        cs[i]=list[0][i];
    
    return len;
#endif
}


size_t LyXCodeConv::lyxwctomb(char *cs, wchar_t wc)
{
    int len = wctomb(cs,wc);
    if (len < 0){
        lyxerr <<  "LyXCodeConv::lyxwctomb Cannot convert wc to mbs" << endl;
        return 0;
    }
    return len;
}

void LyXCodeConv::lyxprintf(FILE *file, wchar_t wc)
{
    char cs[3];
    int len = lyxwctomb(cs,wc);
    cs[len]= '\0';
    fprintf(file, "%s", cs);
}

void LyXCodeConv::lyxos(ostream & os, wchar_t wc)
{
    char cs[3];
    int len = lyxwctomb(cs,wc);
    cs[len]= '\0';
    os << cs;
}

void LyXCodeConv::lyxofs(ofstream & ofs, wchar_t wc)
{
    char cs[3];
    int len = lyxwctomb(cs,wc);
    cs[len]= '\0';
    ofs << cs;
}
#endif
