/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jserv;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import org.apache.java.lang.Semaphore;
import org.apache.java.lang.Stoppable;
import org.apache.jserv.Ajpv12InputStream;
import org.apache.jserv.JServ;
import org.apache.jserv.JServConnection;
import org.apache.jserv.JServContext;
import org.apache.jserv.JServLogChannels;
import org.apache.jserv.JServSendError;
import org.apache.jserv.JServServletManager;
import org.apache.jserv.JServSession;
import org.apache.jserv.JServUtils;

public class JServConnection
implements Stoppable,
HttpServletRequest,
HttpServletResponse,
JServSendError,
JServLogChannels {
    protected Socket client;
    protected Ajpv12InputStream in;
    protected OutputStream out;
    protected JServServletManager mgr;
    protected JServContext context;
    protected Servlet servlet;
    protected String servletmethod;
    protected String servletname;
    protected String servletzone;
    protected String hostname;
    protected boolean stm_servlet;
    protected String auth = null;
    protected int signal = -1;
    protected JServInputStream servlet_in;
    protected JServOutputStream servlet_out;
    protected BufferedReader servlet_reader;
    protected boolean called_getInput = false;
    protected PrintWriter servlet_writer;
    protected boolean called_getOutput = false;
    protected Hashtable headers_in = new Hashtable(10, 0.9f);
    protected Hashtable headers_out = new Hashtable(15, 0.9f);
    protected Hashtable env_vars;
    protected Cookie[] cookies_in;
    protected Vector cookies_out;
    protected int status;
    protected String status_string;
    protected Hashtable params;
    protected boolean got_input;
    protected boolean sent_header;
    protected JServSession session;
    protected String requestedSessionId;
    protected boolean idCameAsCookie;
    protected boolean idCameAsUrl;
    private Semaphore semaphore;

    public void init(Socket socket, Semaphore semaphore) {
        block4: {
            this.client = socket;
            this.semaphore = semaphore;
            try {
                this.in = new Ajpv12InputStream(this.client.getInputStream(), 2048);
                this.out = new BufferedOutputStream(this.client.getOutputStream(), 2048);
            }
            catch (IOException iOException) {
                try {
                    this.client.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                if (!JServ.log.active) break block4;
                JServ.log.log("jservException", "Exception while getting socket streams: " + iOException);
            }
        }
    }

    public void run() {
        block4: {
            try {
                this.semaphore.entry();
                this.signal = -1;
                try {
                    this.readData();
                }
                catch (Exception exception) {
                    this.sendError(400, "Malformed data sent to JServ");
                    Object var2_2 = null;
                    this.semaphore.exit();
                    return;
                }
                if (this.signal != -1) break block4;
                this.processRequest();
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.semaphore.exit();
                throw throwable;
            }
        }
        Object var2_3 = null;
        this.semaphore.exit();
    }

    protected void processRequest() {
        this.env_vars.put("GATEWAY_INTERFACE", "ApacheJServ/1.1.2");
        if (this.servletzone == null) {
            this.servletzone = (String)JServ.servletManagerTable.keys().nextElement();
        }
        if (this.servletname == null) {
            this.sendError(400, "Received empty servlet name");
            return;
        }
        if (this.hostname == null) {
            this.sendError(400, "Received empty host name");
            return;
        }
        this.mgr = (JServServletManager)JServ.servletManagerTable.get(this.servletzone);
        if (this.mgr == null) {
            this.sendError(404, "Servlet zone \"" + this.servletzone + "\" not found.");
            return;
        }
        this.cookies_in = JServUtils.parseCookieHeader(this.getHeader("Cookie"));
        this.requestedSessionId = this.mgr.getUrlSessionId(this.getQueryString());
        this.idCameAsUrl = this.requestedSessionId != null;
        String string = this.mgr.getCookieSessionId(this.cookies_in);
        this.idCameAsCookie = string != null;
        String string2 = this.requestedSessionId = this.requestedSessionId == null ? string : this.requestedSessionId;
        if (this.requestedSessionId != null) {
            JServSession jServSession = (JServSession)this.mgr.getSession(this.requestedSessionId);
            if (this.requestedSessionId != null && jServSession != null) {
                jServSession.access();
            }
        }
        try {
            this.mgr.checkReload(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.sendError(illegalArgumentException);
            return;
        }
        catch (Exception exception) {
            this.sendError(exception);
            return;
        }
        try {
            this.context = this.mgr.loadServlet(this.servletname, this);
        }
        catch (ServletException servletException) {
            this.sendError(500, "Initialization error while loading the servlet: " + servletException.getMessage());
        }
        if (this.context == null || this.context.servlet == null) {
            this.sendError(500, "An unknown error occured loading the servlet.");
            return;
        }
        this.servlet = this.context.servlet;
        boolean bl = this.servlet instanceof SingleThreadModel;
        try {
            this.context.lock.readLock();
        }
        catch (InterruptedException interruptedException) {
            this.sendError(500, "InterruptedException while waiting for servlet lock.");
            if (bl) {
                this.mgr.returnSTMS(this.servletname, this.context);
            }
            return;
        }
        try {
            JServConnection jServConnection = this;
            if (jServConnection == null) {
                throw null;
            }
            this.servlet_in = jServConnection.new JServInputStream(this.getContentLength(), this.in);
            JServConnection jServConnection2 = this;
            if (jServConnection2 == null) {
                throw null;
            }
            this.servlet_out = jServConnection2.new JServOutputStream(this.out, this.in);
            try {
                this.servlet.service((ServletRequest)this, (ServletResponse)this);
            }
            catch (Exception exception) {
                this.sendError(exception);
                Object var4_12 = null;
                this.context.lock.readUnlock();
                if (bl) {
                    this.mgr.returnSTMS(this.servletname, this.context);
                }
                return;
            }
            catch (Error error) {
                this.sendError(error);
                throw (Error)error.fillInStackTrace();
            }
            this.sendHttpHeaders();
            try {
                if (this.servlet_writer != null) {
                    this.servlet_writer.close();
                }
                this.servlet_out.close();
                if (this.client != null) {
                    this.client.close();
                }
            }
            catch (IOException iOException) {
            }
            Object var4_13 = null;
            this.context.lock.readUnlock();
            if (bl) {
                this.mgr.returnSTMS(this.servletname, this.context);
            }
        }
        catch (Throwable throwable) {
            Object var4_14 = null;
            this.context.lock.readUnlock();
            if (bl) {
                this.mgr.returnSTMS(this.servletname, this.context);
            }
            throw throwable;
        }
    }

    public void stop() {
    }

    protected void readData() throws Exception {
        String string = null;
        String string2 = null;
        try {
            block15: while (true) {
                int n = this.in.read();
                switch (n) {
                    case 0: {
                        continue block15;
                    }
                    case 1: {
                        this.servletmethod = this.in.readString(null);
                        this.servletzone = this.in.readString(null);
                        this.servletname = this.in.readString(null);
                        this.hostname = this.in.readString(null);
                        this.env_vars.put("DOCUMENT_ROOT", this.in.readString(""));
                        this.env_vars.put("PATH_INFO", this.in.readString(null));
                        this.env_vars.put("PATH_TRANSLATED", this.in.readString(null));
                        this.env_vars.put("QUERY_STRING", this.in.readString(null));
                        this.env_vars.put("REMOTE_ADDR", this.in.readString(""));
                        this.env_vars.put("REMOTE_HOST", this.in.readString(""));
                        this.env_vars.put("REMOTE_USER", this.in.readString(null));
                        this.env_vars.put("AUTH_TYPE", this.in.readString(null));
                        this.env_vars.put("REMOTE_PORT", this.in.readString(""));
                        this.env_vars.put("REQUEST_METHOD", this.in.readString("GET"));
                        this.env_vars.put("REQUEST_URI", this.in.readString(""));
                        this.env_vars.put("SCRIPT_FILENAME", this.in.readString(""));
                        this.env_vars.put("SCRIPT_NAME", this.in.readString(""));
                        this.env_vars.put("SERVER_NAME", this.in.readString(""));
                        this.env_vars.put("SERVER_PORT", this.in.readString(""));
                        this.env_vars.put("SERVER_PROTOCOL", this.in.readString(""));
                        this.env_vars.put("SERVER_SIGNATURE", this.in.readString(""));
                        this.env_vars.put("SERVER_SOFTWARE", this.in.readString(""));
                        this.env_vars.put("JSERV_ROUTE", this.in.readString(""));
                        this.in.readString("");
                        this.in.readString("");
                        continue block15;
                    }
                    case 3: {
                        string = this.in.readString(null);
                        string2 = this.in.readString("");
                        this.headers_in.put(string.toLowerCase(), string2);
                        continue block15;
                    }
                    case 5: {
                        string = this.in.readString(null);
                        string2 = this.in.readString("");
                        this.env_vars.put(string, string2);
                        continue block15;
                    }
                    case 254: {
                        this.signal = this.in.read();
                        if (this.signal == 0) {
                            try {
                                this.client.getOutputStream().write(0);
                                this.client.close();
                            }
                            catch (IOException iOException) {}
                        } else {
                            try {
                                this.client.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (this.signal == 1) {
                                JServ.restart();
                            } else if (this.signal == 15) {
                                JServ.terminate();
                            }
                        }
                        return;
                    }
                    case 4: 
                    case 255: {
                        return;
                    }
                    case -1: {
                        throw new IOException("Stream closed prematurely");
                    }
                }
                break;
            }
            throw new IOException("Stream broken");
        }
        catch (Exception exception) {
            if (JServ.log.active) {
                JServ.log.log("jservException", "AJP Protocol Error: " + exception);
            }
            throw exception;
        }
    }

    protected void sendHttpHeaders() {
        String string;
        String string2;
        Enumeration<Object> enumeration;
        if (this.sent_header) {
            return;
        }
        this.sent_header = true;
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(this.out, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            printWriter = new PrintWriter(this.out);
        }
        if (this.status_string == null) {
            this.status_string = JServConnection.findStatusString(this.status);
        }
        String string3 = "Status: " + this.status + " " + this.status_string;
        printWriter.print(string3 + "\r\n");
        if (this.headers_out != null) {
            enumeration = this.headers_out.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                string = string2 + ": " + this.headers_out.get(string2);
                printWriter.print(string + "\r\n");
            }
        }
        enumeration = this.cookies_out.elements();
        while (enumeration.hasMoreElements()) {
            string2 = (Cookie)enumeration.nextElement();
            string = "Set-Cookie: " + JServUtils.encodeCookie((Cookie)string2);
            printWriter.print(string + "\r\n");
        }
        printWriter.print("\r\n");
        printWriter.flush();
    }

    public String getHostName() {
        return this.hostname;
    }

    public String getJServRoute() {
        return (String)this.env_vars.get("JSERV_ROUTE");
    }

    public int getContentLength() {
        String string = (String)this.headers_in.get("content-length");
        if (string == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public String getContentType() {
        return (String)this.headers_in.get("content-type");
    }

    public String getProtocol() {
        return (String)this.env_vars.get("SERVER_PROTOCOL");
    }

    public String getScheme() {
        if (this.getServerPort() == 443) {
            return "https";
        }
        return "http";
    }

    public String getServerName() {
        return (String)this.env_vars.get("SERVER_NAME");
    }

    public int getServerPort() {
        int n;
        String string = (String)this.env_vars.get("SERVER_PORT");
        if (string == null) {
            return -1;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n;
    }

    public String getRemoteAddr() {
        return (String)this.env_vars.get("REMOTE_ADDR");
    }

    public String getRemoteHost() {
        return (String)this.env_vars.get("REMOTE_HOST");
    }

    public String getRealPath(String string) {
        String string2 = (String)this.env_vars.get("DOCUMENT_ROOT");
        if (string2 == null) {
            return null;
        }
        return string2 + string;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.servlet_reader != null) {
            throw new IllegalStateException("getReader() has already been called.");
        }
        this.got_input = true;
        this.called_getInput = true;
        return this.servlet_in;
    }

    protected void parseParams() {
        ServletInputStream servletInputStream;
        if (this.params != null) {
            return;
        }
        Hashtable hashtable = null;
        try {
            hashtable = HttpUtils.parseQueryString((String)this.getQueryString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            hashtable = null;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            hashtable = null;
        }
        Hashtable hashtable2 = null;
        String string = this.getContentType();
        if ("POST".equals(this.getMethod()) && string != null && string.startsWith("application/x-www-form-urlencoded")) {
            try {
                servletInputStream = this.getInputStream();
                hashtable2 = HttpUtils.parsePostData((int)this.getContentLength(), (ServletInputStream)servletInputStream);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                hashtable2 = null;
            }
            catch (IOException iOException) {
                hashtable2 = null;
            }
        }
        if (hashtable == null && hashtable2 == null) {
            this.params = new Hashtable();
            return;
        }
        if (hashtable == null) {
            this.params = hashtable2;
            return;
        }
        if (hashtable2 == null) {
            this.params = hashtable;
            return;
        }
        servletInputStream = hashtable2.keys();
        while (servletInputStream.hasMoreElements()) {
            int n;
            String[] stringArray;
            String string2 = (String)servletInputStream.nextElement();
            Object v = hashtable2.get(string2);
            Object v2 = hashtable.get(string2);
            if (v2 == null) {
                hashtable.put(string2, v);
                continue;
            }
            Vector<Object> vector = new Vector<Object>();
            if (v2 instanceof String) {
                vector.addElement(v2);
            } else if (v2 instanceof String[]) {
                stringArray = (String[])v2;
                n = 0;
                while (n < stringArray.length) {
                    vector.addElement(stringArray[n]);
                    ++n;
                }
            }
            if (v instanceof String) {
                vector.addElement(v);
            } else if (v instanceof String[]) {
                stringArray = (String[])v;
                n = 0;
                while (n < stringArray.length) {
                    vector.addElement(stringArray[n]);
                    ++n;
                }
            }
            stringArray = new String[vector.size()];
            n = 0;
            while (n < stringArray.length) {
                stringArray[n] = (String)vector.elementAt(n);
                ++n;
            }
            hashtable.put(string2, stringArray);
        }
        this.params = hashtable;
    }

    public String getParameter(String string) {
        this.parseParams();
        Object v = this.params.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof String[]) {
            return ((String[])v)[0];
        }
        return (String)v;
    }

    public void setParameter(String string, String string2) {
        this.parseParams();
        if (this.params != null) {
            this.params.put(string, string2);
        }
    }

    public String[] getParameterValues(String string) {
        this.parseParams();
        Object v = this.params.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            String[] stringArray = new String[]{(String)v};
            return stringArray;
        }
        return (String[])v;
    }

    public Enumeration getParameterNames() {
        this.parseParams();
        return this.params.keys();
    }

    public Object getAttribute(String string) {
        if (!string.startsWith("org.apache.jserv.")) {
            return null;
        }
        if (string.equals("org.apache.jserv.attribute_names")) {
            return this.env_vars.keys();
        }
        return this.env_vars.get(string.substring("org.apache.jserv.".length()));
    }

    public BufferedReader getReader() throws IOException {
        if (this.called_getInput) {
            throw new IllegalStateException("Already called getInputStream");
        }
        if (this.servlet_reader == null) {
            String string = JServUtils.parseCharacterEncoding(this.getContentType());
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)((Object)this.servlet_in), string);
            this.servlet_reader = new BufferedReader(inputStreamReader);
            this.got_input = true;
        }
        return this.servlet_reader;
    }

    public Cookie[] getCookies() {
        return this.cookies_in;
    }

    public String getMethod() {
        return this.servletmethod;
    }

    public String getRequestURI() {
        String string = (String)this.env_vars.get("REQUEST_URI");
        if (string != null) {
            int n = string.indexOf(63);
            if (n >= 0) {
                return string.substring(0, n);
            }
            return string;
        }
        if (this.getPathInfo() != null) {
            return this.getServletPath() + this.getPathInfo();
        }
        return this.getServletPath();
    }

    public String getServletPath() {
        return (String)this.env_vars.get("SCRIPT_NAME");
    }

    public String getPathInfo() {
        return (String)this.env_vars.get("PATH_INFO");
    }

    public String getPathTranslated() {
        return (String)this.env_vars.get("PATH_TRANSLATED");
    }

    public String getQueryString() {
        return (String)this.env_vars.get("QUERY_STRING");
    }

    public String getRemoteUser() {
        return (String)this.env_vars.get("REMOTE_USER");
    }

    public String getAuthType() {
        return (String)this.env_vars.get("AUTH_TYPE");
    }

    public String getHeader(String string) {
        return (String)this.headers_in.get(string.toLowerCase());
    }

    public int getIntHeader(String string) {
        String string2 = (String)this.headers_in.get(string.toLowerCase());
        if (string2 == null) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    public long getDateHeader(String string) {
        String string2 = (String)this.headers_in.get(string.toLowerCase());
        if (string2 == null) {
            return -1L;
        }
        string2 = string2 + " ";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        try {
            Date date = simpleDateFormat.parse(string2);
            return date.getTime();
        }
        catch (ParseException parseException) {
            simpleDateFormat = new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
            try {
                Date date = simpleDateFormat.parse(string2);
                return date.getTime();
            }
            catch (ParseException parseException2) {
                simpleDateFormat = new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US);
                try {
                    Date date = simpleDateFormat.parse(string2);
                    return date.getTime();
                }
                catch (ParseException parseException3) {
                    throw new IllegalArgumentException(string2);
                }
            }
        }
    }

    public Enumeration getHeaderNames() {
        return this.headers_in.keys();
    }

    public HttpSession getSession(boolean bl) {
        if (this.session != null && this.session.isValid()) {
            return this.session;
        }
        if (this.requestedSessionId != null) {
            this.session = (JServSession)this.mgr.getSession(this.requestedSessionId);
            if (this.session != null && this.session.isValid()) {
                return this.session;
            }
        }
        if (bl) {
            String string = this.getJServRoute();
            this.session = string != null ? this.mgr.createSession(this, string) : this.mgr.createSession(this);
            return this.session;
        }
        return null;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public boolean isRequestedSessionIdValid() {
        if (this.requestedSessionId == null) {
            return false;
        }
        return this.mgr.getSession(this.requestedSessionId) != null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.idCameAsCookie;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.idCameAsUrl;
    }

    public void setContentLength(int n) {
        Integer n2 = new Integer(n);
        this.headers_out.put("Content-Length", n2.toString());
    }

    public void setContentType(String string) {
        this.headers_out.put("Content-Type", string);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.servlet_writer != null) {
            throw new IllegalStateException("Already called getWriter");
        }
        this.called_getOutput = true;
        return this.servlet_out;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.called_getOutput) {
            throw new IllegalStateException("Already called getOutputStream.");
        }
        if (this.servlet_writer == null) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)((Object)this.servlet_out), this.getCharacterEncoding());
            this.servlet_writer = new PrintWriter(outputStreamWriter);
        }
        return this.servlet_writer;
    }

    public String getCharacterEncoding() {
        String string = (String)this.headers_out.get("Content-Type");
        if (string == null) {
            string = "text/plain";
            this.setContentType(string);
        }
        return JServUtils.parseCharacterEncoding(string);
    }

    public void addCookie(Cookie cookie) {
        this.cookies_out.addElement(cookie);
    }

    public boolean containsHeader(String string) {
        return this.headers_out.contains(string.toLowerCase());
    }

    public void setStatus(int n, String string) {
        this.status = n;
        this.status_string = string;
    }

    public void setStatus(int n) {
        this.setStatus(n, null);
    }

    public void setHeader(String string, String string2) {
        int n = string2.indexOf(10);
        if (n > 0) {
            char[] cArray = string2.toCharArray();
            cArray[n] = 32;
            while ((n = string2.indexOf(10, n + 1)) > 0) {
                cArray[n] = 32;
            }
            string2 = new String(cArray);
        }
        this.headers_out.put(string, string2);
    }

    public void setIntHeader(String string, int n) {
        Integer n2 = new Integer(n);
        this.headers_out.put(string, n2.toString());
    }

    public void setDateHeader(String string, long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        simpleDateFormat.setTimeZone(timeZone);
        this.headers_out.put(string, simpleDateFormat.format(new Date(l)));
    }

    public void sendError(int n, String string) {
        block3: {
            try {
                this.status = n;
                this.setHeader("Servlet-Error", string);
                this.sendHttpHeaders();
                this.out.flush();
                if (this.client != null) {
                    this.client.close();
                }
            }
            catch (IOException iOException) {
                if (!JServ.log.active) break block3;
                JServ.log.log("servletException", iOException);
            }
        }
    }

    public void sendError(int n) {
        this.sendError(n, JServConnection.findStatusString(n));
    }

    public void sendError(Throwable throwable) {
        this.sendError(500, throwable.toString() + ": " + throwable.getMessage());
        if (JServ.log.active) {
            JServ.log.log("servletException", throwable);
        }
    }

    public void sendRedirect(String string) throws IOException {
        this.setStatus(200);
        this.setHeader("Location", string);
        this.sendHttpHeaders();
    }

    public String encodeUrl(String string) {
        if (this.isRequestedSessionIdFromCookie()) {
            return string;
        }
        if (this.session == null) {
            return string;
        }
        return this.mgr.encodeUrl(string, this.session.id);
    }

    public String encodeRedirectUrl(String string) {
        if (this.isRequestedSessionIdFromCookie()) {
            return string;
        }
        if (this.session == null) {
            return string;
        }
        if (string.indexOf(this.hostname) == -1) {
            return string;
        }
        return this.mgr.encodeUrl(string, this.session.id);
    }

    public static final String findStatusString(int n) {
        switch (n) {
            case 202: {
                return "Accepted";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 400: {
                return "Bad Request";
            }
            case 201: {
                return "Created";
            }
            case 403: {
                return "Forbidden";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Moved Temporarily";
            }
            case 204: {
                return "No Content";
            }
            case 404: {
                return "Not Found";
            }
            case 501: {
                return "Method Not Implemented";
            }
            case 304: {
                return "Not Modified";
            }
            case 200: {
                return "OK";
            }
            case 503: {
                return "Service Temporarily Unavailable";
            }
            case 401: {
                return "Authorization Required";
            }
        }
        return "Response";
    }

    public JServConnection() {
        JServConnection jServConnection = this;
        if (jServConnection == null) {
            throw null;
        }
        this.env_vars = new 1(jServConnection, 40, 0.9f);
        this.cookies_out = new Vector(5);
        this.status = 200;
        this.status_string = null;
        this.params = null;
        this.got_input = false;
        this.sent_header = false;
        this.idCameAsCookie = false;
        this.idCameAsUrl = false;
    }

    protected class JServInputStream
    extends ServletInputStream {
        protected InputStream in;
        protected int length;

        public int read() throws IOException {
            if (this.length == -1) {
                return this.in.read();
            }
            if (this.length > 0) {
                int n = this.in.read();
                if (n != -1) {
                    --this.length;
                }
                return n;
            }
            return -1;
        }

        public int read(byte[] byArray) throws IOException {
            if (this.length == -1) {
                return this.in.read(byArray, 0, byArray.length);
            }
            int n = byArray.length;
            if (n > this.length) {
                n = this.length;
            }
            if (n > 0) {
                int n2 = this.in.read(byArray, 0, n);
                if (n2 != -1) {
                    this.length -= n2;
                }
                return n2;
            }
            return -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.length == -1) {
                return this.in.read(byArray, n, n2);
            }
            if (n2 > this.length) {
                n2 = this.length;
            }
            if (n2 > 0) {
                int n3 = this.in.read(byArray, n, n2);
                if (n3 != -1) {
                    this.length -= n3;
                }
                return n3;
            }
            return -1;
        }

        public long skip(long l) throws IOException {
            if (this.length == -1) {
                return this.in.skip(l);
            }
            if (l > (long)this.length) {
                l = this.length;
            }
            if (l > 0L) {
                long l2 = this.in.skip(l);
                if (l2 != -1L) {
                    this.length = (int)((long)this.length - l2);
                }
                return l2;
            }
            return -1L;
        }

        public void close() throws IOException {
        }

        public int available() throws IOException {
            if (this.length == -1) {
                return this.in.available();
            }
            return this.length;
        }

        public JServInputStream(int n, InputStream inputStream) {
            this.length = n;
            this.in = inputStream;
        }
    }

    class JServOutputStream
    extends ServletOutputStream {
        protected OutputStream out;
        protected InputStream in;

        public void write(int n) throws IOException {
            JServConnection.this.sendHttpHeaders();
            this.out.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            JServConnection.this.sendHttpHeaders();
            this.out.write(byArray, n, n2);
        }

        public void flush() throws IOException {
            JServConnection.this.sendHttpHeaders();
            this.out.flush();
        }

        public void close() throws IOException {
            int n;
            do {
                n = this.in.available();
                this.in.skip(n);
            } while (n > 0);
            JServConnection.this.sendHttpHeaders();
            this.out.close();
        }

        public JServOutputStream(OutputStream outputStream, InputStream inputStream) {
            this.out = outputStream;
            this.in = inputStream;
        }
    }
}

