/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jserv;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.java.lang.Semaphore;
import org.apache.java.net.AuthenticatedServerSocket;
import org.apache.java.net.AuthenticatedSocket;
import org.apache.java.net.AuthenticationException;
import org.apache.java.recycle.pool.WorkerPool;
import org.apache.java.security.MD5;
import org.apache.java.security.MessageDigest;
import org.apache.java.util.Configurations;
import org.apache.java.util.ExtendedProperties;
import org.apache.jserv.JServConnection;
import org.apache.jserv.JServDefs;
import org.apache.jserv.JServLog;
import org.apache.jserv.JServLogChannels;
import org.apache.jserv.JServServletManager;

public class JServ
extends HttpServlet
implements JServLogChannels,
JServDefs {
    public static final int DEFAULT_PORT = 8007;
    public static final String DEFAULT_CONTROLLER = "org.apache.java.recycle.DefaultController";
    public static final String[] colors = new String[]{"#f0f0f0", "#e0e0e0"};
    protected static Hashtable servletManagerTable = new Hashtable();
    protected static Configurations confs = null;
    protected static JServLog log = null;
    protected static WorkerPool pool = null;
    private static ServerSocket listenSocket = null;
    private static Hashtable table = new Hashtable();
    private static Semaphore semaphore;
    static String confFile;
    private static final String SINGLE_COLUMN = "***";
    private static final String STATUS_SERVLET = "org.apache.jserv.JServ";

    public static final String version() {
        return "ApacheJServ" + "/" + "1.1.2";
    }

    public static void main(String[] stringArray) {
        Object object;
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            if (((String)object).charAt(0) == '-') {
                switch (((String)object).charAt(1)) {
                    case 'v': {
                        System.out.println("Server version: " + JServ.version());
                        break;
                    }
                    case 'V': {
                        System.out.println("Server version: " + JServ.version());
                        System.out.println("Turbo mode: true");
                        System.out.println("Profile mode: false");
                        break;
                    }
                    case 'r': {
                        if (confFile == null) {
                            JServ.usage();
                        }
                        JServ.signal("restart");
                        break;
                    }
                    case 's': {
                        if (confFile == null) {
                            JServ.usage();
                        }
                        JServ.signal("terminate");
                        break;
                    }
                    default: {
                        JServ.usage();
                    }
                }
                System.exit(0);
            } else if (confFile == null) {
                confFile = object;
            } else {
                JServ.usage();
            }
            ++n;
        }
        if (confFile == null) {
            JServ.usage();
        }
        JServ.welcome();
        JServ.start();
        while (true) {
            semaphore.throttle();
            try {
                JServConnection jServConnection = new JServConnection();
                object = new Thread(jServConnection);
                ((Thread)object).setDaemon(true);
                Socket socket = listenSocket.accept();
                jServConnection.init(socket, semaphore);
                ((Thread)object).start();
                continue;
            }
            catch (AuthenticationException authenticationException) {
                if (!JServ.log.active) continue;
                log.log("jservException", authenticationException.getMessage());
                continue;
            }
            catch (BindException bindException) {
                JServ.fail("Could not listen on specified port", bindException);
                continue;
            }
            catch (SocketException socketException) {
                if (JServ.log.active) {
                    log.log("jservException", socketException.getMessage());
                }
                JServ.restart();
                continue;
            }
            catch (Throwable throwable) {
                JServ.fail("An error occurred listening to the port", throwable);
                continue;
            }
            break;
        }
    }

    private static void welcome() {
        System.out.println(JServ.version());
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.jserv.JServ [config file] [options]");
        System.err.println("\nOptions:");
        System.err.println("  -v : show version number");
        System.err.println("  -V : show compile settings");
        System.err.println("  -s : tell running ApacheJServ to shutdown");
        System.err.println("  -r : tell running ApacheJServ to do a graceful restart");
        System.err.println("\nNote: please, specify the configuration file for the [-s] [-r] options.");
        System.exit(1);
    }

    static synchronized void start() {
        Object object;
        Object object2;
        Object object3;
        int n;
        int n2;
        try {
            confs = new Configurations(new ExtendedProperties(confFile));
        }
        catch (IOException iOException) {
            JServ.fail("Error while reading configuration file", iOException);
        }
        log = new JServLog("log", confs);
        if (JServ.log.active) {
            log.log("info", JServ.version() + " is starting...");
        }
        if ((n2 = confs.getInteger("port", 8007)) < 1024 || 65535 < n2) {
            if (JServ.log.active) {
                log.log("warning", Integer.toString(n2) + ": invalid port, reset to default " + 8007);
            }
            n2 = 8007;
        }
        if (confs.getBoolean("pool", false)) {
            n = confs.getInteger("pool.capacity", 10);
            String string = confs.getString("pool.controller", DEFAULT_CONTROLLER);
            pool = new WorkerPool(n, string);
        }
        if ((n = confs.getInteger("security.maxConnections", 50)) < 2) {
            n = 2;
        }
        semaphore = new Semaphore(n);
        int n3 = confs.getInteger("security.backlog", 5);
        if (n3 < 1) {
            n3 = 1;
        }
        byte[] byArray = null;
        MD5 mD5 = null;
        int n4 = 0;
        boolean bl = false;
        Vector<InetAddress> vector = new Vector<InetAddress>();
        boolean bl2 = confs.getBoolean("security.authentication", true);
        if (bl2) {
            if (JServ.log.active) {
                log.log("info", "Connection authentication enabled");
            }
            try {
                object3 = new File(confs.getString("security.secretKey"));
                object2 = new BufferedInputStream(new FileInputStream((File)object3));
                byArray = new byte[((InputStream)object2).available()];
                ((InputStream)object2).read(byArray);
                ((InputStream)object2).close();
            }
            catch (NullPointerException nullPointerException) {
                JServ.fail("No secret key file defined", nullPointerException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                JServ.fail("Could not open secret key file", fileNotFoundException);
            }
            catch (IOException iOException) {
                JServ.fail("Error found reading the secret key file", iOException);
            }
            mD5 = new MD5();
            n4 = confs.getInteger("security.challengeSize", 5);
        } else if (JServ.log.active) {
            log.log("info", "Connection authentication is disabled");
        }
        object3 = confs.getList("security.allowedAddresses");
        do {
            try {
                object2 = (String)object3.nextElement();
                if (((String)object2).equals("DISABLED")) {
                    vector = null;
                    break;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                object2 = "127.0.0.1";
            }
            try {
                object = InetAddress.getByName((String)object2);
                if (JServ.log.active) {
                    log.log("info", "Connection allowed from " + object);
                }
                vector.addElement((InetAddress)object);
            }
            catch (UnknownHostException unknownHostException) {
                if (!JServ.log.active) continue;
                log.log("warning", "Host " + (String)object2 + " not found and not allowed to connect");
            }
        } while (object3.hasMoreElements());
        try {
            object = JServ.bindTo(confs.getString("bindaddress"));
            if (JServ.log.active) {
                log.log("info", "Listening on port " + n2 + " accepting " + n + " maximum connections");
            }
            listenSocket = bl2 ? new AuthenticatedServerSocket(n2, n, vector, mD5, byArray, n4, (InetAddress)object) : new AuthenticatedServerSocket(n2, n, vector, (InetAddress)object);
        }
        catch (IOException iOException) {
            JServ.fail("Exception creating the server socket", iOException);
        }
        if (JServ.log.active) {
            log.log("info", "Creating Servlet Zones");
        }
        if ((object = confs.getList("zones")) == null) {
            JServ.fail("No servlet zones defined in configuration file");
        }
        while (object.hasMoreElements()) {
            String string;
            String string2 = (String)object.nextElement();
            if (JServ.log.active) {
                log.log("info", "Servlet Zone " + string2 + " initializing...");
            }
            if ((string = confs.getString(string2 + ".properties")) == null) {
                JServ.fail("No configuration file named \"" + string2 + ".properties\" for servlet zone " + string2);
            }
            if (JServ.log.active) {
                log.log("debug", " - Using configuration file: " + string);
            }
            JServServletManager jServServletManager = new JServServletManager(string2, string);
            jServServletManager.init(log);
            servletManagerTable.put(string2, jServServletManager);
            if (!JServ.log.active) continue;
            log.log("debug", "Servlet Zone " + string2 + " initialization complete");
        }
    }

    protected static synchronized void clear() {
        try {
            if (JServ.log.active) {
                log.log("debug", "Closing the server socket");
            }
            listenSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Enumeration enumeration = servletManagerTable.elements();
        while (enumeration.hasMoreElements()) {
            JServServletManager jServServletManager = (JServServletManager)enumeration.nextElement();
            if (JServ.log.active) {
                log.log("debug", "Terminating " + jServServletManager.getName());
            }
            jServServletManager.destroyServlets();
        }
        if (log != null) {
            log.flush();
        }
    }

    private static InetAddress bindTo(String string) {
        InetAddress inetAddress = null;
        try {
            if (string == null || string.equals("localhost")) {
                inetAddress = InetAddress.getByName("localhost");
            } else if (string.equals("*")) {
                inetAddress = null;
            } else {
                try {
                    inetAddress = InetAddress.getByName(string);
                }
                catch (UnknownHostException unknownHostException) {
                    inetAddress = InetAddress.getByName("localhost");
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            inetAddress = null;
        }
        return inetAddress;
    }

    protected static synchronized void restart() {
        if (JServ.log.active) {
            log.log("info", "Restarting " + JServ.version() + "...");
        }
        JServ.clear();
        JServ.start();
    }

    protected static synchronized void terminate() {
        if (JServ.log.active) {
            log.log("info", "Terminating " + JServ.version() + "...");
        }
        JServ.clear();
        if (JServ.log.active) {
            log.log("debug", JServ.version() + " terminated.");
        }
        log.flush();
        System.exit(0);
    }

    private static synchronized void signal(String string) {
        Configurations configurations = null;
        AuthenticatedSocket authenticatedSocket = null;
        byte[] byArray = new byte[]{-2, string.equals("restart") ? (byte)1 : 15};
        try {
            configurations = new Configurations(new ExtendedProperties(confFile));
        }
        catch (IOException iOException) {
            JServ.fail("Error while reading configuration file", iOException);
        }
        int n = configurations.getInteger("port", 8007);
        InetAddress inetAddress = JServ.bindTo(configurations.getString("bindaddress"));
        if (inetAddress == null) {
            inetAddress = JServ.bindTo("localhost");
        }
        if (inetAddress == null) {
            JServ.fail("Can't connect to server. BindAddress problem?");
        }
        boolean bl = configurations.getBoolean("security.authentication", true);
        byte[] byArray2 = new byte[]{};
        if (bl) {
            try {
                File file = new File(configurations.getString("security.secretKey"));
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                byArray2 = new byte[((InputStream)bufferedInputStream).available()];
                ((InputStream)bufferedInputStream).read(byArray2);
                ((InputStream)bufferedInputStream).close();
            }
            catch (NullPointerException nullPointerException) {
                JServ.fail("No secret key file defined", nullPointerException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                JServ.fail("Could not open secret key file", fileNotFoundException);
            }
            catch (IOException iOException) {
                JServ.fail("Error found reading the secret key file", iOException);
            }
            try {
                authenticatedSocket = new AuthenticatedSocket(inetAddress, n, (MessageDigest)new MD5(), byArray2);
            }
            catch (IOException iOException) {
                JServ.fail("Error found creating the socket", iOException);
            }
        } else {
            try {
                authenticatedSocket = new AuthenticatedSocket(inetAddress, n);
            }
            catch (ConnectException connectException) {
                if (string.equals("restart")) {
                    JServ.fail("Error cannot connect to ApacheJServ (Not started, cannot be Re-started!)", connectException);
                }
                JServ.fail("Error cannot connect", connectException);
            }
            catch (IOException iOException) {
                JServ.fail("Error found creating the socket", iOException);
            }
        }
        try {
            authenticatedSocket.getOutputStream().write(byArray);
            authenticatedSocket.close();
        }
        catch (IOException iOException) {
            JServ.fail("Error found signaling the running ApacheJServ", iOException);
        }
        System.out.println("Signal sent.");
    }

    protected static void fail(String string, Throwable throwable) {
        JServ.fail(string + ": " + throwable);
    }

    protected static void fail(String string) {
        try {
            if (JServ.log.active) {
                log.log("critical", JServ.version() + ": " + string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.err.println(JServ.version() + ": " + string);
        System.exit(1);
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        this.sendHead(servletOutputStream);
        if (!confs.getBoolean("security.selfservlet", false)) {
            servletOutputStream.println("<h2 align=center>Sorry, the execution of this service is denied for security reasons. You can enable this feature by setting the boolean configuration variable security.selfservlet</h2>");
            return;
        }
        try {
            String string = httpServletRequest.getQueryString();
            if (string.startsWith("status")) {
                this.handleStatus(servletOutputStream, string);
            } else if (string.startsWith("zones")) {
                this.handleZones(servletOutputStream, string);
            } else {
                this.showMenu(servletOutputStream);
            }
        }
        catch (NullPointerException nullPointerException) {
            this.showMenu(servletOutputStream);
        }
        this.sendTail(servletOutputStream);
    }

    private void sendHead(ServletOutputStream servletOutputStream) throws IOException {
        servletOutputStream.println("<html>");
        servletOutputStream.println("<head>");
        servletOutputStream.println("<meta name=\"GENERATOR\" CONTENT=\"" + JServ.version() + "\">");
        servletOutputStream.println("<title>" + JServ.version() + " status</title>");
        servletOutputStream.println("</head>");
        servletOutputStream.println("<body bgcolor=\"#ffffff\" text=\"#000000\">");
        servletOutputStream.println("<p align=center><img src=\"../../status?image\"></p>");
    }

    private void sendTail(ServletOutputStream servletOutputStream) throws IOException {
        servletOutputStream.println("<br><center><a href=\"../../status?menu\">Back to menu</a></center>");
        servletOutputStream.println("<p align=\"center\"><font size=-1>");
        servletOutputStream.println("Copyright (c) 1997-99 <a href=\"http://java.apache.org\">");
        servletOutputStream.println("The Java Apache Project</a>.<br>");
        servletOutputStream.println("All rights reserved.");
        servletOutputStream.println("</font></p>");
        servletOutputStream.println("</body>");
        servletOutputStream.println("</html>");
    }

    private void showMenu(ServletOutputStream servletOutputStream) throws IOException {
        table.clear();
        table.put("<a href=./org.apache.jserv.JServ?status><big>Current Status</big></a>", SINGLE_COLUMN);
        this.writeTable(servletOutputStream, JServ.version() + " Servlet Engine Status", table, colors);
        table.clear();
        Enumeration enumeration = servletManagerTable.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            table.put("<a href=./" + STATUS_SERVLET + "?zones=" + string + "><big>" + string + "</big></a>", SINGLE_COLUMN);
            ++n;
        }
        this.writeTable(servletOutputStream, "Servlet Zones", table, colors);
    }

    private void handleStatus(ServletOutputStream servletOutputStream, String string) throws IOException {
        table.clear();
        try {
            table.put("Name", System.getProperty("os.name"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            table.put("Architecture", System.getProperty("os.arch"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            table.put("Version", System.getProperty("os.version"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.writeTable(servletOutputStream, "Operating System", table, colors);
        table.clear();
        try {
            table.put("Version", System.getProperty("java.version"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            table.put("Vendor", "<a href=\"" + System.getProperty("java.vendor.url") + "\">" + System.getProperty("java.vendor") + "</a>");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            table.put("JVM Compiler", System.getProperty("java.compiler"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            table.put("Class Format Version", System.getProperty("java.class.version"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            table.put("Class Path", new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.writeTable(servletOutputStream, "Java Virtual Machine", table, colors);
        table.clear();
        try {
            table.put("Bindaddress", listenSocket.getInetAddress());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            table.put("Port", new Integer(listenSocket.getLocalPort()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            table.put("Maximum Connections", new Integer(((AuthenticatedServerSocket)listenSocket).getMaxConnections()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            table.put("Allowed IP Addresses", ((AuthenticatedServerSocket)listenSocket).getFilterList());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            table.put("Authentication", confs.getBoolean("security.authentication", true) ? "<font color=#00c000>Enabled</font>" : "<font color=#c00000>Disabled</font>");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            table.put("Challenge Size", new Integer(((AuthenticatedServerSocket)listenSocket).getChallengeSize()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer(JServ.log.active ? "Enabled" : "Disabled");
        if (!log.isSane()) {
            stringBuffer.insert(0, "<font color='#c00000'>");
            if (log.getSubsystemError() != null) {
                stringBuffer.append(" - ");
                stringBuffer.append(log.getSubsystemError());
            }
            stringBuffer.append("</font>");
        } else if (log.isActive()) {
            stringBuffer.append(" ( ");
            stringBuffer.append(confs.getString("log.file", "?"));
            stringBuffer.append(" )");
        }
        table.put("Logging", stringBuffer.toString());
        this.writeTable(servletOutputStream, "General Configurations", table, colors);
    }

    /*
     * Unable to fully structure code
     */
    private void handleZones(ServletOutputStream var1_1, String var2_2) throws IOException {
        block5: {
            var3_3 = new StringTokenizer(var2_2, "=");
            var3_3.nextToken();
            try {
                var4_4 = var3_3.nextToken();
                try {
                    var5_6 = ((JServServletManager)JServ.servletManagerTable.get((Object)var4_4)).confs;
                    this.writeTable(var1_1, "<font color=#ff0000>" + var4_4 + "</font> Servlet Zone</a>", var5_6.getRepository(), JServ.colors);
                }
                catch (Exception var5_7) {
                    var1_1.println("<h3 align=center>Error, servlet zone <b>" + var4_4 + "</b> was not found</h3>");
                }
                break block5;
            }
            catch (NoSuchElementException var4_5) {
                JServ.table.clear();
                var5_8 = JServ.servletManagerTable.keys();
                var6_9 = 0;
                ** while (var5_8.hasMoreElements())
            }
lbl-1000:
            // 1 sources

            {
                var7_10 = (String)var5_8.nextElement();
                JServ.table.put("<a href=./" + "org.apache.jserv.JServ" + "?zones=" + var7_10 + "><big>" + var7_10 + "</big></a>", "***");
                ++var6_9;
                continue;
            }
lbl23:
            // 1 sources

            this.writeTable(var1_1, "Servlet Zones", JServ.table, JServ.colors);
        }
    }

    private void writeTable(ServletOutputStream servletOutputStream, String string, Hashtable hashtable, String[] stringArray) throws IOException {
        Enumeration enumeration = hashtable.keys();
        servletOutputStream.println("<p><center><table bgcolor=#000000 border=0 cellpadding=0 cellspacing=0 width=50%>");
        servletOutputStream.println("<tr><td><table border=0 cellpadding=4 cellspacing=2 width=100%>");
        servletOutputStream.println("<tr><td align=right valign=middle colspan=2 bgcolor=#c0c0c0>");
        servletOutputStream.println("<h3>" + string + "</td></tr>");
        int n = 0;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            try {
                servletOutputStream.println("<tr><td align=right ");
                if (v.equals(SINGLE_COLUMN)) {
                    servletOutputStream.println("colspan=2 ");
                }
                servletOutputStream.println("bgcolor=" + stringArray[n2 & 1] + ">");
                servletOutputStream.println("<font size=-1>" + k.toString() + "</font></td>");
                if (!v.equals(SINGLE_COLUMN)) {
                    servletOutputStream.println("<td align=left bgcolor=" + stringArray[n2 & 1] + ">");
                    if (v instanceof Enumeration) {
                        Enumeration enumeration2 = (Enumeration)v;
                        while (enumeration2.hasMoreElements()) {
                            servletOutputStream.println("<b><font size=-1>" + enumeration2.nextElement().toString() + "</font></b>");
                        }
                    } else {
                        servletOutputStream.println("<b><font size=-1>" + v.toString() + "</font></b>");
                    }
                    servletOutputStream.println("</td></tr>");
                }
                ++n2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        servletOutputStream.println("</table></td></tr></table></center></p>");
    }

    static {
        confFile = null;
    }
}

