/*  tilp - link program for TI calculators
 *  Copyright (C) 1999-2001  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
  This file include some dependant OS headers files.
  There are few things because the GLIb is used finally.
*/

#ifndef __TIEMU_TILIBS__
#define __TIEMU_TILIBS__

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef HAVE_TILP_TYPEDEFS_H
# include <tilp/cabl_int.h>
# include <tilp/calc_int.h>
# include <tilp/defsxx.h>
# include <tilp/calc_err.h> // to use ERR_VOID_FUNCTION
# include <tilp/verbose.h>
#elif defined(__WIN32__)
# include "cabl_int.h"
# include "calc_int.h"
# include "defsxx.h"
# include "calc_err.h"
#else
# include "cabl/cabl_int.h"
# include "calc/calc_int.h"
# include "calc/defsxx.h"
# include "calc/calc_err.h"
#endif

#ifdef HAVE_LIBTIFFEP
# if defined(__LINUX__)
#  include <tiffep/tiffep.h>
# elif defined(__WIN32__)
#  include "tiffep_project/src/tiffep.h"
# endif
#endif

#if defined(HAVE_LIBTIFFEP) && defined(ENABLE_TIFFEP_SERVER)
# define HAVE_TIFFEP
#endif

#ifdef HAVE_LIBTI68K
#include <tiemu/lib68k.h>
#include <tiemu/sysdeps.h>
#include <tiemu/globinfo.h>
# include <tiemu/keydef.h>
#elif defined(__WIN32__)
# include "lib68k.h"
# include "sysdeps.h"
# include "globinfo.h"
# include "rom.h"
#else
# include "libti68k/lib68k.h"
# include "libti68k/sysdeps.h"
# include "libti68k/globinfo.h"
# include "libti68k/rom.h"
#endif

#endif

