/*
 * BackupFileNameFilter.java
 *
 * Created on December 21, 2003, 10:09 PM
 */

package com.sun.enterprise.config.backup;

import com.sun.enterprise.config.backup.pluggable.BackupEnvironment;
import com.sun.enterprise.config.backup.pluggable.EnvironmentFactory;
import com.sun.enterprise.config.backup.status.StatusConstants;
import java.io.File;

/**
 *
 * @author  sridatta
 */
public class SnapShotFileNameFilter implements java.io.FilenameFilter {
    
    private final String _backupFileNamePrefix;
    /** Creates a new instance of BackupFileNameFilter */
    public SnapShotFileNameFilter(String backupFileNamePrefix) {
        _backupFileNamePrefix = backupFileNamePrefix;
    }
    
    public boolean accept(java.io.File dir, String name) {
        try {
            return test(name);
        } catch(Exception e) {
        }
        return false;
    }
    
    private boolean test(String name) throws Exception {
        String[] parts =
            name.split(DefaultConstants.INTRA_FILENAME_SEPARATOR);
            
        BackupEnvironment be = 
            EnvironmentFactory.getEnvironmentFactory().
                                getBackupEnvironment();
        if (!be.getSnapshotFileNamePrefix().equals(parts[0]))
              return false;
        
        try {
            new Long(parts[1]).longValue();
            return true;
        } catch(Exception e) {
            return false;
        }
    }
}
