
import java.sql.*;




/**
 * test executing a prepared statement.
 * <p>
 * The prepared statement will
 * add a series of strings to the database.  Each consecutive string
 * will be longer than the previous string.
 *
 */
public class t0041
{
   static public String getLongString(int length)
   {
      int     i;
      String  result;

      result = "";
      for(i=0; i<length; i++)
      {
         result = result + "a";
      }
      return result;
   }


   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException, java.lang.Exception
   {
      boolean   passed = true;


      System.out.println("test executing a prepared statement.");

      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      int         i;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();

      try
      {
         stmt.executeUpdate("drop table t0041");
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0041', " +
                                      "because it does")))
         {
            throw e;
         }
      }

      count = stmt.executeUpdate("create table t0041              "
                                 + "  (i  integer  not null,      "
                                 + "   s  text     not null)      ");
      System.out.println("Creating table affected " + count + " rows");


      PreparedStatement pStmt = cx.prepareStatement(
         "insert into t0041 values (?, ?)");

      final int rowsToAdd = 800;
      final String theString = getLongString(400);
      count = 0;
      for(i=1; i<=rowsToAdd; i++)
      {
         pStmt.setInt(1, i);
         pStmt.setString(2, theString.substring(0, i));

         count += pStmt.executeUpdate();
      }


      ResultSet  rs = stmt.executeQuery("select s, i from t0041");

      while(rs.next())
      {
         System.out.println(rs.getString("i") + ":" +
                            rs.getString("s"));
      }

      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0041.\n");
      System.exit(passed ? 0 : 1);
   }
}


