
import java.sql.*;


/**
 * Test getBoolean() 
 *
 */
public class t0025
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException 
   {
      boolean   passed = true;


      System.out.println("Starting test t0025-  test getBoolean");

      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();

      try
      {
         stmt.executeUpdate("drop table t0025");
      }
      catch (SQLException e)
      {
         String okayError = "Cannot drop the table";

         if (! (e.getMessage().startsWith(okayError)))
         {
            throw e;
         }
      }
    
      count = stmt.executeUpdate("create table t0025             " +
                                 "  (i      integer,             " +
                                 "   b      bit,                 " +
                                 "   s      char(5),             " +
                                 "   f      float)               ");
      System.out.println("Creating table affected " + count + " rows");

      stmt.executeUpdate("insert into t0025 values(0, 0, 'false', 0.0)");
      stmt.executeUpdate("insert into t0025 values(0, 0, 'N', 0.0)");
      stmt.executeUpdate("insert into t0025 values(1, 1, 'true', 7.0)");
      stmt.executeUpdate("insert into t0025 values(2, 1, 'Y', -5.0)");
    
      ResultSet  rs = stmt.executeQuery("select * from t0025 order by i");
      

      
      if (!rs.next())
      {
         throw new SQLException("Failed");
      }
      passed = passed && (! (rs.getBoolean("i")  
                             || rs.getBoolean("b") 
                             || rs.getBoolean("s")
                             || rs.getBoolean("f")));


      if (!rs.next())
      {
         throw new SQLException("Failed");
      }
      passed = passed && (! (rs.getBoolean("i")  
                             || rs.getBoolean("b") 
                             || rs.getBoolean("s")
                             || rs.getBoolean("f")));


      if (!rs.next())
      {
         throw new SQLException("Failed");
      }
      passed = passed && (rs.getBoolean("i")  
                          && rs.getBoolean("b") 
                          && rs.getBoolean("s")
                          && rs.getBoolean("f"));

      if (!rs.next())
      {
         throw new SQLException("Failed");
      }
      passed = passed && (rs.getBoolean("i")  
                          && rs.getBoolean("b") 
                          && rs.getBoolean("s")
                          && rs.getBoolean("f"));
         
      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0025.\n");
      System.exit(passed ? 0 : 1);
   }
}

