
import java.sql.*;


/**
 * test nested statements
 *
 */
public class t0023
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException,
      java.lang.Exception, java.lang.InterruptedException
   {
      boolean passed = true;
      Double   d[] = {
         new Double(-1.0),
         new Double(1234.543),
         new Double(0.0),
         new Double(1),
         new Double(-2.0),
         new Double(0.14),
         new Double(0.79),
         new Double(1000000.12345),  
         new Double(-1000000.12345), 
         new Double(1000000),
         new Double(-1000000),
         new Double(1.7E+308),
         new Double(1.7E-307)        // jikes 1.04 has a bug and can't handle 1.7E-308
      };

      System.out.println("test using a float as a primary key");

      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      int         i;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();

      try
      {
         stmt.executeUpdate("drop table t0023");
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0023', because it does")))
         {
            throw e;
         }
      }

      count = stmt.executeUpdate(""
                                 + "create table t0023                  "
                                 + "  (pk   float not null,             "
                                 + "   type char(30) not null,          "
                                 + "   b    bit,                        "
                                 + "   str  char(30) not null,          "
                                 + "   t    datetime default getdate(), "
                                 +"    primary key (pk, type))    ");
      System.out.println("Creating table affected " + count + " rows");

      PreparedStatement  pStmt = cx.prepareStatement(
         "insert into t0023 (pk, type, b, str) values(?, 'prepared', 0, ?)");



      for(i=0; i<d.length; i++)
      {
         java.lang.Thread.sleep(10);
         {
            System.out.println("prepared stmt is adding: " + (d[i]).toString());

            pStmt.setDouble(1, d[i].doubleValue());
            pStmt.setString(2, (d[i]).toString());
            pStmt.executeUpdate();
         }

         {
            System.out.println("normal stmt is adding:   " + (d[i]).toString());
            stmt.executeUpdate(""
                               + "insert into t0023        "
                               + " (pk, type, b, str)      "
                               + " values("
                               + "   " + d[i] + ",         "
                               + "       'adhoc',          "
                               + "       1,                "
                               + "   '" + d[i] + "')       ");
         }
      }

      passed = true;

      ResultSet  rs = stmt.executeQuery("select * from t0023 where type='prepared' order by t");
      i=0;
      while(rs.next())
      {
         boolean  same = d[i].toString().equals(""+rs.getDouble("pk"));

         System.out.println(""
                            + same + " "
                            + rs.getObject(1) + " "
                            + rs.getObject(2) + " "
                            + rs.getObject(3) + " "
                            + rs.getObject(4) + " "
                            + d[i].toString() + " ");
         passed = passed && same;
         i++;
      }
      passed = passed && i==d.length;

      rs = stmt.executeQuery("select * from t0023 where type='adhoc' order by t");
      i=0;
      while(rs.next())
      {
         boolean  same = d[i].toString().equals(""+rs.getDouble("pk"));
         System.out.println(""
                            + same + " "
                            + rs.getObject(1) + " "
                            + rs.getObject(2) + " "
                            + rs.getObject(3) + " "
                            + rs.getObject(4) + " ");
         passed = passed && same;
         i++;
      }
      passed = passed && i==d.length;

      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0023.\n");
      System.exit(passed ? 0 : 1);
   }
}

