 

import java.sql.*;


/**
 * test executing a PreparedStatement twice.
 *
 */
public class t0007
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException, java.lang.Exception
   {
      System.out.println("test executing a PreparedStatement twice.");

      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      int         i;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();

      try
      {
         stmt.executeUpdate("drop table t0007");
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0007', because it does")))
         {
            throw e;
         }
      }
      
      count = stmt.executeUpdate("create table t0007              "
                                 + "  (i  integer  not null,      "
                                 + "   s  char(10) not null)      ");
      System.out.println("Creating table affected " + count + " rows");
      
      stmt = cx.createStatement();
         
      
      final int rowsToAdd = 20;
      count = 0;
      for(i=1; i<=rowsToAdd; i++)
      {
         String sql = "insert into t0007 values (" + i + ", 'row" + i + "')";
         count += stmt.executeUpdate(sql);
      }
      
      PreparedStatement   pStmt = cx.prepareStatement(
         "select s from t0007 where i=?");

      pStmt.setInt(1, 7);
      ResultSet  rs = pStmt.executeQuery();

      if (!rs.next())
      {
         throw new SQLException("Didn't get any results.");
      }
      System.out.println("Performed first query");

      pStmt.setInt(1, 8);
      rs = pStmt.executeQuery();
      if (!rs.next())
      {
         throw new SQLException("Didn't get and results.");
      }
      System.out.println("Performed second query");

      System.out.println("Passed t0007.");
   }
}

