/*
 * Decompiled with CFR 0.152.
 */
package com.rc.retroweaver;

import com.rc.retroweaver.NameTranslator;
import com.rc.retroweaver.TranslationException;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;

class NameTranslatorClassVisitor
extends ClassAdapter {
    private Set<String> visitedMethods;
    private String className;

    public NameTranslatorClassVisitor(ClassVisitor cv) {
        super(cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String newSuperName = NameTranslator.translate(superName);
        String[] newInterfaces = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            newInterfaces[i] = NameTranslator.translate(interfaces[i]);
        }
        this.className = name;
        this.visitedMethods = new HashSet<String>();
        super.visit(version, access, name, signature, newSuperName, newInterfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return super.visitField(access, name, NameTranslator.translate(desc), NameTranslator.translate(signature), value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String newDesc = NameTranslator.translate(desc);
        String fullDesc = name + newDesc;
        if (this.visitedMethods.contains(fullDesc)) {
            throw new TranslationException("Duplicate method after name translation in class " + this.className + ": " + name + ' ' + newDesc);
        }
        this.visitedMethods.add(fullDesc);
        return new MethodTranslator(super.visitMethod(access, name, newDesc, NameTranslator.translate(signature), exceptions));
    }

    private class MethodTranslator
    extends MethodAdapter {
        MethodTranslator(MethodVisitor mv) {
            super(mv);
        }

        public void visitTypeInsn(int opcode, String desc) {
            super.visitTypeInsn(opcode, NameTranslator.translate(desc));
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            super.visitFieldInsn(opcode, NameTranslator.translate(owner), name, NameTranslator.translate(desc));
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            super.visitMethodInsn(opcode, NameTranslator.translate(owner), name, NameTranslator.translate(desc));
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            super.visitTryCatchBlock(start, end, handler, NameTranslator.translate(type));
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            super.visitLocalVariable(name, NameTranslator.translate(desc), NameTranslator.translate(signature), start, end, index);
        }
    }
}

