/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIEI.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgExitINI(void);

	close any opened INI file
	If in wite mode currently, the changes are lost.

   Known bugs:
   		NULL is assumed to have numerical representation of '0'.

ob(ject): cfgExitINI
su(bsystem): inifile/3
sh(ort description): Close an opened INI file
lo(ng description): Close the currently opened INI file. If it is also opened
 for writing, any changes are lost.
re(lated to): cfgInitINI
fi(le): cfgiei.c
pr:=

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <stdlib.h>
#endif
#include "inifile.loc"
#include "supplio.h"
#include "dynstr.h"
#include "str.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIEI.C 1.3 1999/12/13 02:22:21 ska Exp ska $";
#endif

int cfgExitINI(void)
{	int rv;

	DBG_ENTER("cfgExitINI", Suppl_inifile3)

	rv = CFG_ERR_NONE;

	chkHeap
	/* Close the both INI files */
	cfgi_clFileStru(aS(sysini));
	chkHeap
	cfgi_clFileStru(aS(usrini));
	chkHeap

	/* Probably the INI is in write mode currently */
	/* Ignore the changes */
	if(I(writeOpen))
		rv = cfgi_wrClose(CFG_ERR_WRITE);

	chkHeap
	/* probably allocated strings */
	free(cfgi_inis.cfgi_key);
	chkHeap
	free(cfgi_inis.cfgi_buf);
	chkHeap

	memzero(aS(cfgi_inis), sizeof(cfgi_inis));	/* clear all */
	chkHeap

	DBG_RETURN_I( rv)
}
