/*
 * Decompiled with CFR 0.152.
 */
package test.suite;

import dguitar.adaptors.guitarPro.GPAdaptor;
import dguitar.adaptors.song.Song;
import dguitar.adaptors.song.Tempo;
import dguitar.codecs.CodecFormatException;
import dguitar.codecs.guitarPro.GPFormatException;
import dguitar.codecs.guitarPro.GPInputStream;
import dguitar.codecs.guitarPro.GPSong;
import dguitar.codecs.midi.MidiOutputStream;
import dguitar.players.sound.MasterPlayer;
import dguitar.players.sound.Performance;
import dguitar.players.sound.midi.MidiFiler;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;
import test.songs.MidiSongDefinition;
import test.songs.SongArchive;
import test.suite.MidiTestCase;

public class GPTest
extends MidiTestCase {
    public void testFourHands() throws Exception {
        MidiSongDefinition sd = SongArchive.fourhandsSongDefinition();
        this._testGPWithPlayer(sd, 540540);
    }

    public void _testGP(MidiSongDefinition sd) throws Exception {
        MidiSongDefinition testFile = SongArchive.testFileSongDefinition();
        try {
            GPInputStream gpis = new GPInputStream(sd.getGpFileName());
            GPSong gpsong = (GPSong)gpis.readObject();
            gpis.close();
            MidiOutputStream mos = new MidiOutputStream(new FileOutputStream(testFile.getMidiFileName()));
            mos.write(gpsong);
            mos.close();
            this.compareMIDIFiles(sd.getMidiFileName(), testFile.getMidiFileName(), sd.getChannels(), sd.getEventRemap());
        }
        catch (FileNotFoundException e) {
            GPTest.fail((String)"file not found exception");
        }
        catch (GPFormatException e) {
            GPTest.fail((String)"gp format exception");
        }
        catch (IOException e) {
            GPTest.fail((String)"ioexception");
        }
        catch (CodecFormatException e) {
            GPTest.fail((String)"codec format exception");
        }
        catch (InvalidMidiDataException e) {
            GPTest.fail((String)"invalid midi data exception");
        }
    }

    public void _testGPWithPlayer(MidiSongDefinition sd, int usq) throws Exception {
        MidiSongDefinition testFile = SongArchive.testFileSongDefinition();
        try {
            GPInputStream gpis = new GPInputStream(sd.getGpFileName());
            GPSong gpsong = (GPSong)gpis.readObject();
            gpis.close();
            int tempoGPSong = gpsong.getTempo();
            GPTest.assertEquals((int)(60000000 / usq), (int)tempoGPSong);
            Song song = GPAdaptor.makeSong(gpsong);
            Tempo tempoSong = song.getTempo();
            GPTest.assertEquals((int)usq, (int)((int)tempoSong.getUSQ()));
            MasterPlayer player = new MasterPlayer();
            player.setSoundPlayer(new MidiFiler(testFile.getMidiFileName()));
            Performance performance = player.arrange(song, null);
            Tempo tempoPerformance = performance.getTempo();
            GPTest.assertEquals((int)usq, (int)((int)tempoPerformance.getUSQ()));
            Sequence sequence = (Sequence)((Object)performance);
            Track[] midiTracks = sequence.getTracks();
            Track tempoMap = midiTracks[0];
            Tempo tempoInMIDI = new Tempo();
            int i = 0;
            while (i < tempoMap.size()) {
                MetaMessage meta;
                MidiEvent me = tempoMap.get(i);
                long tick = me.getTick();
                if (tick > 0L) break;
                MidiMessage mm = me.getMessage();
                if (mm.getStatus() == 255 && (meta = (MetaMessage)mm).getType() == 81) {
                    byte[] data = meta.getData();
                    tempoInMIDI.setUSQ((data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF);
                    break;
                }
                ++i;
            }
            GPTest.assertEquals((int)usq, (int)((int)tempoInMIDI.getUSQ()));
            MidiOutputStream mos = new MidiOutputStream(new FileOutputStream(testFile.getMidiFileName()));
            mos.write(performance);
            mos.close();
            this.compareMIDIFiles(sd.getMidiFileName(), testFile.getMidiFileName(), sd.getChannels(), sd.getEventRemap());
        }
        catch (FileNotFoundException e) {
            GPTest.fail((String)"file not found exception");
        }
        catch (GPFormatException e) {
            GPTest.fail((String)"gp format exception");
        }
        catch (IOException e) {
            GPTest.fail((String)"ioexception");
        }
        catch (CodecFormatException e) {
            GPTest.fail((String)"codec format exception");
        }
        catch (InvalidMidiDataException e) {
            GPTest.fail((String)"invalid midi data exception");
        }
    }
}

