/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui.midi;

import common.Midi;
import common.MidiTrackEvent;
import common.SwingWorker;
import dguitar.gui.DGuitar;
import dguitar.gui.PlayToolBar;
import dguitar.gui.midi.MidiEventPanel;
import i18n.Internationalized;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MidiInternalFrame
extends JInternalFrame
implements ActionListener,
InternalFrameListener,
Internationalized {
    private Vector V;
    private MidiEventPanel MEP;
    Object[] prevValues;
    SwingWorker worker;
    private boolean displayingEvents;
    private Dimension currentSize;
    boolean playing;
    boolean finished;
    private Midi midi;
    SwingWorker workerPlay;
    private PlayToolBar PTB;
    private JMenuItem menuFileExit;
    private JScrollPane Eventlist;
    private JMenu File;
    private JScrollPane MEPSP;
    private JList events;
    private JMenuBar jMenuBar1;
    private JCheckBoxMenuItem viewEvents;

    public MidiInternalFrame() {
    }

    public MidiInternalFrame(String file, Midi m, PlayToolBar ptb) {
        this.PTB = ptb;
        this.displayingEvents = false;
        this.prevValues = null;
        this.finished = false;
        this.midi = null;
        this.initComponents();
        this.viewEvents.setSelected(this.displayingEvents);
        this.setVisibleScrolls(this.displayingEvents);
        this.playing = false;
        this.setTitle(file);
        this.midi = m;
        m.prepareToPlay();
        m.loadMID(file);
        this.MEP = new MidiEventPanel(this);
        this.MEPSP.setViewportView(this.MEP);
    }

    public void setVisibleScrolls(boolean b) {
        this.MEPSP.setVisible(b);
        this.Eventlist.setVisible(b);
        this.currentSize = b ? new Dimension(500, 400) : new Dimension(500, 100);
        this.setSize(this.currentSize);
    }

    public Dimension getPreferredSize() {
        return this.currentSize;
    }

    public void displayEvents() {
        this.worker = new SwingWorker(){

            public Object construct() {
                String aux = MidiInternalFrame.this.viewEvents.getText();
                MidiInternalFrame.this.viewEvents.setEnabled(false);
                MidiInternalFrame.this.viewEvents.setText(DGuitar.getLang().getString("pleaseWait"));
                MidiInternalFrame.this.V = MidiInternalFrame.this.midi.SequenceToMidiTrackEvents();
                MidiInternalFrame.this.events.setListData(MidiInternalFrame.this.V);
                MidiInternalFrame.this.MEP.setMidiTrackEvents(MidiInternalFrame.this.V);
                MidiInternalFrame.this.validate();
                MidiInternalFrame.this.viewEvents.setText(aux);
                MidiInternalFrame.this.viewEvents.setEnabled(true);
                MidiInternalFrame.this.setVisibleScrolls(MidiInternalFrame.this.displayingEvents);
                MidiInternalFrame.this.finished = true;
                return null;
            }
        };
        this.worker.start();
    }

    private void performViewEvent(ActionEvent actionEvent) {
        int[] newIndices = null;
        int id = actionEvent.getID();
        if (id == 1001) {
            int[] indices = this.events.getSelectedIndices();
            JCheckBox JC = (JCheckBox)actionEvent.getSource();
            int current = this.MEP.getIndexFor(JC);
            if (!JC.isSelected()) {
                if (indices.length > 1) {
                    newIndices = new int[indices.length - 1];
                    int j = 0;
                    int i = 0;
                    while (i < indices.length) {
                        if (indices[i] != current) {
                            newIndices[j] = indices[i];
                            ++j;
                        }
                        ++i;
                    }
                    this.events.setSelectedIndices(newIndices);
                } else {
                    this.events.clearSelection();
                }
            } else {
                newIndices = new int[indices.length + 1];
                if (indices.length == 0) {
                    newIndices[0] = current;
                } else {
                    int j = 0;
                    boolean add = true;
                    int i = 0;
                    while (i < newIndices.length) {
                        if (add) {
                            if (j < indices.length && indices[j] < current) {
                                newIndices[i] = indices[j];
                                ++j;
                            } else {
                                newIndices[i] = current;
                                add = false;
                            }
                        } else {
                            newIndices[i] = indices[j];
                            ++j;
                        }
                        ++i;
                    }
                }
                this.events.setSelectedValue(this.MEP.getMidiTrackEventAt(current), true);
                this.events.setSelectedIndices(newIndices);
            }
        }
    }

    public void play() {
        if (!this.playing) {
            this.playing = true;
            this.workerPlay = new SwingWorker(){

                public Object construct() {
                    MidiInternalFrame.this.midi.play();
                    MidiInternalFrame.this.playing = false;
                    MidiInternalFrame.this.PTB.setPlaying(MidiInternalFrame.this.playing);
                    return null;
                }
            };
            this.workerPlay.start();
        }
    }

    public void stopPlaying() {
        this.midi.stop();
        this.playing = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object o = actionEvent.getSource();
        if (o.getClass().isInstance(this.viewEvents)) {
            this.performViewEvent(actionEvent);
        }
    }

    private void initComponents() {
        this.componentsCreate();
    }

    private void componentsCreate() {
        this.Eventlist = new JScrollPane();
        this.events = new JList();
        this.MEPSP = new JScrollPane();
        this.jMenuBar1 = new JMenuBar();
        this.File = new JMenu();
        this.viewEvents = new JCheckBoxMenuItem();
        this.menuFileExit = new JMenuItem();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.addInternalFrameListener(this);
        this.events.setFont(new Font("MS Sans Serif", 0, 10));
        this.events.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                MidiInternalFrame.this.eventsValueChanged(evt);
            }
        });
        this.Eventlist.setViewportView(this.events);
        this.getContentPane().add((Component)this.Eventlist, "Center");
        this.MEPSP.setVerticalScrollBarPolicy(21);
        this.getContentPane().add((Component)this.MEPSP, "South");
        this.viewEvents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MidiInternalFrame.this.viewEventsActionPerformed(evt);
            }
        });
        this.File.add(this.viewEvents);
        this.File.add(new JSeparator());
        this.menuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MidiInternalFrame.this.close();
                MidiInternalFrame.this.dispose();
            }
        });
        this.File.add(this.menuFileExit);
        this.jMenuBar1.add(this.File);
        this.setJMenuBar(this.jMenuBar1);
        this.setLangText();
    }

    public void setLangText() {
        this.setTitle("MIDI");
        this.events.setToolTipText("List of Midi events for this file");
        this.File.setText(DGuitar.lang.getString("File"));
        this.viewEvents.setText(DGuitar.lang.getString("menuMIFviewMidiEvents"));
        this.menuFileExit.setText(DGuitar.lang.getString("menuClose"));
    }

    private void viewEventsActionPerformed(ActionEvent evt) {
        if (!this.displayingEvents) {
            this.displayingEvents = true;
            if (!this.finished) {
                this.displayEvents();
            } else {
                this.setVisibleScrolls(this.displayingEvents);
            }
        } else {
            this.displayingEvents = false;
            this.setVisibleScrolls(this.displayingEvents);
        }
    }

    public void close() {
        if (this.worker != null) {
            this.worker.interrupt();
        }
        if (this.workerPlay != null) {
            this.workerPlay.interrupt();
            this.midi.stop();
        }
    }

    private void formInternalFrameClosing(InternalFrameEvent evt) {
        this.close();
    }

    private void eventsValueChanged(ListSelectionEvent evt) {
        int i;
        if (this.prevValues != null) {
            i = 0;
            while (i < this.prevValues.length) {
                this.MEP.setSelected((MidiTrackEvent)this.prevValues[i], false);
                ++i;
            }
        }
        Object[] values = this.events.getSelectedValues();
        i = 0;
        while (i < values.length) {
            this.MEP.setSelected((MidiTrackEvent)values[i], true);
            ++i;
        }
        this.prevValues = values;
    }

    public void internalFrameActivated(InternalFrameEvent evt) {
    }

    public void internalFrameClosed(InternalFrameEvent evt) {
    }

    public void internalFrameClosing(InternalFrameEvent evt) {
        this.formInternalFrameClosing(evt);
    }

    public void internalFrameDeactivated(InternalFrameEvent evt) {
    }

    public void internalFrameDeiconified(InternalFrameEvent evt) {
    }

    public void internalFrameIconified(InternalFrameEvent evt) {
    }

    public void internalFrameOpened(InternalFrameEvent evt) {
    }
}

