/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.LCount;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.dom.events.MutationEventImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.events.Event;

public class AttrImpl
extends NodeImpl
implements Attr {
    static final long serialVersionUID = 7277707688218972102L;
    protected Object value = null;
    protected String name;
    protected static TextImpl textNode = null;

    protected AttrImpl() {
    }

    protected AttrImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl);
        this.name = string;
        this.isSpecified(true);
        this.hasStringValue(true);
    }

    void checkNormalizationAfterInsert(ChildNode childNode) {
        if (childNode.getNodeType() == 3) {
            ChildNode childNode2 = childNode.previousSibling();
            ChildNode childNode3 = childNode.nextSibling;
            if (childNode2 != null && childNode2.getNodeType() == 3 || childNode3 != null && childNode3.getNodeType() == 3) {
                this.isNormalized(false);
            }
        } else if (!childNode.isNormalized()) {
            this.isNormalized(false);
        }
    }

    void checkNormalizationAfterRemove(ChildNode childNode) {
        ChildNode childNode2;
        if (childNode != null && childNode.getNodeType() == 3 && (childNode2 = childNode.nextSibling) != null && childNode2.getNodeType() == 3) {
            this.isNormalized(false);
        }
    }

    public Node cloneNode(boolean bl) {
        AttrImpl attrImpl = (AttrImpl)super.cloneNode(bl);
        if (!attrImpl.hasStringValue()) {
            attrImpl.value = null;
            if (bl) {
                Node node = (Node)this.value;
                while (node != null) {
                    attrImpl.appendChild(node.cloneNode(true));
                    node = node.getNextSibling();
                }
            }
        }
        attrImpl.isSpecified(true);
        return attrImpl;
    }

    public NodeList getChildNodes() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this;
    }

    public Element getElement() {
        return (Element)((Object)(this.isOwned() ? this.ownerNode : null));
    }

    public Node getFirstChild() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        this.makeChildNode();
        return (Node)this.value;
    }

    public Node getLastChild() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.lastChild();
    }

    public int getLength() {
        if (this.hasStringValue()) {
            return 1;
        }
        ChildNode childNode = (ChildNode)this.value;
        int n = 0;
        while (childNode != null) {
            ++n;
            childNode = childNode.nextSibling;
        }
        return n;
    }

    public String getName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    public String getNodeName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeValue() {
        return this.getValue();
    }

    public Element getOwnerElement() {
        return (Element)((Object)(this.isOwned() ? this.ownerNode : null));
    }

    public boolean getSpecified() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.isSpecified();
    }

    public String getValue() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (this.value == null) {
            return "";
        }
        if (this.hasStringValue()) {
            return (String)this.value;
        }
        ChildNode childNode = (ChildNode)this.value;
        ChildNode childNode2 = childNode.nextSibling;
        if (childNode2 == null) {
            return childNode.getNodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer(childNode.getNodeValue());
        while (childNode2 != null) {
            stringBuffer.append(childNode2.getNodeValue());
            childNode2 = childNode2.nextSibling;
        }
        return stringBuffer.toString();
    }

    public boolean hasChildNodes() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.value != null;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        return this.internalInsertBefore(node, node2, 65535);
    }

    Node internalInsertBefore(Node node, Node node2, int n) throws DOMException {
        Object object;
        NodeImpl nodeImpl;
        Object object2;
        DocumentImpl documentImpl = this.ownerDocument();
        boolean bl = documentImpl.errorChecking;
        if (node.getNodeType() == 11) {
            if (bl) {
                Node node3 = node.getFirstChild();
                while (node3 != null) {
                    if (!documentImpl.isKidOK(this, node3)) {
                        throw new DOMException(3, "DOM006 Hierarchy request error");
                    }
                    node3 = node3.getNextSibling();
                }
            }
            while (node.hasChildNodes()) {
                this.insertBefore(node.getFirstChild(), node2);
            }
            return node;
        }
        if (node == node2) {
            node2 = node2.getNextSibling();
            this.removeChild(node);
            this.insertBefore(node, node2);
            return node;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (bl) {
            if (this.isReadOnly()) {
                throw new DOMException(7, "DOM001 Modification not allowed");
            }
            if (node.getOwnerDocument() != documentImpl) {
                throw new DOMException(4, "DOM005 Wrong document");
            }
            if (!documentImpl.isKidOK(this, node)) {
                throw new DOMException(3, "DOM006 Hierarchy request error");
            }
            if (node2 != null && node2.getParentNode() != this) {
                throw new DOMException(8, "DOM008 Not found");
            }
            boolean bl2 = true;
            object2 = this;
            while (bl2 && object2 != null) {
                bl2 = node != object2;
                object2 = ((NodeImpl)object2).parentNode();
            }
            if (!bl2) {
                throw new DOMException(3, "DOM006 Hierarchy request error");
            }
        }
        this.makeChildNode();
        NodeImpl.EnclosingAttr enclosingAttr = null;
        if (documentImpl.mutationEvents && (n & 2) != 0) {
            object2 = LCount.lookup("DOMAttrModified");
            if (((LCount)object2).captures + ((LCount)object2).bubbles + ((LCount)object2).defaults > 0) {
                enclosingAttr = this.getEnclosingAttr();
            }
        }
        if ((nodeImpl = ((ChildNode)(object2 = (ChildNode)node)).parentNode()) != null) {
            nodeImpl.removeChild((Node)object2);
        }
        ChildNode childNode = (ChildNode)node2;
        ((NodeImpl)object2).ownerNode = this;
        ((NodeImpl)object2).isOwned(true);
        ChildNode childNode2 = (ChildNode)this.value;
        if (childNode2 == null) {
            this.value = object2;
            ((NodeImpl)object2).isFirstChild(true);
            ((ChildNode)object2).previousSibling = object2;
        } else if (childNode == null) {
            object = childNode2.previousSibling;
            ((ChildNode)object).nextSibling = object2;
            ((ChildNode)object2).previousSibling = object;
            childNode2.previousSibling = object2;
        } else if (node2 == childNode2) {
            childNode2.isFirstChild(false);
            ((ChildNode)object2).nextSibling = childNode2;
            ((ChildNode)object2).previousSibling = childNode2.previousSibling;
            childNode2.previousSibling = object2;
            this.value = object2;
            ((NodeImpl)object2).isFirstChild(true);
        } else {
            object = childNode.previousSibling;
            ((ChildNode)object2).nextSibling = childNode;
            ((ChildNode)object).nextSibling = object2;
            childNode.previousSibling = object2;
            ((ChildNode)object2).previousSibling = object;
        }
        this.changed();
        if (documentImpl.mutationEvents) {
            if ((n & 1) != 0) {
                Object object3;
                object = LCount.lookup("DOMNodeInserted");
                if (((LCount)object).captures + ((LCount)object).bubbles + ((LCount)object).defaults > 0) {
                    object3 = new MutationEventImpl();
                    object3.initMutationEvent("DOMNodeInserted", true, false, this, null, null, null, (short)0);
                    ((NodeImpl)object2).dispatchEvent((Event)object3);
                }
                object = LCount.lookup("DOMNodeInsertedIntoDocument");
                if (((LCount)object).captures + ((LCount)object).bubbles + ((LCount)object).defaults > 0) {
                    object3 = this;
                    if (enclosingAttr != null) {
                        object3 = (NodeImpl)((Object)enclosingAttr.node.getOwnerElement());
                    }
                    if (object3 != null) {
                        Object object4 = object3;
                        while (object4 != null) {
                            object3 = object4;
                            object4 = ((NodeImpl)object4).getNodeType() == 2 ? (ElementImpl)((AttrImpl)object4).getOwnerElement() : ((NodeImpl)object4).parentNode();
                        }
                        if (((NodeImpl)object3).getNodeType() == 9) {
                            MutationEventImpl mutationEventImpl = new MutationEventImpl();
                            mutationEventImpl.initMutationEvent("DOMNodeInsertedIntoDocument", false, false, null, null, null, null, (short)0);
                            this.dispatchEventToSubtree((Node)object2, mutationEventImpl);
                        }
                    }
                }
            }
            if ((n & 2) != 0) {
                this.dispatchAggregateEvents(enclosingAttr);
            }
        }
        this.checkNormalizationAfterInsert((ChildNode)object2);
        return node;
    }

    Node internalRemoveChild(Node node, int n) throws DOMException {
        NodeImpl nodeImpl;
        Object object;
        Object object2;
        DocumentImpl documentImpl = this.ownerDocument();
        if (documentImpl.errorChecking) {
            if (this.isReadOnly()) {
                throw new DOMException(7, "DOM001 Modification not allowed");
            }
            if (node != null && node.getParentNode() != this) {
                throw new DOMException(8, "DOM008 Not found");
            }
        }
        documentImpl.removedChildNode(node);
        ChildNode childNode = (ChildNode)node;
        NodeImpl.EnclosingAttr enclosingAttr = null;
        if (documentImpl.mutationEvents) {
            object2 = LCount.lookup("DOMAttrModified");
            if (((LCount)object2).captures + ((LCount)object2).bubbles + ((LCount)object2).defaults > 0) {
                enclosingAttr = this.getEnclosingAttr();
            }
            if ((n & 1) != 0) {
                object2 = LCount.lookup("DOMNodeRemoved");
                if (((LCount)object2).captures + ((LCount)object2).bubbles + ((LCount)object2).defaults > 0) {
                    object = new MutationEventImpl();
                    object.initMutationEvent("DOMNodeRemoved", true, false, this, null, null, null, (short)0);
                    childNode.dispatchEvent((Event)object);
                }
                object2 = LCount.lookup("DOMNodeRemovedFromDocument");
                if (((LCount)object2).captures + ((LCount)object2).bubbles + ((LCount)object2).defaults > 0) {
                    object = this;
                    if (enclosingAttr != null) {
                        object = (NodeImpl)((Object)enclosingAttr.node.getOwnerElement());
                    }
                    if (object != null) {
                        nodeImpl = ((NodeImpl)object).parentNode();
                        while (nodeImpl != null) {
                            object = nodeImpl;
                            nodeImpl = nodeImpl.parentNode();
                        }
                        if (((NodeImpl)object).getNodeType() == 9) {
                            MutationEventImpl mutationEventImpl = new MutationEventImpl();
                            mutationEventImpl.initMutationEvent("DOMNodeRemovedFromDocument", false, false, null, null, null, null, (short)0);
                            this.dispatchEventToSubtree(childNode, mutationEventImpl);
                        }
                    }
                }
            }
        }
        if (childNode == this.value) {
            childNode.isFirstChild(false);
            this.value = childNode.nextSibling;
            object2 = (ChildNode)this.value;
            if (object2 != null) {
                ((NodeImpl)object2).isFirstChild(true);
                ((ChildNode)object2).previousSibling = childNode.previousSibling;
            }
        } else {
            object2 = childNode.previousSibling;
            object = childNode.nextSibling;
            ((ChildNode)object2).nextSibling = object;
            if (object == null) {
                nodeImpl = (ChildNode)this.value;
                ((ChildNode)nodeImpl).previousSibling = object2;
            } else {
                ((ChildNode)object).previousSibling = object2;
            }
        }
        object2 = childNode.previousSibling();
        childNode.ownerNode = documentImpl;
        childNode.isOwned(false);
        childNode.nextSibling = null;
        childNode.previousSibling = null;
        this.changed();
        if (documentImpl.mutationEvents && (n & 2) != 0) {
            this.dispatchAggregateEvents(enclosingAttr);
        }
        this.checkNormalizationAfterRemove((ChildNode)object2);
        return childNode;
    }

    public Node item(int n) {
        if (this.hasStringValue()) {
            if (n != 0 || this.value == null) {
                return null;
            }
            this.makeChildNode();
            return (Node)this.value;
        }
        ChildNode childNode = (ChildNode)this.value;
        int n2 = 0;
        while (n2 < n && childNode != null) {
            childNode = childNode.nextSibling;
            ++n2;
        }
        return childNode;
    }

    final ChildNode lastChild() {
        this.makeChildNode();
        return this.value != null ? ((ChildNode)this.value).previousSibling : null;
    }

    final void lastChild(ChildNode childNode) {
        if (this.value != null) {
            ((ChildNode)this.value).previousSibling = childNode;
        }
    }

    protected void makeChildNode() {
        if (this.hasStringValue()) {
            if (this.value != null) {
                TextImpl textImpl = (TextImpl)this.ownerDocument().createTextNode((String)this.value);
                this.value = textImpl;
                textImpl.isFirstChild(true);
                textImpl.previousSibling = textImpl;
                textImpl.ownerNode = this;
                textImpl.isOwned(true);
            }
            this.hasStringValue(false);
        }
    }

    public void normalize() {
        if (this.isNormalized() || this.hasStringValue()) {
            return;
        }
        ChildNode childNode = (ChildNode)this.value;
        Node node = childNode;
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getNodeType() == 3) {
                if (node2 != null && node2.getNodeType() == 3) {
                    ((Text)node).appendData(node2.getNodeValue());
                    this.removeChild(node2);
                    node2 = node;
                } else if (node.getNodeValue().length() == 0) {
                    this.removeChild(node);
                }
            }
            node = node2;
        }
        this.isNormalized(true);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.needsSyncChildren(false);
    }

    public Node removeChild(Node node) throws DOMException {
        if (this.hasStringValue()) {
            throw new DOMException(8, "DOM008 Not found");
        }
        return this.internalRemoveChild(node, 65535);
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.makeChildNode();
        NodeImpl.EnclosingAttr enclosingAttr = null;
        DocumentImpl documentImpl = this.ownerDocument();
        if (documentImpl.mutationEvents) {
            LCount lCount = LCount.lookup("DOMAttrModified");
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                enclosingAttr = this.getEnclosingAttr();
            }
        }
        this.internalInsertBefore(node, node2, 1);
        if (node != node2) {
            this.internalRemoveChild(node2, 1);
        }
        if (documentImpl.mutationEvents) {
            this.dispatchAggregateEvents(enclosingAttr);
        }
        return node2;
    }

    public void setNodeValue(String string) throws DOMException {
        this.setValue(string);
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        super.setReadOnly(bl, bl2);
        if (bl2) {
            if (this.needsSyncChildren()) {
                this.synchronizeChildren();
            }
            if (this.hasStringValue()) {
                return;
            }
            ChildNode childNode = (ChildNode)this.value;
            while (childNode != null) {
                if (childNode.getNodeType() != 5) {
                    childNode.setReadOnly(bl, true);
                }
                childNode = childNode.nextSibling;
            }
        }
    }

    public void setSpecified(boolean bl) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.isSpecified(bl);
    }

    /*
     * Unable to fully structure code
     */
    public void setValue(String var1_1) {
        block13: {
            block12: {
                if (this.isReadOnly()) {
                    throw new DOMException(7, "DOM001 Modification not allowed");
                }
                var2_2 = null;
                var3_3 = "";
                var4_4 = this.ownerDocument();
                if (var4_4.mutationEvents) {
                    var2_2 = LCount.lookup("DOMAttrModified");
                    if (var2_2.captures + var2_2.bubbles + var2_2.defaults > 0 && this.ownerNode != null) {
                        var3_3 = this.getValue();
                    }
                }
                if (!var4_4.mutationEvents) break block12;
                if (this.needsSyncChildren()) {
                    this.synchronizeChildren();
                }
                if (this.value == null) break block13;
                if (!this.hasStringValue()) ** GOTO lbl30
                if (AttrImpl.textNode == null) {
                    AttrImpl.textNode = (TextImpl)var4_4.createTextNode((String)this.value);
                } else {
                    AttrImpl.textNode.data = (String)this.value;
                }
                this.value = AttrImpl.textNode;
                AttrImpl.textNode.isFirstChild(true);
                AttrImpl.textNode.previousSibling = AttrImpl.textNode;
                AttrImpl.textNode.ownerNode = this;
                AttrImpl.textNode.isOwned(true);
                this.hasStringValue(false);
                this.internalRemoveChild(AttrImpl.textNode, 1);
                break block13;
lbl-1000:
                // 1 sources

                {
                    this.internalRemoveChild((Node)this.value, 1);
lbl30:
                    // 2 sources

                    ** while (this.value != null)
                }
lbl31:
                // 1 sources

                break block13;
            }
            if (!this.hasStringValue() && this.value != null) {
                var5_5 = (ChildNode)this.value;
                var5_5.previousSibling = null;
                var5_5.isFirstChild(false);
            }
            this.value = null;
            this.needsSyncChildren(false);
        }
        this.isSpecified(true);
        if (var1_1 != null) {
            if (var4_4.mutationEvents) {
                this.internalInsertBefore(var4_4.createTextNode(var1_1), null, 1);
                this.hasStringValue(false);
            } else {
                this.value = var1_1;
                this.hasStringValue(true);
            }
        }
        this.changed();
        if (var4_4.mutationEvents) {
            this.dispatchAggregateEvents(this, var3_3, (short)1);
        }
    }

    protected void synchronizeChildren() {
        this.needsSyncChildren(false);
    }

    protected final void synchronizeChildren(int n) {
        DeferredDocumentImpl deferredDocumentImpl = (DeferredDocumentImpl)this.ownerDocument();
        boolean bl = deferredDocumentImpl.mutationEvents;
        deferredDocumentImpl.mutationEvents = false;
        this.needsSyncChildren(false);
        int n2 = deferredDocumentImpl.getLastChild(n);
        int n3 = deferredDocumentImpl.getPrevSibling(n2);
        if (n3 == -1) {
            this.value = deferredDocumentImpl.getNodeValueString(n2);
            this.hasStringValue(true);
        } else {
            NodeImpl nodeImpl = null;
            ChildNode childNode = null;
            int n4 = n2;
            while (n4 != -1) {
                ChildNode childNode2 = (ChildNode)((Object)deferredDocumentImpl.getNodeObject(n4));
                if (childNode == null) {
                    childNode = childNode2;
                } else {
                    ((ChildNode)nodeImpl).previousSibling = childNode2;
                }
                childNode2.ownerNode = this;
                childNode2.isOwned(true);
                childNode2.nextSibling = nodeImpl;
                nodeImpl = childNode2;
                n4 = deferredDocumentImpl.getPrevSibling(n4);
            }
            if (childNode != null) {
                this.value = nodeImpl;
                nodeImpl.isFirstChild(true);
                this.lastChild(childNode);
            }
            this.hasStringValue(false);
        }
        deferredDocumentImpl.mutationEvents = bl;
    }

    public String toString() {
        return String.valueOf(this.getName()) + "=" + "\"" + this.getValue() + "\"";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        objectOutputStream.defaultWriteObject();
    }
}

