/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import org.apache.log.Category;
import org.apache.log.LogEngine;
import org.apache.log.LogEntry;
import org.apache.log.LogKit;
import org.apache.log.LogTarget;
import org.apache.log.Priority;

public class Logger {
    protected static final long START_TIME = System.currentTimeMillis();
    protected final LogEngine m_engine;
    protected final Logger m_parent;
    protected final Category m_category;
    protected LogTarget[] m_logTargets;

    public final void debug(String string, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.output(Priority.DEBUG, string, throwable);
        }
    }

    public final void debug(String string) {
        if (this.isDebugEnabled()) {
            this.output(Priority.DEBUG, string, null);
        }
    }

    public final void error(String string, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.output(Priority.ERROR, string, throwable);
        }
    }

    public final void error(String string) {
        if (this.isErrorEnabled()) {
            this.output(Priority.ERROR, string, null);
        }
    }

    public final void fatalError(String string, Throwable throwable) {
        if (this.isFatalErrorEnabled()) {
            this.output(Priority.FATAL_ERROR, string, throwable);
        }
    }

    public final void fatalError(String string) {
        if (this.isFatalErrorEnabled()) {
            this.output(Priority.FATAL_ERROR, string, null);
        }
    }

    public final Category getCategory() {
        return this.m_category;
    }

    public final void info(String string) {
        if (this.isInfoEnabled()) {
            this.output(Priority.INFO, string, null);
        }
    }

    public final void log(Priority.Enum enum_, String string, Throwable throwable) {
        if (this.m_category.getPriority().isLowerOrEqual(enum_) && this.m_engine.getGlobalPriority().isLowerOrEqual(enum_)) {
            this.output(enum_, string, throwable);
        }
    }

    public final void log(Priority.Enum enum_, String string) {
        if (this.m_category.getPriority().isLowerOrEqual(enum_) && this.m_engine.getGlobalPriority().isLowerOrEqual(enum_)) {
            this.output(enum_, string, null);
        }
    }

    private final void output(Priority.Enum enum_, String string, Throwable throwable) {
        LogEntry logEntry = new LogEntry();
        logEntry.setCategory(this.m_category);
        logEntry.setContextStack(LogKit.getCurrentContext());
        if (string != null) {
            logEntry.setMessage(string);
        } else {
            logEntry.setMessage("");
        }
        logEntry.setThrowable(throwable);
        logEntry.setPriority(enum_);
        logEntry.setTime(System.currentTimeMillis() - START_TIME);
        this.output(logEntry);
    }

    protected final void output(LogEntry logEntry) {
        LogTarget[] logTargetArray = this.m_logTargets;
        if (logTargetArray == null) {
            if (this.m_parent != null) {
                this.m_parent.output(logEntry);
            } else {
                this.m_engine.getDefaultLogTarget().processEntry(logEntry);
            }
        } else {
            int n = 0;
            while (n < logTargetArray.length) {
                logTargetArray[n].processEntry(logEntry);
                ++n;
            }
        }
    }

    public final void warn(String string, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.output(Priority.WARN, string, throwable);
        }
    }

    public final void warn(String string) {
        if (this.isWarnEnabled()) {
            this.output(Priority.WARN, string, null);
        }
    }

    public final boolean isDebugEnabled() {
        return this.m_category.getPriority().isLowerOrEqual(Priority.DEBUG) && this.m_engine.getGlobalPriority().isLowerOrEqual(Priority.DEBUG);
    }

    public final boolean isInfoEnabled() {
        return this.m_category.getPriority().isLowerOrEqual(Priority.INFO) && this.m_engine.getGlobalPriority().isLowerOrEqual(Priority.INFO);
    }

    public final boolean isWarnEnabled() {
        return this.m_category.getPriority().isLowerOrEqual(Priority.WARN) && this.m_engine.getGlobalPriority().isLowerOrEqual(Priority.WARN);
    }

    public final boolean isErrorEnabled() {
        return this.m_category.getPriority().isLowerOrEqual(Priority.ERROR) && this.m_engine.getGlobalPriority().isLowerOrEqual(Priority.ERROR);
    }

    public final boolean isFatalErrorEnabled() {
        return this.m_category.getPriority().isLowerOrEqual(Priority.FATAL_ERROR) && this.m_engine.getGlobalPriority().isLowerOrEqual(Priority.FATAL_ERROR);
    }

    public void setLogTargets(LogTarget[] logTargetArray) {
        this.m_logTargets = logTargetArray;
    }

    public final LogTarget[] getLogTargets() {
        return this.m_logTargets;
    }

    public final synchronized void addLogTarget(LogTarget logTarget) {
        if (this.m_logTargets == null) {
            this.m_logTargets = new LogTarget[]{logTarget};
        } else {
            LogTarget[] logTargetArray = new LogTarget[this.m_logTargets.length + 1];
            System.arraycopy(this.m_logTargets, 0, logTargetArray, 0, this.m_logTargets.length);
            logTargetArray[this.m_logTargets.length] = logTarget;
            this.m_logTargets = logTargetArray;
        }
    }

    public Logger getChildLogger(String string) {
        String string2 = this.m_category.getName() + "." + string;
        return this.m_engine.getLoggerFor(string2);
    }

    public Logger(Category category) {
        this(LogKit.getDefaultLogEngine(), category, null, null);
    }

    public Logger(Category category, LogTarget[] logTargetArray) {
        this(LogKit.getDefaultLogEngine(), category, logTargetArray, null);
    }

    public Logger(Category category, Logger logger) {
        this(LogKit.getDefaultLogEngine(), category, null, logger);
    }

    public Logger(Category category, LogTarget[] logTargetArray, Logger logger) {
        this(LogKit.getDefaultLogEngine(), category, logTargetArray, logger);
    }

    protected Logger(LogEngine logEngine, Category category) {
        this(logEngine, category, null, null);
    }

    protected Logger(LogEngine logEngine, Category category, LogTarget[] logTargetArray) {
        this(logEngine, category, logTargetArray, null);
    }

    protected Logger(LogEngine logEngine, Category category, Logger logger) {
        this(logEngine, category, null, logger);
    }

    protected Logger(LogEngine logEngine, Category category, LogTarget[] logTargetArray, Logger logger) {
        this.m_engine = logEngine;
        this.m_category = category;
        this.m_logTargets = logTargetArray;
        this.m_parent = logger;
    }
}

