/*
 * Decompiled with CFR 0.152.
 */
package jstyle;

import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class JSLineBreaker {
    private static final int BEFORE = 0;
    private static final int AFTER = 1;
    private String[] prefs = new String[]{"().", "()", ").", "+=", "-=", "*=", "/=", "%=", "^=", "||", "&&", "==", "!=", ">=", "<=", "(", ")", "[", "]", "?", ":", ",", ";", "=", "<", ">", "+", "-", "*", "/", "&", "|", "^"};
    private static Hashtable prefTable = new Hashtable();
    private Vector brokenLineVector;
    private StringBuffer wsBuffer;
    private char quoteChar;
    private boolean isInQuote;
    private boolean isInComment;
    private boolean isNestedConnection = true;
    private boolean isCut;
    private boolean isLineComment;
    private int parenDepth;
    private int breakDepth;
    private int preferredLineLength = 70;
    private int lineLengthDeviation = 5;
    private LineBreak previousLineBreak;

    JSLineBreaker() {
        this.init();
    }

    void init() {
        this.brokenLineVector = new Vector();
        this.parenDepth = 0;
        this.breakDepth = 0;
        this.isInQuote = false;
        this.isInComment = false;
        this.isCut = false;
        this.isLineComment = false;
        this.wsBuffer = new StringBuffer();
    }

    void setPreferredLineLength(int n) {
        this.preferredLineLength = n;
    }

    void setLineLengthDeviation(int n) {
        this.lineLengthDeviation = n;
    }

    void setNestedConnection(boolean bl) {
        this.isNestedConnection = bl;
    }

    /*
     * Unable to fully structure code
     */
    void breakLine(String var1_1) {
        var2_2 = new StringBuffer();
        var3_3 = new Stack<E>();
        var4_4 = false;
        var5_5 = ' ';
        var6_6 = '\u0000';
        var9_7 = 0;
        if (var1_1.trim().length() == 0) {
            this.brokenLineVector.addElement("");
            return;
        }
        var5_5 = var1_1.charAt(0);
        var8_8 = 0;
        if (!this.isLineComment) {
            this.isCut = false;
        }
        this.isLineComment = false;
        if (!this.isCut) {
            this.wsBuffer = new StringBuffer();
            while ((var5_5 == ' ' || var5_5 == '\t') && var8_8 < var1_1.length() - 1) {
                this.wsBuffer.append(var5_5);
                var5_5 = var1_1.charAt(++var8_8);
            }
        }
        var7_9 = var8_8;
        while (var7_9 < var1_1.length()) {
            block21: {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block23: {
                                        block22: {
                                            block20: {
                                                if (var5_5 != ' ' && var5_5 != '\t') {
                                                    var6_6 = var5_5;
                                                }
                                                var5_5 = var1_1.charAt(var7_9);
                                                if (!var4_4) break block20;
                                                var2_2.append(var5_5);
                                                var4_4 = false;
                                                break block21;
                                            }
                                            if (this.isInComment || this.isLineComment || !var1_1.regionMatches(false, var7_9, "\\\\", 0, 2)) break block22;
                                            var2_2.append("\\\\");
                                            ++var7_9;
                                            break block21;
                                        }
                                        if (this.isInComment || this.isLineComment || var5_5 != 92) break block23;
                                        var2_2.append(var5_5);
                                        var4_4 = true;
                                        break block21;
                                    }
                                    if (this.isInQuote || this.isInComment || this.isLineComment || !var1_1.regionMatches(false, var7_9, "//", 0, 2)) break block24;
                                    this.isLineComment = true;
                                    var2_2.append("//");
                                    ++var7_9;
                                    break block21;
                                }
                                if (this.isInQuote || this.isInComment || this.isLineComment || !var1_1.regionMatches(false, var7_9, "/*", 0, 2)) break block25;
                                this.isInComment = true;
                                var2_2.append("/*");
                                ++var7_9;
                                break block21;
                            }
                            if (this.isInQuote || !this.isInComment && !this.isLineComment || !var1_1.regionMatches(false, var7_9, "*/", 0, 2)) break block26;
                            this.isInComment = false;
                            var2_2.append("*/");
                            ++var7_9;
                            break block21;
                        }
                        if (!this.isInComment && !this.isLineComment) break block27;
                        var2_2.append(var5_5);
                        break block21;
                    }
                    if (var5_5 != '\"' && var5_5 != 39) ** GOTO lbl-1000
                    if (this.isInQuote) break block28;
                    this.quoteChar = var5_5;
                    this.isInQuote = true;
                    ** GOTO lbl-1000
                }
                if (this.quoteChar == var5_5) {
                    this.isInQuote = false;
                    var2_2.append(var5_5);
                } else if (this.isInQuote) {
                    var2_2.append(var5_5);
                } else {
                    var2_2.append(var5_5);
                    var10_10 = 0;
                    while (var10_10 < this.prefs.length) {
                        var11_13 = this.prefs[var10_10];
                        if (var1_1.regionMatches(false, var7_9, var11_13, 0, var11_13.length())) {
                            var12_15 = 1;
                            if (var5_5 == '(' || var5_5 == '[' || var5_5 == ')' || var5_5 == ']') {
                                if (!("(".equals(var11_13) || var5_5 == '[' || var5_5 != ')' && var5_5 != ']')) {
                                    --this.parenDepth;
                                }
                                this.breakDepth = ++this.parenDepth;
                                if (var5_5 == ')' || var5_5 == ']' || var11_13.startsWith("()")) {
                                    ++this.breakDepth;
                                }
                                var12_15 = var5_5 == '(' || var5_5 == '[' ? (var6_6 >= 'a' && var6_6 <= 'z' || var6_6 >= 'A' && var6_6 <= 'Z' || var6_6 >= '0' && var6_6 <= '9' || var6_6 == '.' ? 1 : 0) : 1;
                            }
                            if (var11_13.length() > 1) {
                                var2_2.append(var11_13.substring(1));
                                var7_9 += var11_13.length() - 1;
                            }
                            this.registerLineBreak(var3_3, new LineBreak(var11_13, var2_2.length() + var9_7, this.breakDepth, var12_15));
                            this.breakDepth = this.parenDepth;
                            break;
                        }
                        ++var10_10;
                    }
                    var11_12 = var2_2.length() + this.wsBuffer.length() + "".length() + (this.isCut != false ? 8 : 0);
                    var12_14 = null;
                    if (var11_12 > this.preferredLineLength && var7_9 < var1_1.length() - this.lineLengthDeviation) {
                        while (!var3_3.isEmpty()) {
                            var12_14 = (LineBreak)var3_3.elementAt(0);
                            if (var12_14.breakWhere - var9_7 >= 1) break;
                            var12_14 = null;
                            var3_3.removeElementAt(0);
                        }
                        if (var12_14 != null) {
                            var3_3.removeElementAt(0);
                        }
                    }
                    if (var12_14 != null && (var13_16 = var12_14.breakWhere - var9_7 - (var12_14.breakType == 0 ? var12_14.breakStr.length() : 0)) >= 8) {
                        var14_17 = new StringBuffer();
                        var15_18 = var2_2.toString();
                        var16_19 = var15_18.substring(0, var13_16);
                        var14_17.append(var16_19);
                        this.addBrokenLine(this.wsBuffer.toString(), var14_17.toString(), var12_14, this.breakDepth, this.isCut);
                        var9_7 += var13_16;
                        var2_2 = new StringBuffer(var15_18.substring(var13_16));
                        this.isCut = true;
                    }
                }
            }
            ++var7_9;
        }
        var10_11 = new StringBuffer();
        var10_11.append((Object)var2_2);
        this.addBrokenLine(this.wsBuffer.toString(), var10_11.toString(), null, this.breakDepth, this.isCut);
    }

    private void registerLineBreak(Stack stack, LineBreak lineBreak) {
        while (!stack.isEmpty()) {
            LineBreak lineBreak2 = (LineBreak)stack.peek();
            if (this.compare(lineBreak2, lineBreak) >= 0) break;
            stack.pop();
        }
        stack.push(lineBreak);
    }

    private void addBrokenLine(String string, String string2, LineBreak lineBreak, int n, boolean bl) {
        boolean bl2 = false;
        string2 = string2.trim();
        if (this.previousLineBreak != null) {
            String string3 = (String)this.brokenLineVector.lastElement();
            if ((string2.length() + string3.length() <= this.preferredLineLength + this.lineLengthDeviation || string2.startsWith("{")) && (lineBreak == null || this.isNestedConnection && !",".equals(this.previousLineBreak.breakStr) || lineBreak.breakDepth < this.previousLineBreak.breakDepth || lineBreak.breakDepth == this.previousLineBreak.breakDepth && (!this.isNestedConnection && !",".equals(this.previousLineBreak.breakStr) || ",".equals(lineBreak.breakStr) || ";".equals(lineBreak.breakStr) || ")".equals(lineBreak.breakStr) || "]".equals(lineBreak.breakStr)))) {
                this.brokenLineVector.setElementAt(String.valueOf(string3) + " " + string2, this.brokenLineVector.size() - 1);
                bl2 = true;
            }
        }
        if (!bl2) {
            if (bl && (this.previousLineBreak == null || !",".equals(this.previousLineBreak.breakStr) || this.previousLineBreak.breakDepth != 0)) {
                string2 = "        " + string2;
            }
            string2 = String.valueOf(string) + string2;
            this.brokenLineVector.addElement(string2);
        }
        this.previousLineBreak = lineBreak;
    }

    private int compare(LineBreak lineBreak, LineBreak lineBreak2) {
        int n;
        if (lineBreak.breakDepth < lineBreak2.breakDepth) {
            return 1;
        }
        if (lineBreak.breakDepth > lineBreak2.breakDepth) {
            return -1;
        }
        int n2 = (Integer)prefTable.get(lineBreak.breakStr);
        if (n2 < (n = ((Integer)prefTable.get(lineBreak2.breakStr)).intValue())) {
            return 1;
        }
        return -1;
    }

    boolean hasMoreBrokenLines() {
        return this.brokenLineVector.size() > 0;
    }

    String nextBrokenLine() {
        if (!this.hasMoreBrokenLines()) {
            String string = "";
            return "";
        }
        String string = (String)this.brokenLineVector.firstElement();
        this.brokenLineVector.removeElementAt(0);
        return string;
    }

    static {
        prefTable.put("()", new Integer(80));
        prefTable.put("().", new Integer(90));
        prefTable.put(").", new Integer(90));
        prefTable.put("(", new Integer(80));
        prefTable.put(")", new Integer(80));
        prefTable.put("[", new Integer(80));
        prefTable.put("]", new Integer(80));
        prefTable.put(",", new Integer(10));
        prefTable.put(";", new Integer(5));
        prefTable.put("=", new Integer(20));
        prefTable.put("+=", new Integer(20));
        prefTable.put("-=", new Integer(20));
        prefTable.put("*=", new Integer(20));
        prefTable.put("/=", new Integer(20));
        prefTable.put("|=", new Integer(20));
        prefTable.put("&=", new Integer(20));
        prefTable.put("^=", new Integer(20));
        prefTable.put("?", new Integer(25));
        prefTable.put(":", new Integer(25));
        prefTable.put("||", new Integer(30));
        prefTable.put("&&", new Integer(30));
        prefTable.put("==", new Integer(40));
        prefTable.put("!=", new Integer(40));
        prefTable.put(">=", new Integer(40));
        prefTable.put("<=", new Integer(40));
        prefTable.put(">", new Integer(40));
        prefTable.put("<", new Integer(40));
        prefTable.put("+", new Integer(50));
        prefTable.put("-", new Integer(50));
        prefTable.put("*", new Integer(60));
        prefTable.put("/", new Integer(60));
        prefTable.put("%", new Integer(60));
        prefTable.put("&", new Integer(70));
        prefTable.put("|", new Integer(70));
        prefTable.put("^", new Integer(70));
    }

    class LineBreak {
        String breakStr;
        int breakWhere;
        int breakDepth;
        int breakType;

        LineBreak(String string, int n, int n2, int n3) {
            JSLineBreaker.this = JSLineBreaker.this;
            this.breakStr = string;
            this.breakWhere = n;
            this.breakDepth = n2;
            this.breakType = n3;
        }

        void dump() {
            System.out.println("LB: str=" + this.breakStr + " wh=" + this.breakWhere + " dep=" + this.breakDepth + " tp=" + this.breakType);
        }
    }
}

