/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.IOException;
import java.io.Reader;

public class InputBuffer {
    protected static final int BUFFER_SIZE = 8192;
    protected Reader reader;
    protected int bufferIndex;
    protected char[] buffer;
    protected char[][] buffers;
    protected int count;
    protected int position;
    protected int mark;
    protected boolean markSet;
    protected int current;
    protected int line;
    protected int column;
    protected int removedChars;

    public InputBuffer(Reader reader) throws IOException {
        char[][] cArrayArray = new char[5][];
        this.buffer = new char[8192];
        cArrayArray[0] = this.buffer;
        cArrayArray[1] = null;
        cArrayArray[2] = null;
        cArrayArray[3] = null;
        cArrayArray[4] = null;
        this.buffers = cArrayArray;
        this.reader = reader;
        this.line = 1;
        this.column = 1;
        this.count = this.reader.read(this.buffer, 0, 8192);
        this.current = this.count == -1 ? -1 : 0;
        this.position = -1;
        this.next();
    }

    public int current() {
        return this.current;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int next() throws IOException {
        this.next(this.markSet);
        block0 : switch (this.current) {
            case 10: {
                break;
            }
            case 13: {
                this.next(true);
                switch (this.current) {
                    case 10: {
                        ++this.removedChars;
                        break block0;
                    }
                    default: {
                        if (this.position == 0) {
                            this.position = 8191;
                            --this.bufferIndex;
                        } else {
                            --this.position;
                        }
                        this.current = 10;
                        break block0;
                    }
                    case -1: 
                }
                ++this.line;
                this.column = 1;
                return 10;
            }
            default: {
                ++this.column;
                return this.current;
            }
        }
        ++this.line;
        this.column = 1;
        return this.current;
    }

    protected void next(boolean bl) throws IOException {
        if (this.current == -1) {
            return;
        }
        ++this.position;
        if (this.position < this.count) {
            this.current = this.buffer[this.position];
        } else {
            if (this.buffers[this.bufferIndex + 1] == this.buffer) {
                ++this.bufferIndex;
                this.position = 0;
                this.current = this.buffer[0];
                return;
            }
            if (this.count < 8192) {
                this.current = -1;
                return;
            }
            if (bl) {
                ++this.bufferIndex;
                if (this.bufferIndex == this.buffers.length) {
                    char[][] cArray = this.buffers;
                    this.buffers = new char[this.buffers.length * 2][];
                    int n = 0;
                    while (n < cArray.length) {
                        this.buffers[n] = cArray[n];
                        ++n;
                    }
                }
                this.buffer = new char[8192];
                this.buffers[this.bufferIndex] = this.buffer;
                this.count = this.reader.read(this.buffer, 0, 8192);
                this.position = 0;
            } else {
                this.count = this.reader.read(this.buffer, 0, 8192);
                this.position = 0;
            }
            this.current = this.count == 0 ? -1 : this.buffer[0];
        }
    }

    public void setMark() {
        if (this.markSet) {
            throw new IllegalStateException("Mark already set");
        }
        this.markSet = true;
        this.mark = this.position;
        this.removedChars = 0;
    }

    public void resetMark() {
        if (this.bufferIndex != 0) {
            this.buffer = this.buffers[this.bufferIndex];
            this.buffers[0] = this.buffer;
            int n = 1;
            while (n <= this.bufferIndex) {
                this.buffers[n] = null;
                ++n;
            }
            this.bufferIndex = 0;
        }
        this.markSet = true;
        this.mark = this.position;
        this.removedChars = 0;
    }

    public void unsetMark() {
        if (!this.markSet) {
            throw new IllegalStateException("Mark not set");
        }
        this.markSet = false;
        if (this.bufferIndex != 0) {
            this.buffer = this.buffers[this.bufferIndex];
            this.buffers[0] = this.buffer;
            int n = 1;
            while (n <= this.bufferIndex) {
                this.buffers[n] = null;
                ++n;
            }
            this.bufferIndex = 0;
        }
    }

    public int contentSize() {
        if (!this.markSet) {
            throw new IllegalStateException("Mark not set");
        }
        return this.bufferIndex * 8192 + this.position - this.mark + (this.current != -1 ? 1 : 0) - this.removedChars;
    }

    public void readContent(char[] cArray) {
        if (!this.markSet) {
            throw new IllegalStateException("Mark not set");
        }
        int n = this.contentSize();
        if (cArray.length < n) {
            throw new IllegalArgumentException("a.length < contentSize()");
        }
        if (this.removedChars == 0) {
            if (this.bufferIndex == 0) {
                char[] cArray2 = this.buffers[0];
                int n2 = n - 1;
                while (n2 >= 0) {
                    cArray[n2] = cArray2[n2 + this.mark];
                    --n2;
                }
            } else {
                int n3;
                int n4 = 8192 - this.mark;
                char[] cArray3 = this.buffers[0];
                int n5 = n4 - 1;
                while (n5 >= 0) {
                    cArray[n5] = cArray3[n5 + this.mark];
                    --n5;
                }
                int n6 = 1;
                while (n6 < this.bufferIndex) {
                    cArray3 = this.buffers[n6];
                    n3 = 8191;
                    while (n3 >= 0) {
                        cArray[n3 + n4] = cArray3[n3];
                        --n3;
                    }
                    n4 += 8192;
                    ++n6;
                }
                n = this.position + (this.current != -1 ? 1 : 0);
                cArray3 = this.buffers[this.bufferIndex];
                n3 = n - 1;
                while (n3 >= 0) {
                    cArray[n3 + n4] = cArray3[n3];
                    --n3;
                }
            }
        } else if (this.bufferIndex == 0) {
            int n7 = this.removedChars;
            char[] cArray4 = this.buffers[0];
            int n8 = n - 1;
            while (n8 >= 0) {
                char c = cArray[n8] = cArray4[n8 + this.mark + n7];
                switch (c) {
                    case '\n': {
                        if (n8 <= 0 || cArray4[n8 + this.mark + n7 - 1] != '\r') break;
                        --n7;
                        break;
                    }
                    case '\r': {
                        cArray[n8] = 10;
                    }
                }
                --n8;
            }
        } else {
            char c;
            int n9;
            int n10;
            int n11 = 0;
            int n12 = 0;
            char[] cArray5 = this.buffers[0];
            while (n11 + this.mark + n12 < 8192) {
                cArray[n11] = cArray5[n11 + this.mark + n12];
                n10 = cArray[n11];
                if (n10 == 13) {
                    if (n11 + this.mark + n12 == 8191) {
                        if (this.buffers[1][0] == '\n') {
                            --n11;
                            ++n12;
                        }
                    } else {
                        cArray[n11] = 10;
                        if (cArray5[n11 + this.mark + n12 + 1] == '\n') {
                            ++n12;
                        }
                    }
                }
                ++n11;
            }
            n12 = 0;
            n10 = 1;
            while (n10 < this.bufferIndex) {
                cArray5 = this.buffers[n10];
                n9 = 0;
                while (n9 + n12 < 8192) {
                    cArray[n11] = cArray5[n9 + n12];
                    c = cArray[n11];
                    if (c == '\r') {
                        if (n9 + n12 == 8191) {
                            if (this.buffers[n10 + 1][0] == '\n') {
                                --n11;
                                ++n12;
                            }
                        } else {
                            cArray[n11] = 10;
                            if (cArray5[n9 + n12 + 1] == '\n') {
                                ++n12;
                            }
                        }
                    }
                    ++n11;
                    ++n9;
                }
                ++n10;
            }
            n12 = 0;
            cArray5 = this.buffers[this.bufferIndex];
            n = this.position + (this.current != -1 ? 1 : 0);
            n9 = 0;
            while (n9 + n12 < n) {
                cArray[n11] = cArray5[n9 + n12];
                c = cArray[n11];
                if (c == '\r') {
                    cArray[n11] = 10;
                    if (n9 + n12 < n - 1 && cArray5[n9 + n12 + 1] == '\n') {
                        ++n12;
                    }
                }
                ++n11;
                ++n9;
            }
        }
    }
}

