/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.batik.svggen.DOMGroupManager;
import org.apache.batik.svggen.DefaultExtensionHandler;
import org.apache.batik.svggen.DefaultImageHandler;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.GraphicContext;
import org.apache.batik.svggen.ImageHandler;
import org.apache.batik.svggen.SVGBufferedImageOp;
import org.apache.batik.svggen.SVGGraphicContext;
import org.apache.batik.svggen.SVGGraphicContextConverter;
import org.apache.batik.svggen.SVGIDGenerator;
import org.apache.batik.svggen.SVGSyntax;
import org.apache.batik.svggen.TestUtil;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DOMTreeManager
implements SVGSyntax {
    static final String ERROR_GC_NULL = "gc should not be null";
    static final String ERROR_FACTORY_NULL = "nodeFactory should not be null";
    static final String ERROR_MAXGCOVERRIDES_OUTOFRANGE = "maxGcOverrides should be greater than zero";
    static final String ERROR_EXTENSION_HANDLER_NULL = "extensionHandler should not be null";
    static final String ERROR_IMAGE_HANDLER_NULL = "imageHandler should not be null";
    static final String ERROR_TOP_LEVEL_GROUP_NULL = "topLevelGroup should not be null";
    static final String ERROR_TOP_LEVEL_GROUP_NOT_G = "topLevelGroup should be a group <g>";
    public static final String GENERATOR_COMMENT = "Generated by the Java 2D API Graphics2D SVG Generator, Sun Microsystems Inc.";
    Document domFactory;
    ImageHandler imageHandler;
    ExtensionHandler extensionHandler;
    int maxGCOverrides;
    private Vector groupManagers = new Vector();
    private Set genericDefSet = new HashSet();
    SVGGraphicContext defaultGC;
    private Element topLevelGroup;
    SVGGraphicContextConverter gcConverter;
    private SVGBufferedImageOp filterConverter;

    public SVGBufferedImageOp getFilterConverter() {
        return this.filterConverter;
    }

    public SVGGraphicContextConverter getGraphicContextConverter() {
        return this.gcConverter;
    }

    public DOMTreeManager(GraphicContext graphicContext, Document document, ExtensionHandler extensionHandler, ImageHandler imageHandler, int n) {
        if (graphicContext == null) {
            throw new IllegalArgumentException(ERROR_GC_NULL);
        }
        if (document == null) {
            throw new IllegalArgumentException(ERROR_FACTORY_NULL);
        }
        if (extensionHandler == null) {
            throw new IllegalArgumentException(ERROR_EXTENSION_HANDLER_NULL);
        }
        if (imageHandler == null) {
            throw new IllegalArgumentException(ERROR_IMAGE_HANDLER_NULL);
        }
        if (n <= 0) {
            throw new IllegalArgumentException(ERROR_MAXGCOVERRIDES_OUTOFRANGE);
        }
        this.domFactory = document;
        this.maxGCOverrides = n;
        this.extensionHandler = extensionHandler;
        this.imageHandler = imageHandler;
        this.recycleTopLevelGroup();
        this.defaultGC = this.gcConverter.toSVG(graphicContext);
    }

    public void addGroupManager(DOMGroupManager dOMGroupManager) {
        if (dOMGroupManager != null) {
            this.groupManagers.addElement(dOMGroupManager);
        }
    }

    public void removeGroupManager(DOMGroupManager dOMGroupManager) {
        if (dOMGroupManager != null) {
            this.groupManagers.removeElement(dOMGroupManager);
        }
    }

    public void appendGroup(Element element, DOMGroupManager dOMGroupManager) {
        this.topLevelGroup.appendChild(element);
        int n = this.groupManagers.size();
        int n2 = 0;
        while (n2 < n) {
            DOMGroupManager dOMGroupManager2 = (DOMGroupManager)this.groupManagers.elementAt(n2);
            if (dOMGroupManager2 != dOMGroupManager) {
                dOMGroupManager2.recycleCurrentGroup();
            }
            ++n2;
        }
    }

    private void recycleTopLevelGroup() {
        this.recycleTopLevelGroup(true);
    }

    private void recycleTopLevelGroup(boolean bl) {
        int n = this.groupManagers.size();
        int n2 = 0;
        while (n2 < n) {
            DOMGroupManager dOMGroupManager = (DOMGroupManager)this.groupManagers.elementAt(n2);
            dOMGroupManager.recycleCurrentGroup();
            ++n2;
        }
        this.topLevelGroup = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "g");
        if (bl) {
            this.filterConverter = new SVGBufferedImageOp(this.domFactory, this.extensionHandler);
            this.gcConverter = new SVGGraphicContextConverter(this.domFactory, this.extensionHandler, this.imageHandler);
        }
    }

    void setTopLevelGroup(Element element) {
        if (element == null) {
            throw new IllegalArgumentException(ERROR_TOP_LEVEL_GROUP_NULL);
        }
        if (!"g".equalsIgnoreCase(element.getTagName())) {
            throw new IllegalArgumentException(ERROR_TOP_LEVEL_GROUP_NOT_G);
        }
        this.recycleTopLevelGroup(false);
        this.topLevelGroup = element;
    }

    public Element getRoot() {
        Element element = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "svg");
        if (this.gcConverter.getCompositeConverter().getAlphaCompositeConverter().requiresBackgroundAccess()) {
            element.setAttributeNS(null, "enable-background", "new");
        }
        Comment comment = this.domFactory.createComment(GENERATOR_COMMENT);
        element.appendChild(comment);
        Map map = this.defaultGC.getGroupContext();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            element.setAttributeNS(null, string, (String)map.get(string));
        }
        element.appendChild(this.getGenericDefinitions());
        element.appendChild(this.getTopLevelGroup());
        return element;
    }

    public Element getGenericDefinitions() {
        Element element = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "defs");
        Iterator iterator = this.genericDefSet.iterator();
        while (iterator.hasNext()) {
            element.appendChild((Element)iterator.next());
        }
        element.setAttributeNS(null, "id", "genericDefs");
        return element;
    }

    public ExtensionHandler getExtensionHandler() {
        return this.extensionHandler;
    }

    void setExtensionHandler(ExtensionHandler extensionHandler) {
        this.extensionHandler = extensionHandler;
        this.filterConverter.setExtensionHandler(extensionHandler);
        this.gcConverter.setExtensionHandler(extensionHandler);
    }

    public Set getDefinitionSet() {
        Set set = this.gcConverter.getDefinitionSet();
        set.removeAll(this.genericDefSet);
        set.addAll(this.filterConverter.getDefinitionSet());
        this.filterConverter = new SVGBufferedImageOp(this.domFactory, this.extensionHandler);
        this.gcConverter = new SVGGraphicContextConverter(this.domFactory, this.extensionHandler, this.imageHandler);
        return set;
    }

    public Element getTopLevelGroup() {
        boolean bl = true;
        return this.getTopLevelGroup(bl);
    }

    public Element getTopLevelGroup(boolean bl) {
        Set set;
        Element element = this.topLevelGroup;
        if (bl && (set = this.getDefinitionSet()).size() > 0) {
            Element element2 = null;
            NodeList nodeList = element.getElementsByTagName("defs");
            if (nodeList.getLength() > 0) {
                element2 = (Element)nodeList.item(0);
            }
            if (element2 == null) {
                element2 = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "defs");
                element2.setAttributeNS(null, "id", SVGIDGenerator.generateID("defs"));
                if (element.getChildNodes().getLength() > 0) {
                    element.insertBefore(element2, element.getFirstChild());
                } else {
                    element.appendChild(element2);
                }
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                element2.appendChild((Element)iterator.next());
            }
        }
        this.recycleTopLevelGroup(false);
        return element;
    }

    public static void main(String[] stringArray) throws Exception {
        Document document = TestUtil.getDocumentPrototype();
        GraphicContext graphicContext = new GraphicContext(new AffineTransform());
        DOMTreeManager dOMTreeManager = new DOMTreeManager(graphicContext, document, new DefaultExtensionHandler(), new DefaultImageHandler(), 2);
        DOMGroupManager dOMGroupManager = new DOMGroupManager(graphicContext, dOMTreeManager);
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "rect");
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "ellipse");
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "circle");
        Element element4 = document.createElementNS("http://www.w3.org/2000/svg", "path");
        Element element5 = document.createElementNS("http://www.w3.org/2000/svg", "polygon");
        element.setAttributeNS(null, "fill", "none");
        element5.setAttributeNS(null, "stroke", "none");
        dOMGroupManager.addElement(element);
        graphicContext.setPaint(Color.red);
        dOMGroupManager.addElement(element2);
        graphicContext.setComposite(AlphaComposite.getInstance(5, 0.5f));
        dOMGroupManager.addElement(element3);
        graphicContext.setClip(new Rectangle(30, 30, 60, 60));
        graphicContext.translate(45, 45);
        GraphicContext graphicContext2 = (GraphicContext)graphicContext.clone();
        DOMGroupManager dOMGroupManager2 = new DOMGroupManager(graphicContext2, dOMTreeManager);
        dOMGroupManager2.addElement(element4);
        graphicContext2.setTransform(AffineTransform.getScaleInstance(45.0, 50.0));
        dOMGroupManager2.addElement(element5);
        Element element6 = dOMTreeManager.getTopLevelGroup();
        TestUtil.trace(element6, System.out);
    }
}

